/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.nio;

import coconut.aio.AcceptPolicy;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.impl.BaseServerSocket;
import coconut.aio.impl.nio.DefaultAioSelector;
import coconut.aio.impl.nio.NioAioProvider;
import coconut.aio.impl.nio.NioSocket;
import coconut.aio.impl.util.AioFutureTask;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.core.Callback;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NioServerSocket
extends BaseServerSocket {
    private final NioAioProvider provider;
    private final DefaultAioSelector netHandler;
    private final ServerSocketChannel channel;
    private Callable acceptCancelSubscription;

    NioServerSocket(DefaultAioSelector handler, NioAioProvider provider, long id, ServerSocketChannel channel, ServerSocketMonitor monitor, Offerable<? super AsyncServerSocket.Event> queue, Executor executor) {
        super(provider, id, monitor, queue, executor);
        this.netHandler = handler;
        this.provider = provider;
        this.channel = channel;
    }

    public ServerSocket socket() {
        return this.channel.socket();
    }

    public AsyncSocket accept() throws IOException {
        this.acceptLock.lock();
        try {
            this.isAccepting.set(true);
            this.channel.configureBlocking(true);
            NioSocket nioSocket = this.acceptNext();
            return nioSocket;
        }
        catch (IOException ioe) {
            this.userThreadClose(ioe);
            throw ioe;
        }
        finally {
            this.isAccepting.set(false);
            this.acceptLock.unlock();
        }
    }

    @Override
    protected void startAcceptingRequest(AioFutureTask event) {
        this.netHandler.serverSocketRegisterCommand(event);
    }

    @Override
    protected void startAcceptingRun(Executor e, Callback<AsyncSocket> c, Offerable<? super AsyncServerSocket.Event> o, AcceptPolicy policy) throws IOException {
        try {
            this.isAccepting.set(true);
            this.channel.configureBlocking(false);
            this.acceptCancelSubscription = this.netHandler.serverSocketStartAccepting(this, this.channel, new EventHandler(){

                public void handle(Object arg0) {
                    NioServerSocket.this.acceptEvents();
                }
            });
        }
        catch (IOException ioe) {
            this.isAccepting.set(false);
            this.aioThreadClose(ioe);
            throw ioe;
        }
    }

    @Override
    protected void stopAcceptingRequest(AioFutureTask event) {
        this.netHandler.serverSocketRegisterCommand(event);
    }

    @Override
    protected void stopAcceptingRun(AioFutureTask task) throws Exception {
        if (this.acceptCancelSubscription != null) {
            this.acceptCancelSubscription.call();
        }
    }

    @Override
    protected void closeRequest(AioFutureTask task) {
        this.netHandler.serverSocketRegisterCommand(task);
    }

    @Override
    protected void closeCommandRun(AsyncServerSocket.Closed task) throws IOException {
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptEvents() {
        boolean gotLock = this.acceptLock.tryLock();
        if (gotLock) {
            try {
                int acceptRemaining = 0;
                while (this.isAccepting()) {
                    if (acceptRemaining-- <= 0) {
                        try {
                            acceptRemaining = this.acceptPolicy.acceptNext((AsyncServerSocket)this);
                        }
                        catch (RuntimeException e) {
                            this.aioThreadClose(e);
                            this.acceptLock.unlock();
                            return;
                        }
                        if (acceptRemaining-- <= 0) {
                            return;
                        }
                    }
                    if (this.acceptNext() != null) continue;
                    return;
                }
            }
            finally {
                this.acceptLock.unlock();
            }
        }
        IllegalStateException e = new IllegalStateException("tried to asynchronously accept while already blocking accepting");
        this.aioThreadClose(e);
    }

    private NioSocket acceptNext() throws IOException {
        SocketChannel newChannel = this.channel.accept();
        if (newChannel == null) {
            return null;
        }
        newChannel.configureBlocking(false);
        NioSocket newsocket = this.provider.serverSocketSocketAccepted(this, newChannel, this.getDefaultSocketGroup());
        super.accepted(newsocket);
        return newsocket;
    }
}

