/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.nio;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.AsyncDatagramSource;
import coconut.aio.ReadHandler;
import coconut.aio.impl.BaseDatagram;
import coconut.aio.impl.BaseDatagramGroup;
import coconut.aio.impl.nio.DefaultAioSelector;
import coconut.aio.impl.nio.NioAioProvider;
import coconut.aio.impl.util.AioFutureTask;
import coconut.aio.impl.util.ByteBufferUtil;
import coconut.aio.monitor.DatagramMonitor;
import coconut.core.ErroneousHandler;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioDatagram
extends BaseDatagram {
    private static final BaseDatagramGroup CLOSED_GROUP = new BaseDatagramGroup(null, -1L, null);
    private final long id;
    private final DefaultAioSelector netHandler;
    private final DatagramChannel channel;
    private final AtomicLong commitedWriteBytes = new AtomicLong();
    private final AtomicInteger commitQueueLength = new AtomicInteger();
    private final AtomicReference<ClosedEvent> closeFuture = new AtomicReference();
    volatile Executor defaultExecutor;
    volatile Offerable<? super AsyncDatagram.Event> defaultDestination;
    private volatile long writeByteLimit = Long.MAX_VALUE;
    private volatile int writeQueueLimit = Integer.MAX_VALUE;
    private volatile Object attachment;
    private volatile EventHandler<AsyncDatagram> closeHandler;
    private volatile DatagramMonitor monitor;
    private final Lock groupLock = new ReentrantLock();
    private volatile BaseDatagramGroup group;
    private final AtomicInteger writeState = new AtomicInteger();
    private final Lock writeLock = new ReentrantLock();
    private final Queue<WrittenEvent> writes = new ConcurrentLinkedQueue<WrittenEvent>();
    private volatile WrittenEvent currentWrite;
    private Callable cancelWrite;
    private int numberOfEmptyWriteSelects;
    private int writeAttempts;
    private final ReaderSource sourceAdapter = new ReaderSource();
    private Callable cancelRead;
    private final Lock readLock = new ReentrantLock();
    private volatile ReadHandler<AsyncDatagram> reader;
    private final NioAioProvider provider;

    public NioDatagram(DefaultAioSelector handler, NioAioProvider provider, long id, DatagramChannel channel, DatagramMonitor monitor, Offerable<? super AsyncDatagram.Event> destination, Executor executor) {
        this.netHandler = handler;
        this.channel = channel;
        this.id = id;
        this.defaultExecutor = executor;
        this.defaultDestination = destination;
        this.monitor = monitor;
        this.provider = provider;
    }

    public long getId() {
        return this.id;
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public DatagramSocket socket() {
        return this.channel.socket();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public boolean isOpen() {
        return this.closeFuture.get() == null;
    }

    public String toString() {
        return this.socket().toString();
    }

    public AsyncDatagram setBufferLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeByteLimit = limit;
        return this;
    }

    public long getBufferLimit() {
        return this.writeByteLimit;
    }

    public AsyncDatagram setWriteQueueLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeQueueLimit = limit;
        return this;
    }

    public int getWriteQueueLimit() {
        return this.writeQueueLimit;
    }

    public InetAddress getInetAddress() {
        return this.socket().getInetAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket().getLocalSocketAddress();
    }

    public int getPort() {
        return this.socket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socket().getLocalAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket().getRemoteSocketAddress();
    }

    public int getLocalPort() {
        return this.socket().getLocalPort();
    }

    public boolean isBound() {
        return this.socket().isBound();
    }

    public AsyncDatagram setMonitor(DatagramMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public DatagramMonitor getMonitor() {
        return this.monitor;
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }

    public Offerable<? super AsyncDatagram.Event> getDefaultDestination() {
        return this.defaultDestination;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncDatagram setCloseHandler(EventHandler<AsyncDatagram> handler) {
        this.closeHandler = handler;
        return this;
    }

    public EventHandler<AsyncDatagram> getCloseHandler() {
        return this.closeHandler;
    }

    public AsyncDatagramGroup getGroup() {
        return this.group;
    }

    public AsyncDatagramSource getSource() {
        return this.sourceAdapter;
    }

    public ReadHandler<AsyncDatagram> getReader() {
        return this.reader;
    }

    public AsyncDatagram setGroup(AsyncDatagramGroup group) {
        if (group != null && !(group instanceof BaseDatagramGroup)) {
            throw new IllegalArgumentException("This group is not created with same provider as this socket");
        }
        this.innerSetGroup((BaseDatagramGroup)group);
        return this;
    }

    public AsyncDatagram bind(SocketAddress address) throws IOException {
        DatagramMonitor m = this.monitor;
        try {
            this.socket().bind(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncDatagram)this, address);
        }
        return this;
    }

    public AsyncDatagram connect(SocketAddress address) throws IOException {
        DatagramMonitor m = this.monitor;
        try {
            this.channel.connect(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.connectFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.connectFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.connected((AsyncDatagram)this, address);
        }
        return this;
    }

    public AsyncDatagram disconnect() throws IOException {
        DatagramMonitor m = this.monitor;
        try {
            this.channel.disconnect();
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.disconnected((AsyncDatagram)this);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.disconnected((AsyncDatagram)this);
            }
            throw e;
        }
        if (m != null) {
            m.disconnected((AsyncDatagram)this);
        }
        return this;
    }

    public AsyncDatagram.Written writeAsync(ByteBuffer buffer) {
        this.checkBufferLimit(ByteBufferUtil.calcSize(buffer));
        WrittenEvent future = new WrittenEvent(this.getRemoteSocketAddress(), buffer);
        this.writes.add(future);
        this.tryAndWriteSocketEvents();
        return future;
    }

    public List<AsyncDatagram.Written> getOutstandingWrites() {
        ArrayList w = new ArrayList(this.writes.size());
        ArrayList<AsyncDatagram.Written> l = new ArrayList<AsyncDatagram.Written>(w.size());
        WrittenEvent current = this.currentWrite;
        if (!w.contains(current) && current instanceof AsyncDatagram.Written) {
            l.add(current);
        }
        for (AsyncDatagram.Written wr : w) {
            l.add(wr);
        }
        return l;
    }

    public AsyncDatagram.Written writeAsync(ByteBuffer[] buffer, int offset, int length) {
        this.checkBufferLimit(ByteBufferUtil.calcSize(buffer));
        WrittenEvent future = new WrittenEvent(this.getRemoteSocketAddress(), buffer, offset, length);
        this.writes.add(future);
        this.tryAndWriteSocketEvents();
        return future;
    }

    public AsyncDatagram.Closed close() {
        ClosedEvent future = new ClosedEvent(null);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
        return this.closeFuture.get();
    }

    private void checkBufferLimit(long bytes) throws RejectedExecutionException {
        int currentSize;
        do {
            if ((currentSize = this.commitQueueLength.get()) == Integer.MAX_VALUE || currentSize < this.writeQueueLimit) continue;
            throw new RejectedExecutionException();
        } while (!this.commitQueueLength.compareAndSet(currentSize, currentSize + 1));
        do {
            if ((currentSize = this.commitedWriteBytes.get()) == Long.MAX_VALUE || currentSize + bytes <= this.writeByteLimit) continue;
            this.commitQueueLength.decrementAndGet();
            throw new RejectedExecutionException();
        } while (!this.commitedWriteBytes.compareAndSet(currentSize, currentSize + bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean innerSetGroup(BaseDatagramGroup newGroup) {
        try {
            this.groupLock.lock();
            BaseDatagramGroup currentGroup = this.group;
            if (currentGroup != CLOSED_GROUP && currentGroup != newGroup) {
                if (currentGroup != null) {
                    currentGroup.innerRemove((Object)this);
                }
                if (newGroup != null && newGroup != CLOSED_GROUP) {
                    this.defaultExecutor = newGroup.getDefaultExecutor();
                    this.defaultDestination = newGroup.getDefaultDestination();
                    ReadHandler<AsyncDatagram> r = newGroup.getDefaultReader();
                    if (r != null) {
                        this.setReader(this.reader);
                    }
                    newGroup.added(this);
                }
                this.group = newGroup;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.groupLock.unlock();
        }
        return false;
    }

    private void outerClose(Throwable e) {
        this.connectClose(e);
    }

    private void readClose(Throwable e) {
        this.connectClose(e);
    }

    private void writeClose(Throwable e) {
        this.connectClose(e);
    }

    private void connectClose(Throwable e) {
        ClosedEvent future = new ClosedEvent(e);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
    }

    public AsyncDatagram.ReaderSet setReader(final ReadHandler<AsyncDatagram> handler) {
        final ReaderSetEvent event = new ReaderSetEvent(handler);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EventHandler h = new EventHandler(){

                    public void handle(Object ignore) {
                        NioDatagram.this.readAvailable();
                    }
                };
                NioDatagram.this.readLock.lock();
                try {
                    NioDatagram.this.reader = handler;
                    NioDatagram.this.cancelRead = NioDatagram.this.netHandler.datagramStartReading(NioDatagram.this, NioDatagram.this.channel, h);
                    event.set((Object)null);
                }
                catch (IOException e) {
                    event.setException(e);
                    NioDatagram.this.readClose(e);
                }
                finally {
                    NioDatagram.this.readLock.unlock();
                }
            }
        };
        this.netHandler.datagramRegisterReadCommand(r);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAvailable() {
        boolean gotLock = this.readLock.tryLock();
        if (gotLock) {
            try {
                if (this.reader != null) {
                    try {
                        this.reader.handle((Object)this);
                    }
                    catch (IOException e) {
                        this.readClose(e);
                    }
                    catch (RuntimeException e) {
                        this.readClose(e);
                    }
                } else {
                    System.err.println("datagram: readAvailable");
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    private void tryAndWriteSocketEvents() {
        if (this.writeState.compareAndSet(0, 1)) {
            while (true) {
                this.currentWrite = this.writes.poll();
                if (this.currentWrite == null) {
                    this.writeState.set(0);
                    if (this.writes.size() != 0 && this.writeState.compareAndSet(0, 1)) continue;
                    return;
                }
                if (this.currentWrite.tryWrite() < 1L) break;
            }
            this.netHandler.datagramRegisterWriteCommand(this.currentWrite);
            return;
        }
    }

    private void closed(Throwable cause, IOException closeFailure) {
        EventHandler<AsyncDatagram> handler;
        DatagramMonitor m = this.monitor;
        if (m != null) {
            try {
                m.closed((AsyncDatagram)this, cause);
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        if ((handler = this.closeHandler) != null) {
            try {
                if (cause != null && handler instanceof ErroneousHandler) {
                    ((ErroneousHandler)handler).handleFailed((Object)this, cause);
                } else {
                    handler.handle((Object)this);
                }
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        this.provider.closed(this);
    }

    public AsyncDatagram.Written send(ByteBuffer src, SocketAddress target) {
        throw new UnsupportedOperationException();
    }

    public void receive(ByteBuffer dst, ReadHandler handler) {
        throw new UnsupportedOperationException();
    }

    public SocketAddress receive(ByteBuffer dst) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrittenEvent
    extends BaseEvent<Long>
    implements AsyncDatagram.Written,
    EventHandler {
        private final ByteBuffer[] srcs;
        private final int offset;
        private final int length;
        private final SocketAddress address;
        volatile long bytesWritten;

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public SocketAddress getAddress() {
            return this.address;
        }

        public ByteBuffer[] getSrcs() {
            return this.srcs;
        }

        public void handle(Object o) {
            long bytesWritten;
            while (true) {
                if (NioDatagram.this.currentWrite == null) {
                    NioDatagram.this.currentWrite = (WrittenEvent)NioDatagram.this.writes.poll();
                }
                if (NioDatagram.this.currentWrite == null) {
                    NioDatagram.this.writeState.compareAndSet(2, 0);
                    if (NioDatagram.this.writes.size() != 0 && NioDatagram.this.writeState.compareAndSet(0, 2)) continue;
                    this.deregisterSelector();
                    return;
                }
                bytesWritten = NioDatagram.this.currentWrite.tryWrite();
                if (bytesWritten <= 0L) break;
                NioDatagram.this.currentWrite = null;
            }
            if (bytesWritten == 0L) {
                return;
            }
        }

        private void deregisterSelector() {
            try {
                if (NioDatagram.this.cancelWrite != null) {
                    NioDatagram.this.cancelWrite.call();
                }
            }
            catch (Exception e) {
                NioDatagram.this.writeClose(e);
            }
        }

        private void registerSelector() {
            try {
                NioDatagram.this.cancelWrite = NioDatagram.this.netHandler.datagramStartWriting(NioDatagram.this, NioDatagram.this.channel, this);
            }
            catch (IOException ioe) {
                NioDatagram.this.writeClose(ioe);
            }
        }

        @Override
        public void run() {
            if (NioDatagram.this.writeState.compareAndSet(1, 2)) {
                while (true) {
                    if (NioDatagram.this.currentWrite == null) {
                        NioDatagram.this.currentWrite = (WrittenEvent)NioDatagram.this.writes.poll();
                    }
                    if (NioDatagram.this.currentWrite == null) {
                        NioDatagram.this.writeState.compareAndSet(2, 0);
                        if (NioDatagram.this.writes.size() != 0 && NioDatagram.this.writeState.compareAndSet(0, 2)) continue;
                        return;
                    }
                    long trywrite = NioDatagram.this.currentWrite.tryWrite();
                    if (trywrite < 1L) {
                        this.registerSelector();
                        return;
                    }
                    NioDatagram.this.currentWrite = null;
                }
            }
        }

        long tryWrite() {
            long bytes;
            DatagramMonitor m = NioDatagram.this.monitor;
            if (m != null) {
                NioDatagram.this.monitor.preWrite((AsyncDatagram)NioDatagram.this, this.getSrcs(), this.getOffset(), this.getLength());
            }
            try {
                bytes = this.getSrcs().length == 1 ? (long)NioDatagram.this.channel.write(this.getSrcs()[0]) : NioDatagram.this.channel.write(this.getSrcs(), this.getOffset(), this.getLength());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (m != null) {
                    NioDatagram.this.monitor.postWrite((AsyncDatagram)NioDatagram.this, 0L, this.getSrcs(), this.getOffset(), this.getLength(), NioDatagram.this.writeAttempts, (Throwable)e);
                }
                this.setException(e);
                NioDatagram.this.writeAttempts = 0;
                return 1L;
            }
            if (m != null) {
                NioDatagram.this.monitor.postWrite((AsyncDatagram)NioDatagram.this, bytes, this.getSrcs(), this.getOffset(), this.getLength(), NioDatagram.this.writeAttempts, null);
            }
            if (bytes > 0L) {
                this.bytesWritten += bytes;
                NioDatagram.this.bytesWritten.addAndGet(bytes);
                BaseDatagramGroup grp = NioDatagram.this.group;
                if (NioDatagram.this.group != null) {
                    NioDatagram.this.group.addNumberOfBytesWritten(bytes);
                }
                NioDatagram.this.provider.datagramWriteFinished(this);
            }
            if (!this.hasRemaining()) {
                NioDatagram.this.writeAttempts++;
                return -bytes;
            }
            NioDatagram.this.writeAttempts = 0;
            this.set(new Long(this.bytesWritten));
            return 1L;
        }

        boolean hasRemaining() {
            for (int i = 0; i < this.length; ++i) {
                if (!this.srcs[i + this.offset].hasRemaining()) continue;
                return false;
            }
            return true;
        }

        WrittenEvent(SocketAddress address, ByteBuffer[] srcs, int offset, int length) {
            this.srcs = srcs;
            this.offset = offset;
            this.length = length;
            this.address = address;
        }

        WrittenEvent(SocketAddress address, ByteBuffer src) {
            this(address, new ByteBuffer[]{src}, 0, 1);
        }
    }

    private class ClosedEvent
    extends BaseEvent
    implements AsyncDatagram.Closed {
        private final Throwable cause;

        private ClosedEvent(Throwable cause) {
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object call() throws Exception {
            try {
                NioDatagram.this.innerSetGroup(CLOSED_GROUP);
                NioDatagram.this.channel.close();
                NioDatagram.this.closed(this.cause, null);
            }
            catch (IOException e) {
                NioDatagram.this.closed(this.cause, e);
                throw e;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReaderSetEvent
    extends BaseEvent
    implements AsyncDatagram.ReaderSet {
        private final ReadHandler<AsyncDatagram> reader;

        private ReaderSetEvent(ReadHandler<AsyncDatagram> reader) {
            this.reader = reader;
        }

        @Override
        protected void set(Object v) {
            super.set(v);
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
        }

        public ReadHandler<AsyncDatagram> getReader() {
            return this.reader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncDatagram.Event>
    implements AsyncDatagram.Event {
        private BaseEvent() {
            super(NioDatagram.this.defaultExecutor, NioDatagram.this.defaultDestination);
        }

        public AsyncDatagram async() {
            return NioDatagram.this;
        }

        @Override
        public int getColor() {
            return NioDatagram.this.getColor();
        }

        public void setDestination(Offerable<? super AsyncDatagram.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncDatagram.Event> dest, final Throwable t) {
            AsyncDatagram.ErroneousEvent error = new AsyncDatagram.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public int getColor() {
                    return NioDatagram.this.getColor();
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public AsyncDatagram.Event getEvent() {
                    return BaseEvent.this;
                }

                public AsyncDatagram async() {
                    return NioDatagram.this;
                }
            };
            dest.offer((Object)error);
        }
    }

    private class ReaderSource
    implements AsyncDatagramSource {
        private ReaderSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(ByteBuffer[] srcs, int offset, int length) {
            NioDatagram.this.readLock.lock();
            try {
                DatagramMonitor m = NioDatagram.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncDatagram)NioDatagram.this, srcs, offset, length);
                    }
                    catch (RuntimeException e) {
                        NioDatagram.this.readClose(e);
                    }
                }
                long read = NioDatagram.this.channel.read(srcs, offset, length);
                if (m != null) {
                    try {
                        m.postRead((AsyncDatagram)NioDatagram.this, read, srcs, offset, length, null);
                    }
                    catch (RuntimeException e) {
                        NioDatagram.this.readClose(e);
                    }
                }
                if (read > 0L) {
                    NioDatagram.this.bytesRead.addAndGet(read);
                    BaseDatagramGroup grp = NioDatagram.this.group;
                    if (NioDatagram.this.group != null) {
                        NioDatagram.this.group.addNumberOfBytesRead(read);
                    }
                    NioDatagram.this.provider.addBytesReadDatagram(read);
                }
                if (read == -1L) {
                    if (NioDatagram.this.cancelRead != null) {
                        NioDatagram.this.cancelRead.call();
                    }
                    NioDatagram.this.readClose(new IOException("read returned -1"));
                }
                long l = read;
                return l;
            }
            catch (Exception e) {
                NioDatagram.this.readClose(e);
                long l = -1L;
                return l;
            }
            finally {
                NioDatagram.this.readLock.unlock();
            }
        }

        public long read(ByteBuffer[] srcs) {
            return this.read(srcs, 0, srcs.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer src) {
            NioDatagram.this.readLock.lock();
            try {
                DatagramMonitor m = NioDatagram.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncDatagram)NioDatagram.this, new ByteBuffer[]{src}, 0, 1);
                    }
                    catch (RuntimeException e) {
                        NioDatagram.this.readClose(e);
                    }
                }
                int read = NioDatagram.this.channel.read(src);
                if (m != null) {
                    try {
                        m.postRead((AsyncDatagram)NioDatagram.this, (long)read, new ByteBuffer[]{src}, 0, 1, null);
                    }
                    catch (RuntimeException e) {
                        NioDatagram.this.readClose(e);
                    }
                }
                if (read > 0) {
                    NioDatagram.this.bytesRead.addAndGet(read);
                    BaseDatagramGroup grp = NioDatagram.this.group;
                    if (NioDatagram.this.group != null) {
                        NioDatagram.this.group.addNumberOfBytesRead(read);
                    }
                    NioDatagram.this.provider.addBytesReadDatagram(read);
                }
                if (read == -1) {
                    if (NioDatagram.this.cancelRead != null) {
                        NioDatagram.this.cancelRead.call();
                    }
                    NioDatagram.this.readClose(new IOException("read returned -1"));
                }
                int n = read;
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
                NioDatagram.this.readClose(e);
                int n = -1;
                return n;
            }
            finally {
                NioDatagram.this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketAddress receive(ByteBuffer src) throws IOException {
            NioDatagram.this.readLock.lock();
            try {
                DatagramMonitor m = NioDatagram.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncDatagram)NioDatagram.this, new ByteBuffer[]{src}, 0, 1);
                    }
                    catch (RuntimeException e) {
                        NioDatagram.this.readClose(e);
                    }
                }
                int preRead = src.remaining();
                SocketAddress adr = NioDatagram.this.channel.receive(src);
                int read = src.remaining() - preRead;
                if (m != null) {
                    try {
                        m.postRead((AsyncDatagram)NioDatagram.this, 0L, new ByteBuffer[]{src}, 0, 1, null);
                    }
                    catch (RuntimeException e) {
                        NioDatagram.this.readClose(e);
                    }
                }
                if (read > 0) {
                    NioDatagram.this.bytesRead.addAndGet(read);
                    NioDatagram.this.provider.addBytesReadDatagram(read);
                }
                SocketAddress socketAddress = adr;
                return socketAddress;
            }
            catch (Exception e) {
                NioDatagram.this.readClose(e);
                SocketAddress socketAddress = null;
                return socketAddress;
            }
            finally {
                NioDatagram.this.readLock.unlock();
            }
        }

        public boolean isOpen() {
            return NioDatagram.this.isOpen();
        }

        public void close() throws IOException {
            NioDatagram.this.close();
        }
    }
}

