/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.nio;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncFile;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.impl.BaseDatagram;
import coconut.aio.impl.BaseFile;
import coconut.aio.impl.BaseServerSocket;
import coconut.aio.impl.BaseSocket;
import coconut.aio.impl.BaseSocketGroup;
import coconut.aio.impl.ManagedAioProvider;
import coconut.aio.impl.nio.DefaultAioSelector;
import coconut.aio.impl.nio.DefaultDiskHandler;
import coconut.aio.impl.nio.DefaultFile;
import coconut.aio.impl.nio.NioDatagram;
import coconut.aio.impl.nio.NioServerSocket;
import coconut.aio.impl.nio.NioSocket;
import coconut.aio.monitor.DatagramMonitor;
import coconut.aio.monitor.FileMonitor;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.aio.monitor.SocketMonitor;
import coconut.core.Offerable;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioAioProvider
extends ManagedAioProvider {
    private final DefaultAioSelector netHandler = new DefaultAioSelector();
    private final DefaultDiskHandler diskHandler = new DefaultDiskHandler(this);

    @Override
    protected void startupManagedDisk() throws IOException {
        this.netHandler.start();
    }

    @Override
    protected void startupManagedNet() throws IOException {
        this.netHandler.start();
    }

    @Override
    protected void stopManagedDisk() {
    }

    @Override
    protected void stopManagedNet() {
    }

    @Override
    protected BaseSocket openAsyncSocket(Offerable<? super AsyncSocket.Event> queue, Executor executor) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        SocketMonitor m = this.getDefaultSocketMonitor();
        NioSocket s = new NioSocket(this.netHandler, this, this.getNextId(), channel, m, queue, executor);
        this.opened(s);
        if (m != null) {
            m.opened((AsyncSocket)s);
        }
        return s;
    }

    @Override
    protected BaseServerSocket openAsyncServerSocket(Offerable<? super AsyncServerSocket.Event> queue, Executor executor) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        ServerSocketMonitor m = this.getDefaultServerSocketMonitor();
        NioServerSocket s = new NioServerSocket(this.netHandler, this, this.getNextId(), channel, m, queue, executor);
        if (m != null) {
            m.opened((AsyncServerSocket)s);
        }
        this.serverSocketOpened(s);
        return s;
    }

    @Override
    protected BaseFile openAsyncFile(Offerable<? super AsyncFile.Event> queue, Executor executor) {
        FileMonitor m = this.getDefaultFileMonitor();
        DefaultFile f = new DefaultFile(this, this.diskHandler, this.diskHandler.requests, this.getNextId(), m, queue, executor);
        if (m != null) {
            m.opened((AsyncFile)f);
        }
        return f;
    }

    @Override
    protected BaseDatagram openAsyncDatagram(Offerable<? super AsyncDatagram.Event> queue, Executor executor) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        DatagramMonitor m = this.getDefaultDatagramMonitor();
        NioDatagram s = new NioDatagram(this.netHandler, this, this.getNextId(), channel, m, queue, executor);
        this.opened(s);
        if (m != null) {
            m.opened((AsyncDatagram)s);
        }
        return s;
    }

    NioSocket serverSocketSocketAccepted(NioServerSocket impl, SocketChannel newChannel, BaseSocketGroup group) {
        this.incrementAccepts();
        SocketMonitor m = this.getDefaultSocketMonitor();
        NioSocket s = new NioSocket(this.netHandler, this, this.getNextId(), newChannel, m, null, null);
        this.opened(s);
        s.setGroup(group);
        if (m != null) {
            try {
                m.opened((AsyncSocket)s);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return s;
    }
}

