/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.nio;

import coconut.aio.AioFuture;
import coconut.aio.AsyncFile;
import coconut.aio.impl.BaseFile;
import coconut.aio.impl.ManagedAioProvider;
import coconut.aio.impl.nio.DefaultDiskHandler;
import coconut.aio.impl.nio.NioSocket;
import coconut.aio.impl.util.AioFutureTask;
import coconut.aio.monitor.FileMonitor;
import coconut.core.Offerable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFile
extends BaseFile {
    private final Offerable<Runnable> completion;
    private final DefaultDiskHandler netHandler;
    private volatile RandomAccessFile raf;
    private final Queue<Runnable> events = new ConcurrentLinkedQueue<Runnable>();
    private volatile File f;
    private static final int MODE_READONLY = 1;
    private static final int MODE_READWRITE = 2;
    private static final int MODE_SYNC = 4;
    private static final int MODE_SYNCMETADATA = 8;
    private volatile int mode;
    private volatile boolean isOpen;
    private static final Executor exe = Executors.newCachedThreadPool();

    DefaultFile(ManagedAioProvider provider, DefaultDiskHandler handler, Offerable<Runnable> requests, long id, FileMonitor monitor, Offerable<? super AsyncFile.Event> destination, Executor executor) {
        super(provider, id, executor, destination, monitor);
        this.completion = requests;
        this.netHandler = handler;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public AsyncFile.Opened openFile(String file, String mode) {
        return this.openFile(file, mode, false);
    }

    public AsyncFile.Opened openFile(File file, String mode) {
        return this.openFile(file, mode, false);
    }

    public AsyncFile.Opened openFile(File file, String mode, boolean create) {
        OpenedEvent o = new OpenedEvent(file, create, this.getMode(mode));
        this.execute(o);
        return o;
    }

    public AsyncFile.Opened openFile(String file, String mode, boolean create) {
        OpenedEvent o = new OpenedEvent(file, create, this.getMode(mode));
        this.execute(o);
        return o;
    }

    private int getMode(String mode) {
        if (mode.equals("r")) {
            return 1;
        }
        if (mode.equals("rw")) {
            return 2;
        }
        if (mode.equals("rws")) {
            return 4;
        }
        if (mode.equals("rwd")) {
            return 8;
        }
        throw new IllegalArgumentException("Unknown mode " + mode);
    }

    private void execute(Runnable r) {
        this.completion.offer((Object)r);
    }

    public boolean isWritable() {
        return this.mode > 1;
    }

    private void closed(IOException e) {
        if (e != null) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.f;
    }

    public AsyncFile.Closed close() {
        ClosedEvent e = new ClosedEvent(null);
        this.execute(e);
        return e;
    }

    private void closed(Throwable cause2, IOException e) {
        throw new UnsupportedOperationException();
    }

    public AsyncFile.TransferedFrom transferFrom(ReadableByteChannel src, long position, long count) {
        CountDownLatch latch = new CountDownLatch(2);
        if (!(src instanceof NioSocket)) {
            return null;
        }
        NioSocket ds = (NioSocket)((Object)src);
        Runnable event = null;
        TransferedFromEvent tfe = new TransferedFromEvent(src, ds.channel, latch, event, position, count);
        this.execute(tfe);
        return tfe;
    }

    public AsyncFile.TransferedTo transferTo(long position, long count, WritableByteChannel target) {
        CountDownLatch latch = new CountDownLatch(1);
        if (!(target instanceof NioSocket)) {
            throw new UnsupportedOperationException();
        }
        NioSocket ds = (NioSocket)((Object)target);
        NioSocket.TransferFromFileEvent event = ds.createTransferFrom(latch);
        TransferedToEvent tte = new TransferedToEvent(target, ds.channel, latch, event, position, count);
        this.execute(tte);
        return tte;
    }

    public AsyncFile.Truncated truncate(long size) {
        TruncatedEvent event = new TruncatedEvent(size);
        this.execute(event);
        return event;
    }

    class TransferedToEvent
    extends BaseEvent
    implements AsyncFile.TransferedTo {
        private final WritableByteChannel target;
        private final WritableByteChannel realTarget;
        private final CountDownLatch latch;
        private final Runnable completer;
        private final long count;
        private final long position;
        volatile long bytes;

        private TransferedToEvent(WritableByteChannel target, WritableByteChannel realTarget, CountDownLatch latch, Runnable completer, long position, long count) {
            this.target = target;
            this.realTarget = realTarget;
            this.count = count;
            this.completer = completer;
            this.latch = latch;
            this.position = position;
        }

        public Object call() throws Exception {
            if (this.latch.getCount() == 0L) {
                this.bytes = DefaultFile.this.raf.getChannel().transferTo(this.position, this.count, this.realTarget);
                return new Long(this.bytes);
            }
            System.out.println("wait a bit");
            return null;
        }

        public long getBytesTransfered() {
            return this.bytes;
        }

        public long getCount() {
            return this.count;
        }

        public long getPosition() {
            return this.position;
        }

        public WritableByteChannel getTarget() {
            return this.target;
        }
    }

    class TransferedFromEvent
    extends BaseEvent
    implements AsyncFile.TransferedFrom {
        private final ReadableByteChannel src;
        private final ReadableByteChannel realSrc;
        private final CountDownLatch latch;
        private final Runnable completer;
        private final long count;
        private final long position;
        volatile long bytes;

        private TransferedFromEvent(ReadableByteChannel src, ReadableByteChannel realSrc, CountDownLatch latch, Runnable completer, long position, long count) {
            this.src = src;
            this.realSrc = realSrc;
            this.latch = latch;
            this.completer = completer;
            this.count = count;
            this.position = position;
        }

        public Object call() throws Exception {
            return null;
        }

        public long getBytesTransfered() {
            return this.bytes;
        }

        public long getCount() {
            return this.count;
        }

        public long getPosition() {
            return this.position;
        }

        public ReadableByteChannel getSrc() {
            return this.src;
        }
    }

    private class TruncatedEvent
    extends BaseEvent
    implements AsyncFile.Truncated {
        private final long size;

        private TruncatedEvent(long size) {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public Object call() throws Exception {
            DefaultFile.this.raf.getChannel().truncate(this.size);
            return null;
        }
    }

    private class ClosedEvent
    extends BaseEvent
    implements AsyncFile.Closed {
        private final Throwable cause;

        private ClosedEvent(Throwable cause) {
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object call() throws Exception {
            DefaultFile.this.isOpen = false;
            try {
                if (DefaultFile.this.raf != null) {
                    DefaultFile.this.raf.close();
                }
            }
            catch (IOException e) {
                DefaultFile.this.closed(this.cause, e);
                throw e;
            }
            return null;
        }
    }

    private class OpenedEvent
    extends BaseEvent
    implements AsyncFile.Opened {
        private String name;
        private final int mode;
        private volatile int created;

        private OpenedEvent(String file, boolean create, int mode) {
            this.name = file;
            this.mode = mode;
            if (create) {
                this.created = 1;
            }
        }

        private OpenedEvent(File file, boolean create, int mode) {
            this.mode = mode;
            DefaultFile.this.f = file;
            if (create) {
                this.created = 1;
            }
        }

        public File getFile() {
            return DefaultFile.this.f;
        }

        public boolean isNew() {
            return this.created == 2;
        }

        public String getMode() {
            if (this.mode == 1) {
                return "r";
            }
            if (this.mode == 2) {
                return "rw";
            }
            if (this.mode == 4) {
                return "rws";
            }
            return "rwd";
        }

        public Object call() throws IOException {
            try {
                if (this.name != null) {
                    DefaultFile.this.f = new File(this.name);
                }
                if (this.created > 0 && DefaultFile.this.f.createNewFile()) {
                    this.created = 2;
                }
                DefaultFile.this.raf = new RandomAccessFile(DefaultFile.this.f, this.getMode());
                DefaultFile.this.mode = this.mode;
                DefaultFile.this.isOpen = true;
            }
            catch (IOException e) {
                DefaultFile.this.closed(e);
                throw e;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncFile.Event>
    implements AsyncFile.Event,
    AioFuture<V, AsyncFile.Event> {
        private BaseEvent() {
            super(DefaultFile.this.getDefaultExecutor(), DefaultFile.this.getDefaultDestination());
        }

        public AsyncFile async() {
            return DefaultFile.this;
        }

        @Override
        public int getColor() {
            return DefaultFile.this.getColor();
        }

        public void setDestination(Offerable<? super AsyncFile.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncFile.Event> dest, final Throwable t) {
            AsyncFile.ErroneousEvent error = new AsyncFile.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public int getColor() {
                    return DefaultFile.this.getColor();
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public AsyncFile.Event getEvent() {
                    return BaseEvent.this;
                }

                public AsyncFile async() {
                    return DefaultFile.this;
                }
            };
            dest.offer((Object)error);
        }
    }
}

