/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.nio;

import coconut.aio.impl.nio.AsyncSingleSelector;
import coconut.aio.impl.nio.NioDatagram;
import coconut.aio.impl.nio.NioServerSocket;
import coconut.aio.impl.nio.NioSocket;
import coconut.core.EventHandler;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;

final class DefaultAioSelector {
    private AsyncSingleSelector acceptHandler;
    private AsyncSingleSelector writeConnectHandler;
    private AsyncSingleSelector readHandler;

    DefaultAioSelector() {
    }

    void shutdown() {
        this.acceptHandler.shutdown();
        this.writeConnectHandler.shutdown();
        this.readHandler.shutdown();
    }

    void start() throws IOException {
        int selecttimeout = 1000;
        this.acceptHandler = new AsyncSingleSelector(new ThreadSupplier("AIO-Accept"), selecttimeout);
        this.acceptHandler.start();
        this.writeConnectHandler = new AsyncSingleSelector(new ThreadSupplier("AIO-WriteConnect"), selecttimeout);
        this.writeConnectHandler.start();
        this.readHandler = new AsyncSingleSelector(new ThreadSupplier("AIO-Read"), selecttimeout);
        this.readHandler.start();
    }

    void serverSocketRegisterCommand(Runnable runnable) {
        this.acceptHandler.addFuture(runnable);
    }

    void socketRegisterConnectCommand(Runnable runnable) {
        this.writeConnectHandler.addFuture(runnable);
    }

    void socketRegisterWriteCommand(Runnable runnable) {
        this.writeConnectHandler.addFuture(runnable);
    }

    void socketRegisterReadCommand(Runnable runnable) {
        this.readHandler.addFuture(runnable);
    }

    void datagramRegisterWriteCommand(Runnable runnable) {
        this.writeConnectHandler.addFuture(runnable);
    }

    void datagramRegisterReadCommand(Runnable runnable) {
        this.readHandler.addFuture(runnable);
    }

    Callable serverSocketStartAccepting(NioServerSocket socket, ServerSocketChannel channel, EventHandler handler) throws IOException {
        return this.acceptHandler.registerChannel(channel, 16, handler);
    }

    Callable socketStartReading(NioSocket socket, SocketChannel channel, EventHandler handler) throws IOException {
        return this.readHandler.registerChannel(channel, 1, handler);
    }

    Callable datagramStartReading(NioDatagram socket, DatagramChannel channel, EventHandler handler) throws IOException {
        return this.readHandler.registerChannel(channel, 1, handler);
    }

    void socketStartConnecting(NioSocket socket, SocketChannel channel, EventHandler handler) throws IOException {
        this.writeConnectHandler.registerChannel(channel, 8, handler);
    }

    Callable socketStartWriting(NioSocket socket, SocketChannel channel, EventHandler handler) throws IOException {
        return this.writeConnectHandler.registerChannel(channel, 4, handler);
    }

    Callable datagramStartWriting(NioDatagram socket, DatagramChannel channel, EventHandler handler) throws IOException {
        return this.writeConnectHandler.registerChannel(channel, 4, handler);
    }

    static class ThreadSupplier
    implements ThreadFactory {
        final ThreadGroup group;
        final String threadName;

        ThreadSupplier(String threadName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.threadName = threadName;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.threadName, 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

