/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.nio;

import coconut.aio.impl.nio.SelectorMonitor;
import coconut.core.EventHandler;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class AsyncSingleSelector
implements Runnable {
    private final AtomicInteger state;
    private Thread thread;
    private final Queue<Runnable> eventQueue = new ConcurrentLinkedQueue<Runnable>();
    private final SelectorMonitor monitor;
    private int selectTimeOut;
    private final Selector selector = Selector.open();
    private final ThreadFactory factory;

    AsyncSingleSelector(ThreadFactory fac, int selectTimeOut) throws IOException {
        this.thread = fac.newThread(this);
        this.thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                System.err.print("Unhandled exception " + t.getName());
                e.printStackTrace();
                AsyncSingleSelector.this.thread = AsyncSingleSelector.this.factory.newThread(AsyncSingleSelector.this);
                AsyncSingleSelector.this.state.set(SelectorState.NOT_INITED.getValue());
                AsyncSingleSelector.this.start();
            }
        });
        this.selectTimeOut = selectTimeOut;
        this.factory = fac;
        this.state = new AtomicInteger(SelectorState.NOT_INITED.getValue());
        this.monitor = new SelectorMonitor();
        this.monitor.opened(null);
    }

    long getThreadId() {
        return this.thread.getId();
    }

    void start() {
        if (!this.state.compareAndSet(SelectorState.NOT_INITED.getValue(), SelectorState.INITED.getValue())) {
            throw new IllegalStateException("state was " + this.state.get() + "expected -1");
        }
        this.thread.start();
    }

    public void run() {
        if (!this.state.compareAndSet(SelectorState.INITED.getValue(), SelectorState.STARTED.getValue())) {
            throw new IllegalStateException("state was " + this.state.get());
        }
        while (this.state.get() == SelectorState.STARTED.getValue()) {
            Runnable event = this.eventQueue.poll();
            while (event != null) {
                event.run();
                event = this.eventQueue.poll();
            }
            int selectSize = 0;
            try {
                this.monitor.preSelect(this.selectTimeOut);
                selectSize = this.selectTimeOut == 0 ? this.selector.selectNow() : (this.selectTimeOut == -1 ? this.selector.select() : this.selector.select(this.selectTimeOut));
                this.monitor.postSelect(selectSize, null);
            }
            catch (IOException e) {
                this.monitor.postSelect(0, e);
            }
            if (selectSize == 0) continue;
            Set<SelectionKey> keys = this.selector.selectedKeys();
            Iterator<SelectionKey> iter = keys.iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                iter.remove();
                try {
                    ((EventHandler)key.attachment()).handle((Object)key);
                }
                catch (Exception e1) {}
            }
        }
        try {
            this.selector.close();
            this.monitor.closed(null);
        }
        catch (IOException e) {
            this.monitor.closed(e);
        }
        if (!this.state.compareAndSet(SelectorState.STOP_NOW.getValue(), SelectorState.STOPPED.getValue())) {
            throw new IllegalStateException("state was " + this.state.get());
        }
    }

    void shutdown() {
        if (!this.state.compareAndSet(SelectorState.STARTED.getValue(), SelectorState.STOP_NOW.getValue())) {
            throw new IllegalStateException("Not running, or allready finished");
        }
        this.selector.wakeup();
        this.monitor.wakeup();
    }

    Callable registerChannel(SelectableChannel channel, int ops, EventHandler handler) throws IOException {
        SelectionKey k = null;
        try {
            k = channel.register(this.selector, ops, handler);
        }
        catch (CancelledKeyException cke) {
            this.selector.selectNow();
            k = channel.register(this.selector, ops, handler);
        }
        final SelectionKey key = k;
        return new Callable(){

            public Object call() throws IOException {
                key.cancel();
                return null;
            }
        };
    }

    void addFuture(Runnable runnable) {
        this.eventQueue.add(runnable);
        this.selector.wakeup();
        this.monitor.wakeup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectorState {
        NOT_INITED(-1),
        INITED(0),
        STARTED(1),
        STOP_NOW(2),
        STOPPED(3);

        private final int value;

        private SelectorState(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }
}

