/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.impl.AbstractAioProvider;
import coconut.aio.impl.BaseDatagram;
import coconut.aio.impl.BaseDatagramGroup;
import coconut.aio.impl.BaseServerSocket;
import coconut.aio.impl.BaseSocket;
import coconut.aio.impl.BaseSocketGroup;
import coconut.aio.impl.util.JmxEmitterSupport;
import coconut.aio.management.DatagramGroupInfo;
import coconut.aio.management.DatagramGroupMXBean;
import coconut.aio.management.DatagramInfo;
import coconut.aio.management.DatagramMXBean;
import coconut.aio.management.ServerSocketInfo;
import coconut.aio.management.ServerSocketMXBean;
import coconut.aio.management.SocketGroupInfo;
import coconut.aio.management.SocketGroupMXBean;
import coconut.aio.management.SocketInfo;
import coconut.aio.management.SocketMXBean;
import coconut.aio.monitor.DatagramGroupMonitor;
import coconut.aio.monitor.SocketGroupMonitor;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public abstract class ManagedAioProvider
extends AbstractAioProvider {
    public static final String SERVERSOCKET_OBJECT_NAME = "coconut.aio.jmx.serverSocket.objectName";
    public static final String SOCKET_OBJECT_NAME = "coconut.aio.jmx.socket.objectName";
    public static final String SOCKET_GROUP_OBJECT_NAME = "coconut.aio.jmx.socketGroup.objectName";
    public static final String DATAGRAM_OBJECT_NAME = "coconut.aio.jmx.datagram.objectName";
    public static final String DATAGRAM_GROUP_OBJECT_NAME = "coconut.aio.jmx.datagramGroup.objectName";
    public static final String FILE_OBJECT_NAME = "coconut.aio.jmx.file.objectName";
    public static final String JMX_DISABLED = "coconut.aio.jmx.disabled";
    private final ConcurrentHashMap<Long, BaseServerSocket> serverSockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, BaseSocket> sockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, BaseDatagram> datagrams = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, SocketInf> socketGroups = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, DatagramInf> datagramGroups = new ConcurrentHashMap();
    private final AtomicLong totalSockets = new AtomicLong();
    private final AtomicLong totalDatagrams = new AtomicLong();
    private final AtomicLong totalServerSockets = new AtomicLong();
    private final AtomicLong bytesWrittenOnSockets = new AtomicLong();
    private final AtomicLong bytesReadOnSockets = new AtomicLong();
    private final AtomicLong bytesWrittenOnDatagrams = new AtomicLong();
    private final AtomicLong bytesReadOnDatagrams = new AtomicLong();
    private final AtomicInteger peakSocketCount = new AtomicInteger();
    private final AtomicInteger peakServerSocketCount = new AtomicInteger();
    private final AtomicInteger peakDatagramCount = new AtomicInteger();
    private final AtomicLong totalAcceptedConnections = new AtomicLong();
    private final AtomicLong totalSocketConnections = new AtomicLong();
    private final Executor releaser;
    private final DefaultServerSocketMXBean mServerSocketbean;
    private final SocketMXBean mSocketbean;
    private final SocketGroupMXBean mSocketGroupbean;
    private final DatagramMXBean mDatagrambean;
    private final DatagramGroupMXBean mDatagramGroupbean;
    private MBeanServer mBeanServer;
    private final CopyOnWriteArrayList<ObjectName> registeredMXBeans = new CopyOnWriteArrayList();

    public ManagedAioProvider() {
        this(new RunnableExecutor());
    }

    public ManagedAioProvider(Executor releaser) {
        this.releaser = releaser;
        try {
            this.mSocketbean = new DefaultSocketMXBean();
            this.mSocketGroupbean = new DefaultSocketGroupMXBean();
            this.mDatagrambean = new DefaultDatagramMXBean();
            this.mServerSocketbean = new DefaultServerSocketMXBean();
            this.mDatagramGroupbean = new DefaultDatagramGroupMXBean();
        }
        catch (NotCompliantMBeanException mb) {
            throw new IllegalStateException(mb);
        }
    }

    public void run() {
        this.sockets.clear();
        this.serverSockets.clear();
        this.datagrams.clear();
    }

    public void opened(BaseSocket socket) {
        Long l = new Long(socket.getId());
        this.sockets.put(l, socket);
        this.totalSockets.incrementAndGet();
        int peak = this.sockets.size();
        if (peak > this.peakSocketCount.get()) {
            this.peakSocketCount.set(peak);
        }
    }

    public void opened(BaseDatagram socket) {
        Long l = new Long(socket.getId());
        this.datagrams.put(l, socket);
        this.totalDatagrams.incrementAndGet();
        int peak = this.datagrams.size();
        if (peak > this.peakDatagramCount.get()) {
            this.peakDatagramCount.set(peak);
        }
    }

    public void socketWriteFinished(AsyncSocket.Written written) {
        this.bytesWrittenOnSockets.addAndGet(written.getBytesWritten());
    }

    public void socketReadFinished(long bytes) {
        this.bytesReadOnSockets.addAndGet(bytes);
    }

    public void datagramWriteFinished(AsyncDatagram.Written written) {
        this.bytesWrittenOnDatagrams.addAndGet(written.getBytesWritten());
    }

    public void addBytesReadDatagram(long bytes) {
        this.bytesReadOnDatagrams.addAndGet(bytes);
    }

    public void incrementAccepts() {
        this.totalAcceptedConnections.incrementAndGet();
    }

    public void socketConnectedTo(AsyncSocket.Connected event) {
        this.totalSocketConnections.incrementAndGet();
    }

    public void joined(BaseDatagramGroup group, BaseDatagram socket) {
        DatagramInf grp = this.datagramGroups.get(new Long(group.getId()));
        grp.totalCount.incrementAndGet();
        int size = group.size();
        if (size > grp.peekCount.get()) {
            grp.peekCount.set(size);
        }
    }

    public void left(BaseDatagramGroup group, BaseDatagram socket) {
        DatagramInf grp = this.datagramGroups.get(new Long(group.getId()));
        grp.totalCount.decrementAndGet();
    }

    public void joined(BaseSocketGroup group, BaseSocket socket) {
        SocketInf grp = this.socketGroups.get(new Long(group.getId()));
        grp.totalCount.incrementAndGet();
        int size = group.size();
        if (size > grp.peekCount.get()) {
            grp.peekCount.set(size);
        }
    }

    public void left(BaseSocketGroup group, BaseSocket socket) {
        SocketInf grp = this.socketGroups.get(new Long(group.getId()));
        grp.totalCount.decrementAndGet();
    }

    public void socketClosed(AsyncSocket.Closed closed) {
        Long l = new Long(closed.async().getId());
        this.sockets.remove(l);
    }

    public void closed(AsyncDatagram socket) {
        Long l = new Long(socket.getId());
        this.datagrams.remove(l);
    }

    public void closed(AsyncSocketGroup group) {
        Long l = new Long(group.getId());
        this.socketGroups.remove(l);
    }

    public void closed(AsyncDatagramGroup group) {
        Long l = new Long(group.getId());
        this.datagramGroups.remove(l);
    }

    public AsyncSocketGroup openSocketGroup() {
        SocketGroupMonitor m = this.getDefaultSocketGroupMonitor();
        BaseSocketGroup group = new BaseSocketGroup(this, this.getNextId(), m);
        Long l = new Long(group.getId());
        this.socketGroups.put(l, new SocketInf(group));
        if (m != null) {
            m.opened((AsyncSocketGroup)group);
        }
        return group;
    }

    public AsyncDatagramGroup openDatagramGroup() {
        DatagramGroupMonitor m = this.getDefaultDatagramGroupMonitor();
        BaseDatagramGroup group = new BaseDatagramGroup(this, this.getNextId(), m);
        Long l = new Long(group.getId());
        this.datagramGroups.put(l, new DatagramInf(group));
        if (m != null) {
            m.opened((AsyncDatagramGroup)group);
        }
        return group;
    }

    protected void serverSocketClosed(AsyncServerSocket.Closed closed) {
        Long l = new Long(closed.async().getId());
        this.serverSockets.remove(l);
    }

    protected void serverSocketOpened(BaseServerSocket socket) {
        Long l = new Long(socket.getId());
        this.serverSockets.put(l, socket);
        int peak = this.serverSockets.size();
        if (peak > this.peakServerSocketCount.get()) {
            this.peakServerSocketCount.set(peak);
        }
        this.totalServerSockets.incrementAndGet();
    }

    public SocketMXBean getSocketMXBean() {
        return this.mSocketbean;
    }

    public DatagramMXBean getDatagramMXBean() {
        return this.mDatagrambean;
    }

    public ServerSocketMXBean getServerSocketMXBean() {
        return this.mServerSocketbean;
    }

    public SocketGroupMXBean getSocketGroupMXBean() {
        return this.mSocketGroupbean;
    }

    public DatagramGroupMXBean getDatagramGroupMXBean() {
        return this.mDatagramGroupbean;
    }

    protected abstract void stopManagedNet();

    protected abstract void stopManagedDisk();

    protected abstract void startupManagedNet() throws IOException;

    protected abstract void startupManagedDisk() throws IOException;

    protected void startupDisk() throws Exception {
        this.startupManagedDisk();
    }

    protected void startupNet() throws Exception {
        this.checkJMXStartesd();
        this.startupManagedNet();
    }

    protected void stopDisk() {
        this.stopManagedDisk();
        this.stopJMX();
    }

    protected void stopNet() {
        this.stopManagedNet();
        this.stopJMX();
    }

    private void stopJMX() {
        if (this.mBeanServer == null) {
            for (ObjectName n : this.registeredMXBeans) {
                try {
                    this.mBeanServer.unregisterMBean(n);
                }
                catch (InstanceNotFoundException e) {
                }
                catch (MBeanRegistrationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void checkJMXStartesd() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, NullPointerException {
        String disabled;
        if (this.mBeanServer == null && !Boolean.parseBoolean(disabled = properties.getProperty(JMX_DISABLED, "-1"))) {
            MBeanServer mbs;
            String agentid = properties.getProperty("coconut.aio.jmx.agentid", "");
            if (agentid.equals("")) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            } else {
                ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(agentid);
                if (list.size() == 0) {
                    throw new IllegalStateException("Could not find MBeanServer with agentid = " + agentid);
                }
                mbs = list.get(0);
            }
            this.mBeanServer = mbs;
            String serverSocketName = properties.getProperty(SERVERSOCKET_OBJECT_NAME, "coconut.aio:type=ServerSocket");
            this.register(mbs, this.mServerSocketbean, serverSocketName);
            String socketName = properties.getProperty(SOCKET_OBJECT_NAME, "coconut.aio:type=Socket");
            this.register(mbs, this.mSocketbean, socketName);
            String socketGroupName = properties.getProperty(SOCKET_GROUP_OBJECT_NAME, "coconut.aio:type=SocketGroup");
            this.register(mbs, this.mSocketGroupbean, socketGroupName);
            String datagramName = properties.getProperty(DATAGRAM_OBJECT_NAME, "coconut.aio:type=Datagram");
            this.register(mbs, this.mDatagrambean, datagramName);
            String datagramGroupName = properties.getProperty(DATAGRAM_GROUP_OBJECT_NAME, "coconut.aio:type=DatagramGroup");
            this.register(mbs, this.mDatagramGroupbean, datagramGroupName);
        }
    }

    private void register(MBeanServer server, Object bean, String name) throws MBeanRegistrationException, NotCompliantMBeanException, InstanceAlreadyExistsException, MalformedObjectNameException {
        block2: {
            String ignoreInstanceE = properties.getProperty("coconut.aio.jmx.InstanceAlreadyExistsException", "false");
            ObjectName oName = ObjectName.getInstance(name);
            try {
                server.registerMBean(bean, oName);
                this.registeredMXBeans.add(oName);
            }
            catch (InstanceAlreadyExistsException e) {
                if (ignoreInstanceE.equalsIgnoreCase("true")) break block2;
                throw e;
            }
        }
    }

    private static class RunnableExecutor
    implements Executor {
        private RunnableExecutor() {
        }

        public void execute(Runnable command) {
            command.run();
        }
    }

    private static class SocketInf {
        private final AtomicInteger peekCount = new AtomicInteger();
        private final AtomicLong totalCount = new AtomicLong();
        private final BaseSocketGroup group;

        SocketInf(BaseSocketGroup group) {
            this.group = group;
        }
    }

    private static class DatagramInf {
        private final AtomicInteger peekCount = new AtomicInteger();
        private final AtomicLong totalCount = new AtomicLong();
        private final BaseDatagramGroup group;

        DatagramInf(BaseDatagramGroup group) {
            this.group = group;
        }
    }

    private final class DefaultDatagramMXBean
    extends JmxEmitterSupport
    implements DatagramMXBean {
        protected DefaultDatagramMXBean() throws NotCompliantMBeanException {
            super(messages, DatagramMXBean.class);
        }

        protected MBeanNotificationInfo[] getNotifInfo() {
            String notifName = "java.management.Notification";
            String[] notifTypes = new String[]{"aio.serversocket.SocketAccepted", "aio.serversocket.Closed"};
            return new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, "java.management.Notification", "Coconut Cache Notification")};
        }

        public long[] getAllDatagramIds() {
            int i = 0;
            ArrayList values = new ArrayList(ManagedAioProvider.this.datagrams.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long getBytesWritten() {
            return ManagedAioProvider.this.bytesWrittenOnDatagrams.get();
        }

        public long getBytesWritten(long id) {
            BaseDatagram socket = (BaseDatagram)((Object)ManagedAioProvider.this.datagrams.get(new Long(id)));
            if (socket == null) {
                return 0L;
            }
            return socket.getNumberOfBytesWritten();
        }

        public long getBytesRead() {
            return ManagedAioProvider.this.bytesWrittenOnDatagrams.get();
        }

        public long getBytesRead(long id) {
            BaseDatagram socket = (BaseDatagram)((Object)ManagedAioProvider.this.datagrams.get(new Long(id)));
            if (socket == null) {
                return 0L;
            }
            return socket.getNumberOfBytesRead();
        }

        public long getTotalDatagramCount() {
            return ManagedAioProvider.this.totalDatagrams.get();
        }

        public int getPeakDatagramCount() {
            return ManagedAioProvider.this.peakDatagramCount.get();
        }

        public int getDatagramCount() {
            return ManagedAioProvider.this.datagrams.size();
        }

        public DatagramInfo getDatagramInfo(long id) {
            BaseDatagram socket = (BaseDatagram)((Object)ManagedAioProvider.this.datagrams.get(new Long(id)));
            if (socket != null) {
                DatagramInfo info;
                while ((info = socket.getSocketInfo()).isBound() != socket.isBound()) {
                }
                return info;
            }
            return null;
        }

        public DatagramInfo[] getDatagramInfo(long[] ids) {
            DatagramInfo info;
            DatagramInfo[] infos = new DatagramInfo[ids.length];
            for (int i = 0; i < infos.length && (info = this.getDatagramInfo(ids[i])) != null; ++i) {
                infos[i] = info;
            }
            return infos;
        }

        public void resetPeakDatagramCount() {
            ManagedAioProvider.this.peakDatagramCount.set(this.getDatagramCount());
        }
    }

    private final class DefaultSocketMXBean
    extends JmxEmitterSupport
    implements SocketMXBean {
        protected DefaultSocketMXBean() throws NotCompliantMBeanException {
            super(messages, SocketMXBean.class);
        }

        protected MBeanNotificationInfo[] getNotifInfo() {
            String notifName = "java.management.Notification";
            String[] notifTypes = new String[]{"aio.serversocket.SocketAccepted", "aio.serversocket.Closed"};
            return new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, "java.management.Notification", "Coconut Cache Notification")};
        }

        public long[] getAllSocketIds() {
            int i = 0;
            ArrayList values = new ArrayList(ManagedAioProvider.this.sockets.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long getBytesWritten() {
            return ManagedAioProvider.this.bytesWrittenOnSockets.get();
        }

        public long getBytesWritten(long id) {
            BaseSocket socket = (BaseSocket)((Object)ManagedAioProvider.this.sockets.get(new Long(id)));
            if (socket == null) {
                return 0L;
            }
            return socket.getNumberOfBytesWritten();
        }

        public long getBytesRead() {
            return ManagedAioProvider.this.bytesWrittenOnSockets.get();
        }

        public long getBytesRead(long id) {
            BaseSocket socket = (BaseSocket)((Object)ManagedAioProvider.this.sockets.get(new Long(id)));
            if (socket == null) {
                return 0L;
            }
            return socket.getNumberOfBytesRead();
        }

        public long getTotalSocketCount() {
            return ManagedAioProvider.this.totalSockets.get();
        }

        public int getPeakSocketCount() {
            return ManagedAioProvider.this.peakSocketCount.get();
        }

        public int getSocketCount() {
            return ManagedAioProvider.this.sockets.size();
        }

        public long getTotalSocketConnectCount() {
            return ManagedAioProvider.this.totalSocketConnections.get();
        }

        public SocketInfo getSocketInfo(long id) {
            BaseSocket socket = (BaseSocket)((Object)ManagedAioProvider.this.sockets.get(new Long(id)));
            if (socket != null) {
                SocketInfo info;
                while ((info = socket.getSocketInfo()).isBound() != socket.isBound()) {
                }
                return info;
            }
            return null;
        }

        public SocketInfo[] getSocketInfo(long[] ids) {
            SocketInfo info;
            SocketInfo[] infos = new SocketInfo[ids.length];
            for (int i = 0; i < infos.length && (info = this.getSocketInfo(ids[i])) != null; ++i) {
                infos[i] = info;
            }
            return infos;
        }

        public void resetPeakSocketCount() {
            ManagedAioProvider.this.peakSocketCount.set(this.getSocketCount());
        }
    }

    private final class DefaultSocketGroupMXBean
    extends JmxEmitterSupport
    implements SocketGroupMXBean {
        protected DefaultSocketGroupMXBean() throws NotCompliantMBeanException {
            super(messages, SocketGroupMXBean.class);
        }

        protected MBeanNotificationInfo[] getNotifInfo() {
            String notifName = "java.management.Notification";
            String[] notifTypes = new String[]{"aio.serversocket.SocketAccepted", "aio.serversocket.Closed"};
            return new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, "java.management.Notification", "Coconut Cache Notification")};
        }

        public long[] getAllSocketGroupIds() {
            int i = 0;
            ArrayList values = new ArrayList(ManagedAioProvider.this.socketGroups.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public int getPeakSocketCount(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.peekCount.get();
            }
            return 0;
        }

        public int getSize(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.group.size();
            }
            return 0;
        }

        public SocketGroupInfo getSocketGroupInfo(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.group.getGroupInfo();
            }
            return null;
        }

        public long[] getSocketsInGroup(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            if (group != null) {
                Object[] o = group.group.toArray();
                long[] ids = new long[o.length];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((AsyncSocket)o[i]).getId();
                }
                return ids;
            }
            return new long[0];
        }

        public long getTotalSocketCount(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.totalCount.get();
            }
            return 0L;
        }

        public void resetPeakSocketCount(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            if (group != null) {
                group.peekCount.set(this.getSize(id));
            }
        }

        public long getBytesRead(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            return group == null ? 0L : group.group.getNumberOfBytesRead();
        }

        public long getBytesWritten(long id) {
            SocketInf group = (SocketInf)ManagedAioProvider.this.socketGroups.get(new Long(id));
            return group == null ? 0L : group.group.getNumberOfBytesWritten();
        }
    }

    private final class DefaultDatagramGroupMXBean
    extends JmxEmitterSupport
    implements DatagramGroupMXBean {
        protected DefaultDatagramGroupMXBean() throws NotCompliantMBeanException {
            super(messages, DatagramGroupMXBean.class);
        }

        protected MBeanNotificationInfo[] getNotifInfo() {
            String notifName = "java.management.Notification";
            String[] notifTypes = new String[]{"aio.serversocket.SocketAccepted", "aio.serversocket.Closed"};
            return new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, "java.management.Notification", "Coconut Cache Notification")};
        }

        public long[] getAllDatagramGroupIds() {
            int i = 0;
            ArrayList values = new ArrayList(ManagedAioProvider.this.datagramGroups.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long getBytesWritten(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            return group == null ? 0L : group.group.getNumberOfBytesWritten();
        }

        public long[] getDatagramsInGroup(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            if (group != null) {
                Object[] o = group.group.toArray();
                long[] ids = new long[o.length];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((AsyncDatagram)o[i]).getId();
                }
                return ids;
            }
            return new long[0];
        }

        public long getBytesRead(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            return group == null ? 0L : group.group.getNumberOfBytesRead();
        }

        public DatagramGroupInfo getDatagramGroupInfo(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.group.getDatagramInfo();
            }
            return null;
        }

        public int getSize(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.group.size();
            }
            return 0;
        }

        public int getPeakDatagramCount(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.peekCount.get();
            }
            return 0;
        }

        public long getTotalDatagramCount(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.totalCount.get();
            }
            return 0L;
        }

        public void resetPeakDatagramCount(long id) {
            DatagramInf group = (DatagramInf)ManagedAioProvider.this.datagramGroups.get(new Long(id));
            if (group != null) {
                group.peekCount.set(this.getSize(id));
            }
        }
    }

    private final class DefaultServerSocketMXBean
    extends JmxEmitterSupport
    implements ServerSocketMXBean {
        protected DefaultServerSocketMXBean() throws NotCompliantMBeanException {
            super(messages, ServerSocketMXBean.class);
        }

        protected MBeanNotificationInfo[] getNotifInfo() {
            String notifName = "java.management.Notification";
            String[] notifTypes = new String[]{"aio.serversocket.SocketAccepted", "aio.serversocket.Closed"};
            return new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, "java.management.Notification", "Coconut Cache Notification")};
        }

        public long[] getAllServerSocketIds() {
            int i = 0;
            ArrayList values = new ArrayList(ManagedAioProvider.this.serverSockets.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long getTotalServerSocketsCount() {
            return ManagedAioProvider.this.totalServerSockets.get();
        }

        public int getPeakServerSocketCount() {
            return ManagedAioProvider.this.peakServerSocketCount.get();
        }

        public int getServerSocketCount() {
            return ManagedAioProvider.this.serverSockets.size();
        }

        public long getTotalAcceptCount() {
            return ManagedAioProvider.this.totalAcceptedConnections.get();
        }

        public long getTotalAcceptCount(long id) {
            BaseServerSocket dss = (BaseServerSocket)((Object)ManagedAioProvider.this.serverSockets.get(new Long(id)));
            return dss == null ? 0L : dss.getNumberOfAccepts();
        }

        public ServerSocketInfo getServerSocketInfo(long id) {
            BaseServerSocket serverSocket = (BaseServerSocket)((Object)ManagedAioProvider.this.serverSockets.get(new Long(id)));
            if (serverSocket != null) {
                ServerSocketInfo info;
                while ((info = serverSocket.getServerSocketInfo()).isBound() != serverSocket.isBound()) {
                }
                return info;
            }
            return null;
        }

        public ServerSocketInfo[] getServerSocketInfo(long[] ids) {
            ServerSocketInfo info;
            ServerSocketInfo[] infos = new ServerSocketInfo[ids.length];
            for (int i = 0; i < infos.length && (info = this.getServerSocketInfo(ids[i])) != null; ++i) {
                infos[i] = info;
            }
            return infos;
        }

        public void resetPeakServerSocketCount() {
            ManagedAioProvider.this.peakServerSocketCount.set(this.getServerSocketCount());
        }
    }
}

