/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl;

import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.ReadHandler;
import coconut.aio.impl.BaseSocket;
import coconut.aio.impl.ManagedAioProvider;
import coconut.aio.management.SocketGroupInfo;
import coconut.aio.monitor.SocketGroupMonitor;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSocketGroup
extends AsyncSocketGroup {
    private final long id;
    private final ManagedAioProvider mProvider;
    private final ConcurrentHashMap<BaseSocket, BaseSocket> sockets = new ConcurrentHashMap();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private volatile SocketGroupMonitor monitor;
    private volatile Executor e;
    private volatile Offerable<? super AsyncSocket.Event> offerable;
    private volatile ReadHandler<AsyncSocket> reader;
    private volatile EventHandler<AsyncSocket> joinHandler;
    private volatile EventHandler<AsyncSocket> leaveHandler;

    public BaseSocketGroup(ManagedAioProvider provider, long id, SocketGroupMonitor monitor) {
        this.monitor = monitor;
        this.id = id;
        this.mProvider = provider;
    }

    public AsyncSocketGroup setDefaultExecutor(Executor executor) {
        this.e = executor;
        return this;
    }

    public AsyncSocketGroup setDefaultDestination(Offerable<? super AsyncSocket.Event> offerable) {
        this.offerable = offerable;
        return this;
    }

    public AsyncSocketGroup setDefaultReader(ReadHandler<AsyncSocket> callback) {
        this.reader = callback;
        return this;
    }

    public AsyncSocketGroup setJoinHandler(EventHandler<AsyncSocket> handler) {
        this.joinHandler = handler;
        return this;
    }

    public boolean add(AsyncSocket socket) {
        if (socket == null) {
            throw new NullPointerException("socket is null");
        }
        if (!(socket instanceof BaseSocket)) {
            throw new IllegalArgumentException("This socket is not created with same provider as this group");
        }
        BaseSocket s = (BaseSocket)socket;
        return s.innerSetGroup(this);
    }

    public int size() {
        return this.sockets.size();
    }

    public boolean contains(Object element) {
        return this.sockets.containsKey(element);
    }

    public AsyncSocketGroup setLeaveHandler(EventHandler<AsyncSocket> handler) {
        this.leaveHandler = handler;
        return this;
    }

    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException("o is null");
        }
        BaseSocket socket = this.sockets.get(o);
        if (socket != null) {
            socket.innerSetGroup(null);
            return true;
        }
        return false;
    }

    public Iterator<AsyncSocket> iterator() {
        Iterator<AsyncSocket> i = this.sockets.values().iterator();
        return i;
    }

    public long getId() {
        return this.id;
    }

    public Executor getDefaultExecutor() {
        return this.e;
    }

    public Offerable<? super AsyncSocket.Event> getDefaultDestination() {
        return this.offerable;
    }

    public ReadHandler<AsyncSocket> getDefaultReader() {
        return this.reader;
    }

    public EventHandler<AsyncSocket> getJoinHandler() {
        return this.joinHandler;
    }

    public EventHandler<AsyncSocket> getLeaveHandler() {
        return this.leaveHandler;
    }

    public SocketGroupMonitor getMonitor() {
        return this.monitor;
    }

    public AsyncSocketGroup setMonitor(SocketGroupMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    protected void finalize() {
        this.mProvider.closed(this);
    }

    boolean innerRemove(BaseSocket socket) {
        boolean removed;
        boolean bl = removed = this.sockets.remove((Object)socket) != null;
        if (removed) {
            SocketGroupMonitor m;
            EventHandler<AsyncSocket> handler = this.leaveHandler;
            if (handler != null) {
                try {
                    handler.handle((Object)socket);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((m = this.monitor) != null) {
                try {
                    m.leave((AsyncSocketGroup)this, (AsyncSocket)socket, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return removed;
    }

    void added(BaseSocket s) {
        SocketGroupMonitor m;
        this.sockets.put(s, s);
        this.mProvider.joined(this, s);
        EventHandler<AsyncSocket> handler = this.joinHandler;
        if (handler != null) {
            try {
                handler.handle((Object)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((m = this.monitor) != null) {
            try {
                m.join((AsyncSocketGroup)this, (AsyncSocket)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void addNumberOfBytesWritten(long number) {
        this.bytesWritten.addAndGet(number);
    }

    void addNumberOfBytesRead(long number) {
        this.bytesRead.addAndGet(number);
    }

    SocketGroupInfo getGroupInfo() {
        return new SocketGroupInfo(this.id, this.size(), this.bytesRead.get(), this.bytesWritten.get());
    }

    long getNumberOfBytesRead() {
        return this.bytesRead.get();
    }

    long getNumberOfBytesWritten() {
        return this.bytesWritten.get();
    }
}

