/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl;

import coconut.aio.AioFuture;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.ReadHandler;
import coconut.aio.impl.BaseSocketGroup;
import coconut.aio.impl.ManagedAioProvider;
import coconut.aio.impl.util.AioFutureTask;
import coconut.aio.management.SocketInfo;
import coconut.aio.monitor.SocketMonitor;
import coconut.core.ErroneousHandler;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ConnectionPendingException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSocket
extends AsyncSocket {
    private static final BaseSocketGroup CLOSED_GROUP = new BaseSocketGroup(null, -1L, null);
    private final long id;
    private final AtomicLong bytesWritten = new AtomicLong();
    protected final AtomicLong bytesRead = new AtomicLong();
    protected final ManagedAioProvider mProvider;
    private final AtomicLong commitedWriteBytes = new AtomicLong();
    private final AtomicInteger commitQueueLength = new AtomicInteger();
    private final Lock writeLock = new ReentrantLock();
    private final AtomicReference<ClosedEvent> closeFuture = new AtomicReference();
    private ConnectedEvent connectionCallback;
    private volatile Object attachment;
    private volatile ReadHandler<AsyncSocket> reader;
    private volatile SocketMonitor monitor;
    private volatile Executor defaultExecutor;
    private volatile Offerable<? super AsyncSocket.Event> defaultDestination;
    private volatile long writeByteLimit = Long.MAX_VALUE;
    private volatile int writeQueueLimit = Integer.MAX_VALUE;
    private volatile EventHandler<AsyncSocket> closeHandler;
    private volatile ConnectState connectState;
    private final Lock groupLock = new ReentrantLock();
    private volatile BaseSocketGroup group;

    public BaseSocket(long id, SocketMonitor monitor, ManagedAioProvider provider, Offerable<? super AsyncSocket.Event> destination, Executor executor) {
        this.id = id;
        this.monitor = monitor;
        this.mProvider = provider;
        this.defaultDestination = destination;
        this.defaultExecutor = executor;
    }

    public long getId() {
        return this.id;
    }

    public boolean isOpen() {
        return this.closeFuture.get() == null;
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public InetAddress getInetAddress() {
        return this.socket().getInetAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket().getLocalSocketAddress();
    }

    public int getPort() {
        return this.socket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socket().getLocalAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket().getRemoteSocketAddress();
    }

    public int getLocalPort() {
        return this.socket().getLocalPort();
    }

    public boolean isBound() {
        return this.socket().isBound();
    }

    public ReadHandler<AsyncSocket> getReader() {
        return this.reader;
    }

    public String toString() {
        return this.socket().toString();
    }

    public AsyncSocket setMonitor(SocketMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SocketMonitor getMonitor() {
        return this.monitor;
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }

    public long getNumberOfBytesRead() {
        return this.bytesRead.get();
    }

    public long getNumberOfBytesWritten() {
        return this.bytesWritten.get();
    }

    public AsyncSocket setBufferLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeByteLimit = limit;
        return this;
    }

    public long getBufferLimit() {
        return this.writeByteLimit;
    }

    public AsyncSocket setWriteQueueLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeQueueLimit = limit;
        return this;
    }

    public int getWriteQueueLimit() {
        return this.writeQueueLimit;
    }

    protected void checkBufferLimit(long bytes) throws RejectedExecutionException {
        int currentSize;
        do {
            if ((currentSize = this.commitQueueLength.get()) == Integer.MAX_VALUE || currentSize < this.writeQueueLimit) continue;
            throw new RejectedExecutionException();
        } while (!this.commitQueueLength.compareAndSet(currentSize, currentSize + 1));
        do {
            if ((currentSize = this.commitedWriteBytes.get()) == Long.MAX_VALUE || currentSize + bytes <= this.writeByteLimit) continue;
            this.commitQueueLength.decrementAndGet();
            throw new RejectedExecutionException();
        } while (!this.commitedWriteBytes.compareAndSet(currentSize, currentSize + bytes));
    }

    SocketInfo getSocketInfo() {
        BaseSocketGroup group = this.getGroup();
        Socket socket = this.socket();
        return new SocketInfo(this.getId(), 0L, 0L, group == null ? 0L : group.getId(), socket.isBound(), socket.isConnected(), socket.getInetAddress(), socket.getLocalSocketAddress(), socket.getPort(), socket.getLocalPort(), socket.getRemoteSocketAddress(), socket.getLocalAddress(), this.getNumberOfBytesRead(), this.getNumberOfBytesWritten());
    }

    public Offerable<? super AsyncSocket.Event> getDefaultDestination() {
        return this.defaultDestination;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncSocket bind(SocketAddress address) throws IOException {
        SocketMonitor m = this.getMonitor();
        try {
            this.socket().bind(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncSocket)this, address);
        }
        return this;
    }

    void setDefaultExecutor(Executor executor) {
        this.defaultExecutor = executor;
    }

    void setDefaultDestination(Offerable<? super AsyncSocket.Event> destination) {
        this.defaultDestination = destination;
    }

    public AsyncSocket setCloseHandler(EventHandler<AsyncSocket> handler) {
        this.closeHandler = handler;
        return this;
    }

    public EventHandler<AsyncSocket> getCloseHandler() {
        return this.closeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean innerSetGroup(BaseSocketGroup newGroup) {
        try {
            this.groupLock.lock();
            BaseSocketGroup currentGroup = this.group;
            if (currentGroup != CLOSED_GROUP && currentGroup != newGroup) {
                if (currentGroup != null) {
                    currentGroup.innerRemove(this);
                }
                if (newGroup != null && newGroup != CLOSED_GROUP) {
                    this.setDefaultExecutor(newGroup.getDefaultExecutor());
                    this.setDefaultDestination(newGroup.getDefaultDestination());
                    ReadHandler<AsyncSocket> r = newGroup.getDefaultReader();
                    if (r != null) {
                        this.setReader(r);
                    }
                    newGroup.added(this);
                }
                this.group = newGroup;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.groupLock.unlock();
        }
        return false;
    }

    public AsyncSocket setGroup(AsyncSocketGroup group) {
        if (group != null && !(group instanceof BaseSocketGroup)) {
            throw new IllegalArgumentException("This group is not created with same provider as this socket");
        }
        this.innerSetGroup((BaseSocketGroup)group);
        return this;
    }

    public void close() throws IOException {
        this.closeNow().getIO();
    }

    public BaseSocketGroup getGroup() {
        return this.group;
    }

    protected void closeBase() {
        this.innerSetGroup(CLOSED_GROUP);
    }

    protected void setBaseReader(ReadHandler<AsyncSocket> reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AioFuture<?, AsyncSocket.Event> connect(SocketAddress address) {
        ConnectedEvent c = new ConnectedEvent(this, address);
        this.writeLock.lock();
        try {
            if (this.connectState == ConnectState.CONNECTING) {
                throw new ConnectionPendingException();
            }
            if (this.connectState == ConnectState.CONNECTED) {
                throw new AlreadyConnectedException();
            }
            if (this.tryQuickConnect(c)) {
                c.set(this);
            } else {
                this.connectState = ConnectState.CONNECTING;
                this.asynchronousConnect(c);
                this.connectionCallback = c;
            }
        }
        catch (IOException e) {
            c.setException(e);
            this.outerClose(e);
        }
        finally {
            this.writeLock.unlock();
        }
        return c;
    }

    public AioFuture<?, AsyncSocket.Event> closeNow() {
        ClosedEvent future = new ClosedEvent(this, null);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
        return this.closeFuture.get();
    }

    protected abstract boolean tryQuickConnect(ConnectedEvent var1) throws IOException;

    protected abstract void asynchronousConnect(ConnectedEvent var1);

    protected abstract void outerClose(Throwable var1);

    protected abstract void tryAndWriteSocketEvents();

    protected void monitorFailed(RuntimeException e, String msg) {
    }

    public AioFuture<Long, AsyncSocket.Event> writeAsync(ByteBuffer buffer) {
        return this.writeAsync(new ByteBuffer[]{buffer}, 0, 1);
    }

    public int write(ByteBuffer src) throws IOException {
        return ((Long)this.writeAsync(src).getIO()).intValue();
    }

    protected void dispose(AsyncSocket.Closed event, IOException closeFailure) {
        EventHandler<AsyncSocket> handler;
        SocketMonitor m;
        ConnectedEvent ce = this.connectionCallback;
        if (ce != null && !ce.isDone()) {
            ce.setException(new AsynchronousCloseException());
        }
        if ((m = this.getMonitor()) != null) {
            try {
                m.closed((AsyncSocket)this, event.getCause());
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        if ((handler = this.getCloseHandler()) != null) {
            try {
                if (event.getCause() != null && handler instanceof ErroneousHandler) {
                    ((ErroneousHandler)handler).handleFailed((Object)this, event.getCause());
                } else {
                    handler.handle((Object)this);
                }
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        this.mProvider.socketClosed(event);
    }

    protected void writeFinished(AsyncSocket.Written written) {
        long bytes = written.getBytesWritten();
        this.bytesWritten.addAndGet(bytes);
        BaseSocketGroup grp = this.getGroup();
        if (grp != null) {
            grp.addNumberOfBytesWritten(bytes);
        }
        this.mProvider.socketWriteFinished(written);
    }

    protected void addNumberOfBytesRead(BaseSocketGroup grp, long number) {
        grp.addNumberOfBytesRead(number);
    }

    protected void connectClose(Throwable e) {
        ClosedEvent future = new ClosedEvent(this, e);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
    }

    protected abstract void closeCommandRun(AsyncSocket.Closed var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConnectState {
        NOT_CONNECTED,
        CONNECTING,
        CONNECTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ConnectedEvent
    extends BaseEvent<AsyncSocket>
    implements AsyncSocket.Connected {
        private final SocketAddress address;

        private ConnectedEvent(BaseSocket socket, SocketAddress address) {
            super(socket);
            this.address = address;
        }

        public SocketAddress getSocketAddress() {
            return this.address;
        }

        @Override
        public void setException(Throwable t) {
            this.async().connectState = ConnectState.NOT_CONNECTED;
            super.setException(t);
            SocketMonitor m = this.async().getMonitor();
            if (m != null) {
                try {
                    m.connectFailed((AsyncSocket)this.async(), this.address, t);
                }
                catch (RuntimeException e) {
                    ((BaseEvent)this).socket.monitorFailed(e, "connectFailed");
                    ((BaseEvent)this).socket.connectClose(e);
                }
            }
        }

        @Override
        public void set(AsyncSocket result) {
            this.async().connectState = ConnectState.CONNECTED;
            ((BaseEvent)this).socket.mProvider.socketConnectedTo(this);
            super.set(result);
            SocketMonitor m = this.async().getMonitor();
            if (m != null) {
                try {
                    m.connected((AsyncSocket)this.async(), this.address);
                }
                catch (RuntimeException e) {
                    ((BaseEvent)this).socket.monitorFailed(e, "connected");
                    ((BaseEvent)this).socket.connectClose(e);
                }
            }
            this.async().tryAndWriteSocketEvents();
        }
    }

    private class ClosedEvent
    extends BaseEvent
    implements AsyncSocket.Closed {
        private final Throwable cause;

        private ClosedEvent(BaseSocket socket, Throwable cause) {
            super(socket);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object call() throws Exception {
            try {
                BaseSocket.this.closeBase();
                BaseSocket.this.closeCommandRun(this);
                BaseSocket.this.dispose(this, null);
            }
            catch (IOException e) {
                BaseSocket.this.dispose(this, e);
                throw e;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncSocket.Event>
    implements AsyncSocket.Event,
    AioFuture<V, AsyncSocket.Event> {
        private final BaseSocket socket;

        public BaseEvent(BaseSocket socket) {
            super(socket.getDefaultExecutor(), socket.getDefaultDestination());
            this.socket = socket;
        }

        public BaseSocket async() {
            return this.socket;
        }

        @Override
        public int getColor() {
            return this.socket.getColor();
        }

        public void setDestination(Offerable<? super AsyncSocket.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncSocket.Event> dest, final Throwable t) {
            AsyncSocket.ErroneousEvent error = new AsyncSocket.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public int getColor() {
                    return BaseEvent.this.socket.getColor();
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public AsyncSocket.Event getEvent() {
                    return BaseEvent.this;
                }

                public AsyncSocket async() {
                    return BaseEvent.this.socket;
                }
            };
            dest.offer((Object)error);
        }
    }
}

