/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl;

import coconut.aio.AcceptPolicy;
import coconut.aio.AioFuture;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.impl.BaseSocket;
import coconut.aio.impl.BaseSocketGroup;
import coconut.aio.impl.ManagedAioProvider;
import coconut.aio.impl.util.AioFutureTask;
import coconut.aio.management.ServerSocketInfo;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.core.Callback;
import coconut.core.ErroneousHandler;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServerSocket
extends AsyncServerSocket {
    private static final AcceptPolicy ACCEPT_ALL_POLICY = new AcceptPolicy(){

        public int acceptNext(AsyncServerSocket socket) {
            return Integer.MAX_VALUE;
        }
    };
    private final long id;
    private final AtomicLong acceptanceCount = new AtomicLong();
    private final ManagedAioProvider provider;
    private final AtomicReference<ClosedEvent> closeFuture = new AtomicReference();
    protected final Lock acceptLock = new ReentrantLock();
    private volatile ServerSocketMonitor monitor;
    private volatile Object attachment;
    private volatile EventHandler<AsyncServerSocket> closeHandler;
    private volatile Executor defaultExecutor;
    private volatile Offerable<? super AsyncServerSocket.Event> defaultOfferable;
    private volatile BaseSocketGroup defaultAcceptedSocketGroup;
    private Offerable<? super AsyncServerSocket.Event> acceptanceSink;
    private Callback<AsyncSocket> acceptanceCallback;
    private Executor acceptanceExecutor;
    protected final AtomicBoolean isAccepting = new AtomicBoolean();
    protected AcceptPolicy acceptPolicy;

    public BaseServerSocket(ManagedAioProvider provider, long id, ServerSocketMonitor monitor, Offerable<? super AsyncServerSocket.Event> queue, Executor executor) {
        this.id = id;
        this.provider = provider;
        this.monitor = monitor;
        this.defaultExecutor = executor;
        this.defaultOfferable = queue;
    }

    public long getId() {
        return this.id;
    }

    public boolean isOpen() {
        return this.closeFuture.get() == null;
    }

    public boolean isAccepting() {
        return this.isAccepting.get();
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }

    public boolean isBound() {
        return this.socket().isBound();
    }

    public InetAddress getInetAddress() {
        return this.socket().getInetAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket().getLocalSocketAddress();
    }

    public AsyncServerSocket bind(SocketAddress address) throws IOException {
        ServerSocketMonitor m = this.getMonitor();
        try {
            this.socket().bind(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncServerSocket)this, address);
        }
        return this;
    }

    public AsyncServerSocket bind(SocketAddress address, int backlog) throws IOException {
        ServerSocketMonitor m = this.getMonitor();
        try {
            this.socket().bind(address, backlog);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncServerSocket)this, address);
        }
        return this;
    }

    public int getLocalPort() {
        return this.socket().getLocalPort();
    }

    public String toString() {
        return this.socket().toString();
    }

    public AsyncServerSocket setMonitor(ServerSocketMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public ServerSocketMonitor getMonitor() {
        return this.monitor;
    }

    public Offerable<? super AsyncServerSocket.Event> getDefaultDestination() {
        return this.defaultOfferable;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncServerSocket setCloseHandler(EventHandler<AsyncServerSocket> handler) {
        this.closeHandler = handler;
        return this;
    }

    public EventHandler<AsyncServerSocket> getCloseHandler() {
        return this.closeHandler;
    }

    public AsyncServerSocket setDefaultSocketGroup(AsyncSocketGroup group) {
        if (group != null && !(group instanceof BaseSocketGroup)) {
            throw new IllegalArgumentException("This group is not created with same provider as this socket");
        }
        this.defaultAcceptedSocketGroup = (BaseSocketGroup)group;
        return this;
    }

    public BaseSocketGroup getDefaultSocketGroup() {
        return this.defaultAcceptedSocketGroup;
    }

    protected void accepted(final BaseSocket socket) {
        Offerable<? super AsyncServerSocket.Event> sink;
        this.acceptanceCount.incrementAndGet();
        ServerSocketMonitor m = this.getMonitor();
        if (m != null) {
            try {
                m.accepted((AsyncServerSocket)this, (AsyncSocket)socket);
            }
            catch (RuntimeException e) {
                this.aioThreadClose(e);
                return;
            }
        }
        if ((sink = this.acceptanceSink) != null) {
            SocketAcceptedEvent event = new SocketAcceptedEvent(this, socket);
            try {
                sink.offer((Object)event);
            }
            catch (RuntimeException e) {
                this.aioThreadClose(e);
                return;
            }
        }
        Executor executor = this.acceptanceExecutor;
        final Callback<AsyncSocket> callback = this.acceptanceCallback;
        if (executor != null && callback != null) {
            try {
                executor.execute(new Runnable(){

                    public void run() {
                        try {
                            callback.completed((Object)socket);
                        }
                        catch (RuntimeException e) {
                            BaseServerSocket.this.userThreadClose(e);
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                this.aioThreadClose(e);
                return;
            }
        }
    }

    public AioFuture<?, AsyncServerSocket.Event> startAccepting(Executor executor, Callback<AsyncSocket> callback) {
        return this.startAccepting(executor, callback, ACCEPT_ALL_POLICY);
    }

    public AioFuture<?, AsyncServerSocket.Event> startAccepting(Offerable<? super AsyncServerSocket.Event> offerable) {
        return this.startAccepting(offerable, ACCEPT_ALL_POLICY);
    }

    public AioFuture<?, AsyncServerSocket.Event> startAccepting(Executor executor, Callback<AsyncSocket> callback, AcceptPolicy policy) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        AcceptanceStartedEvent event = new AcceptanceStartedEvent(this, executor, callback, null, policy);
        this.startAcceptingRequest(event);
        return event;
    }

    public AioFuture<?, AsyncServerSocket.Event> startAccepting(Offerable<? super AsyncServerSocket.Event> offerable, AcceptPolicy policy) {
        if (offerable == null) {
            throw new NullPointerException("offerable");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        AcceptanceStartedEvent event = new AcceptanceStartedEvent(this, null, null, offerable, policy);
        this.startAcceptingRequest(event);
        return event;
    }

    public AioFuture<?, AsyncServerSocket.Event> stopAccepting() {
        AcceptanceStoppedEvent event = new AcceptanceStoppedEvent(this);
        this.stopAcceptingRequest(event);
        return event;
    }

    public AioFuture<?, AsyncServerSocket.Event> close() {
        ClosedEvent event = new ClosedEvent(this, null);
        if (this.closeFuture.compareAndSet(null, event)) {
            this.closeRequest(event);
            return event;
        }
        return this.closeFuture.get();
    }

    ServerSocketInfo getServerSocketInfo() {
        return new ServerSocketInfo(this.getId(), 0L, 0L, this.getNumberOfAccepts(), this.isBound(), this.getInetAddress(), this.getLocalPort(), this.getLocalSocketAddress());
    }

    long getNumberOfAccepts() {
        return this.acceptanceCount.get();
    }

    protected abstract void startAcceptingRequest(AioFutureTask var1);

    protected abstract void startAcceptingRun(Executor var1, Callback<AsyncSocket> var2, Offerable<? super AsyncServerSocket.Event> var3, AcceptPolicy var4) throws IOException;

    protected abstract void stopAcceptingRequest(AioFutureTask var1);

    protected abstract void stopAcceptingRun(AioFutureTask var1) throws Exception;

    protected abstract void closeRequest(AioFutureTask var1);

    protected abstract void closeCommandRun(AsyncServerSocket.Closed var1) throws IOException;

    protected void userThreadClose(Throwable ioe) {
        ClosedEvent event = new ClosedEvent(this, ioe);
        if (this.closeFuture.compareAndSet(null, event)) {
            this.closeRequest(event);
        }
    }

    protected void aioThreadClose(Throwable ioe) {
        ClosedEvent event = new ClosedEvent(this, ioe);
        if (this.closeFuture.compareAndSet(null, event)) {
            event.run();
        }
    }

    private void dispose(AsyncServerSocket.Closed event, Throwable closeFailure) {
        EventHandler<AsyncServerSocket> handler;
        ServerSocketMonitor m = this.getMonitor();
        if (m != null) {
            try {
                m.closed((AsyncServerSocket)this, event.getCause());
            }
            catch (RuntimeException e) {
                this.provider.unhandledException((Object)this, "closed() called on monitor", e);
            }
        }
        if ((handler = this.getCloseHandler()) != null) {
            try {
                if (event.getCause() != null && handler instanceof ErroneousHandler) {
                    ((ErroneousHandler)handler).handleFailed((Object)this, event.getCause());
                } else {
                    handler.handle((Object)this);
                }
            }
            catch (RuntimeException e) {
                this.provider.unhandledException((Object)this, "handle() called on close monitor", e);
            }
        }
        this.provider.serverSocketClosed(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClosedEvent
    extends BaseEvent<AsyncServerSocket>
    implements AsyncServerSocket.Closed {
        private final Throwable cause;

        private ClosedEvent(BaseServerSocket socket, Throwable cause) {
            super(socket);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AsyncServerSocket call() {
            try {
                ((BaseEvent)this).socket.closeCommandRun(this);
                ((BaseEvent)this).socket.dispose(this, null);
            }
            catch (Exception e) {
                ((BaseEvent)this).socket.dispose(this, e);
            }
            finally {
                ((BaseEvent)this).socket.isAccepting.set(false);
            }
            return ((BaseEvent)this).socket;
        }
    }

    private static final class AcceptanceStoppedEvent
    extends BaseEvent
    implements AsyncServerSocket.AcceptingStopped {
        private AcceptanceStoppedEvent(BaseServerSocket socket) {
            super(socket);
        }

        public Object call() throws Exception {
            boolean gotLock = ((BaseEvent)this).socket.acceptLock.tryLock();
            if (gotLock) {
                try {
                    ((BaseEvent)this).socket.isAccepting.set(false);
                    ((BaseEvent)this).socket.acceptPolicy = null;
                    ((BaseEvent)this).socket.acceptanceCallback = null;
                    ((BaseEvent)this).socket.acceptanceExecutor = null;
                    ((BaseEvent)this).socket.acceptanceSink = null;
                    ((BaseEvent)this).socket.stopAcceptingRun(this);
                }
                catch (Exception e) {
                    ((BaseEvent)this).socket.aioThreadClose(e);
                    throw e;
                }
                finally {
                    ((BaseEvent)this).socket.acceptLock.unlock();
                }
            } else {
                IllegalStateException e = new IllegalStateException("tried to asynchronously stop accepting while already blocking accepting");
                ((BaseEvent)this).socket.aioThreadClose(e);
                throw e;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AcceptanceStartedEvent
    extends BaseEvent<AsyncServerSocket>
    implements AsyncServerSocket.AcceptingStarted {
        private final AcceptPolicy policy;
        private final Executor aExecutor;
        private final Offerable<? super AsyncServerSocket.Event> AOfferable;
        private final Callback<AsyncSocket> aCallback;

        private AcceptanceStartedEvent(BaseServerSocket socket, Executor e, Callback<AsyncSocket> c, Offerable<? super AsyncServerSocket.Event> o, AcceptPolicy policy) {
            super(socket);
            this.aCallback = c;
            this.aExecutor = e;
            this.AOfferable = o;
            this.policy = policy;
        }

        public AcceptPolicy getPolicy() {
            return this.policy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AsyncServerSocket call() throws IOException {
            if (this.async().acceptLock.tryLock()) {
                try {
                    this.async().startAcceptingRun(this.aExecutor, this.aCallback, this.AOfferable, this.policy);
                    this.async().acceptPolicy = this.policy;
                    this.async().acceptanceCallback = this.aCallback;
                    this.async().acceptanceExecutor = this.aExecutor;
                    this.async().acceptanceSink = this.AOfferable;
                }
                finally {
                    this.async().acceptLock.unlock();
                }
            } else {
                IllegalStateException ee = new IllegalStateException("tried to asynchronously start accepting while already blocking accepting");
                this.async().aioThreadClose(ee);
                throw ee;
            }
            return null;
        }
    }

    private static final class SocketAcceptedEvent
    extends BaseEvent
    implements AsyncServerSocket.SocketAccepted {
        private final AsyncSocket socket;

        public SocketAcceptedEvent(BaseServerSocket serverSocket, AsyncSocket socket) {
            super(serverSocket);
            this.socket = socket;
        }

        public AsyncSocket getAcceptedSocket() {
            return this.socket;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ErrorEvent<V>
    implements AsyncServerSocket.ErroneousEvent {
        private final Throwable cause;
        private final BaseEvent<V> event;

        public ErrorEvent(BaseEvent<V> event, Throwable cause) {
            this.cause = cause;
            this.event = event;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String getMessage() {
            return this.cause.getMessage();
        }

        public AsyncServerSocket.Event getEvent() {
            return this.event;
        }

        public AsyncServerSocket async() {
            return this.event.async();
        }

        public int getColor() {
            return this.event.getColor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncServerSocket.Event>
    implements AsyncServerSocket.Event {
        private final BaseServerSocket socket;

        protected BaseEvent(BaseServerSocket socket) {
            super(socket.getDefaultExecutor(), socket.getDefaultDestination());
            this.socket = socket;
        }

        public BaseServerSocket async() {
            return this.socket;
        }

        @Override
        public int getColor() {
            return this.socket.getColor();
        }

        public void setDestination(Offerable<? super AsyncServerSocket.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncServerSocket.Event> dest, Throwable t) {
            dest.offer(new ErrorEvent(this, t));
        }
    }
}

