/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl;

import coconut.aio.AsyncFile;
import coconut.aio.impl.ManagedAioProvider;
import coconut.aio.monitor.FileMonitor;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFile
extends AsyncFile {
    private final long id;
    private final ManagedAioProvider provider;
    private final AtomicReference<AsyncFile.Closed> closeFuture = new AtomicReference();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    volatile Executor defaultExecutor;
    volatile Offerable<? super AsyncFile.Event> defaultDestination;
    private volatile Object attachment;
    private volatile EventHandler<AsyncFile> closeHandler;
    private volatile FileMonitor monitor;

    public BaseFile(ManagedAioProvider provider, long id, Executor defaultExecutor, Offerable<? super AsyncFile.Event> defaultDestination, FileMonitor monitor) {
        this.id = id;
        this.provider = provider;
        this.defaultExecutor = defaultExecutor;
        this.defaultDestination = defaultDestination;
        this.monitor = monitor;
    }

    public long getId() {
        return this.id;
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public Offerable<? super AsyncFile.Event> getDefaultDestination() {
        return this.defaultDestination;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncFile setMonitor(FileMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public FileMonitor getMonitor() {
        return this.monitor;
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }
}

