/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.ReadHandler;
import coconut.aio.impl.BaseDatagram;
import coconut.aio.impl.ManagedAioProvider;
import coconut.aio.management.DatagramGroupInfo;
import coconut.aio.monitor.DatagramGroupMonitor;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDatagramGroup
extends AsyncDatagramGroup {
    private final ConcurrentHashMap<AsyncDatagram, AsyncDatagram> sockets = new ConcurrentHashMap();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private volatile DatagramGroupMonitor monitor;
    private final long id;
    private final ManagedAioProvider mProvider;
    private volatile Executor e;
    private volatile Offerable<? super AsyncDatagram.Event> offerable;
    private volatile ReadHandler<AsyncDatagram> reader;
    private volatile EventHandler<AsyncDatagram> joinHandler;
    private volatile EventHandler<AsyncDatagram> leaveHandler;

    public BaseDatagramGroup(ManagedAioProvider mProvider, long id, DatagramGroupMonitor monitor) {
        this.monitor = monitor;
        this.id = id;
        this.mProvider = mProvider;
    }

    public AsyncDatagramGroup setDefaultExecutor(Executor executor) {
        this.e = executor;
        return this;
    }

    public AsyncDatagramGroup setDefaultDestination(Offerable<? super AsyncDatagram.Event> offerable) {
        this.offerable = offerable;
        return this;
    }

    public AsyncDatagramGroup setDefaultReader(ReadHandler<AsyncDatagram> callback) {
        this.reader = callback;
        return this;
    }

    public AsyncDatagramGroup setJoinHandler(EventHandler<AsyncDatagram> handler) {
        this.joinHandler = handler;
        return this;
    }

    public void added(BaseDatagram s) {
        DatagramGroupMonitor m;
        this.sockets.put(s, s);
        this.groupJoined(this, s);
        EventHandler<AsyncDatagram> handler = this.joinHandler;
        if (handler != null) {
            try {
                handler.handle((Object)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((m = this.monitor) != null) {
            try {
                m.join((AsyncDatagramGroup)this, (AsyncDatagram)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean add(AsyncDatagram socket) {
        if (!(socket instanceof BaseDatagram)) {
            throw new IllegalArgumentException("This socket is not created with same provider as this group");
        }
        BaseDatagram s = (BaseDatagram)socket;
        return s.innerSetGroup(this);
    }

    public int size() {
        return this.sockets.size();
    }

    public boolean contains(Object element) {
        return this.sockets.containsKey(element);
    }

    public AsyncDatagramGroup setLeaveHandler(EventHandler<AsyncDatagram> handler) {
        this.leaveHandler = handler;
        return this;
    }

    public boolean innerRemove(Object o) {
        boolean removed;
        boolean bl = removed = this.sockets.remove(o) != null;
        if (removed) {
            DatagramGroupMonitor m;
            BaseDatagram socket = (BaseDatagram)((Object)o);
            EventHandler<AsyncDatagram> handler = this.leaveHandler;
            if (handler != null) {
                handler.handle((Object)socket);
            }
            if ((m = this.monitor) != null) {
                try {
                    m.leave((AsyncDatagramGroup)this, (AsyncDatagram)socket, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return removed;
    }

    public boolean remove(Object o) {
        BaseDatagram socket = (BaseDatagram)this.sockets.get(o);
        if (socket != null) {
            socket.innerSetGroup(null);
            return true;
        }
        return false;
    }

    public Iterator<AsyncDatagram> iterator() {
        return this.sockets.values().iterator();
    }

    public long getId() {
        return this.id;
    }

    public Executor getDefaultExecutor() {
        return this.e;
    }

    public Offerable<? super AsyncDatagram.Event> getDefaultDestination() {
        return this.offerable;
    }

    public ReadHandler<AsyncDatagram> getDefaultReader() {
        return this.reader;
    }

    public EventHandler<AsyncDatagram> getJoinHandler() {
        return this.joinHandler;
    }

    public EventHandler<AsyncDatagram> getLeaveHandler() {
        return this.leaveHandler;
    }

    protected void finalize() {
        this.groupClosed(this);
    }

    public DatagramGroupMonitor getMonitor() {
        return this.monitor;
    }

    public AsyncDatagramGroup setMonitor(DatagramGroupMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    DatagramGroupInfo getDatagramInfo() {
        return new DatagramGroupInfo(this.id, this.size(), this.bytesRead.get(), this.bytesWritten.get());
    }

    public long getNumberOfBytesRead() {
        return this.bytesRead.get();
    }

    public void addNumberOfBytesRead(long number) {
        this.bytesRead.addAndGet(number);
    }

    public long getNumberOfBytesWritten() {
        return this.bytesWritten.get();
    }

    public void addNumberOfBytesWritten(long number) {
        this.bytesWritten.addAndGet(number);
    }

    public void groupJoined(BaseDatagramGroup group, BaseDatagram socket) {
        this.mProvider.joined(group, socket);
    }

    public void groupClosed(BaseDatagramGroup group) {
        this.mProvider.closed(group);
    }
}

