/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncFile;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.impl.BaseDatagram;
import coconut.aio.impl.BaseFile;
import coconut.aio.impl.BaseServerSocket;
import coconut.aio.impl.BaseSocket;
import coconut.aio.management.FileMXBean;
import coconut.aio.monitor.DatagramGroupMonitor;
import coconut.aio.monitor.DatagramMonitor;
import coconut.aio.monitor.FileMonitor;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.aio.monitor.SocketGroupMonitor;
import coconut.aio.monitor.SocketMonitor;
import coconut.aio.spi.AioErrorHandler;
import coconut.aio.spi.AioProvider;
import coconut.core.Offerable;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAioProvider
extends AioProvider {
    private final Lock lock = new ReentrantLock();
    private final AtomicLong idGenerator = new AtomicLong();
    volatile ServerSocketMonitor defaultServerSocketMonitor;
    volatile SocketGroupMonitor defaultSocketGroupMonitor;
    volatile SocketMonitor defaultSocketMonitor;
    volatile DatagramGroupMonitor defaultDatagramGroupMonitor;
    volatile DatagramMonitor defaultDatagramMonitor;
    volatile FileMonitor defaultFileMonitor;
    private AioStatus diskStatus = AioStatus.NOT_STARTED;
    private AioStatus netStatus = AioStatus.NOT_STARTED;
    private volatile AioErrorHandler defaultHandler;

    protected abstract void startupDisk() throws Exception;

    protected abstract void startupNet() throws Exception;

    protected abstract void stopDisk();

    protected abstract void stopNet();

    protected abstract BaseSocket openAsyncSocket(Offerable<? super AsyncSocket.Event> var1, Executor var2) throws IOException;

    protected abstract BaseServerSocket openAsyncServerSocket(Offerable<? super AsyncServerSocket.Event> var1, Executor var2) throws IOException;

    protected abstract BaseFile openAsyncFile(Offerable<? super AsyncFile.Event> var1, Executor var2);

    protected abstract BaseDatagram openAsyncDatagram(Offerable<? super AsyncDatagram.Event> var1, Executor var2) throws IOException;

    protected final long getNextId() {
        return this.idGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNetStarted() {
        block7: {
            try {
                this.lock.lock();
                if (this.netStatus == AioStatus.NOT_STARTED) {
                    try {
                        this.startupNet();
                        this.netStatus = AioStatus.RUNNING;
                        break block7;
                    }
                    catch (Exception ioe) {
                        throw new IllegalStateException("Could not start AIO layer", ioe);
                    }
                }
                if (this.netStatus == AioStatus.DEAD) {
                    throw new IllegalStateException("Coconut-AIO layer closed");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileStarted() {
        block7: {
            try {
                this.lock.lock();
                if (this.diskStatus == AioStatus.NOT_STARTED) {
                    try {
                        this.startupDisk();
                        this.diskStatus = AioStatus.RUNNING;
                        break block7;
                    }
                    catch (Exception ioe) {
                        throw new IllegalStateException("Could not start AIO layer", ioe);
                    }
                }
                if (this.diskStatus == AioStatus.DEAD) {
                    throw new IllegalStateException("Coconut-AIO layer closed");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.lock.lock();
            if (this.netStatus == AioStatus.RUNNING) {
                this.stopNet();
            }
            if (this.diskStatus == AioStatus.RUNNING) {
                this.stopDisk();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public AsyncServerSocket openServerSocket() throws IOException {
        this.checkNetStarted();
        return this.openAsyncServerSocket(null, null);
    }

    public AsyncDatagram openDatagram() throws IOException {
        this.checkNetStarted();
        return this.openAsyncDatagram(null, null);
    }

    public AsyncFile openFile() {
        this.checkFileStarted();
        return this.openAsyncFile(null, null);
    }

    public AsyncSocket openSocket() throws IOException {
        this.checkNetStarted();
        return this.openAsyncSocket(null, null);
    }

    public AsyncServerSocket openServerSocket(Offerable<? super AsyncServerSocket.Event> destination) throws IOException {
        this.checkNetStarted();
        return this.openAsyncServerSocket(destination, null);
    }

    public AsyncDatagram openDatagram(Offerable<? super AsyncDatagram.Event> destination) throws IOException {
        this.checkNetStarted();
        return this.openAsyncDatagram(destination, null);
    }

    public AsyncFile openFile(Offerable<? super AsyncFile.Event> destination) {
        this.checkFileStarted();
        return this.openAsyncFile(destination, null);
    }

    public AsyncSocket openSocket(Offerable<? super AsyncSocket.Event> destination) throws IOException {
        this.checkNetStarted();
        return this.openAsyncSocket(destination, null);
    }

    public AsyncServerSocket openServerSocket(Executor executor) throws IOException {
        this.checkNetStarted();
        return this.openAsyncServerSocket(null, executor);
    }

    public AsyncDatagram openDatagram(Executor executor) throws IOException {
        this.checkNetStarted();
        return this.openAsyncDatagram(null, executor);
    }

    public AsyncFile openFile(Executor executor) {
        this.checkFileStarted();
        return this.openAsyncFile(null, executor);
    }

    public AsyncSocket openSocket(Executor executor) throws IOException {
        this.checkNetStarted();
        return this.openAsyncSocket(null, executor);
    }

    public AsyncServerSocket openServerSocket(Queue<? super AsyncServerSocket.Event> queue) throws IOException {
        this.checkNetStarted();
        return this.openAsyncServerSocket(AbstractAioProvider.wrapQueue(queue), null);
    }

    public AsyncFile openFile(Queue<? super AsyncFile.Event> queue) throws IOException {
        this.checkFileStarted();
        return this.openAsyncFile(AbstractAioProvider.wrapQueue(queue), null);
    }

    public AsyncDatagram openDatagram(Queue<? super AsyncDatagram.Event> queue) throws IOException {
        this.checkNetStarted();
        return this.openAsyncDatagram(AbstractAioProvider.wrapQueue(queue), null);
    }

    public AsyncSocket openSocket(Queue<? super AsyncSocket.Event> queue) throws IOException {
        this.checkNetStarted();
        return this.openAsyncSocket(AbstractAioProvider.wrapQueue(queue), null);
    }

    public FileMXBean getFileMXBean() {
        return null;
    }

    public void setErrorHandler(AioErrorHandler<?> handler) {
        this.defaultHandler = handler;
    }

    public AioErrorHandler<?> getErrorHandler() {
        return this.defaultHandler;
    }

    void unhandledException(Object o, String msg, Throwable cause) {
    }

    public DatagramGroupMonitor getDefaultDatagramGroupMonitor() {
        return this.defaultDatagramGroupMonitor;
    }

    public DatagramMonitor getDefaultDatagramMonitor() {
        return this.defaultDatagramMonitor;
    }

    public FileMonitor getDefaultFileMonitor() {
        return this.defaultFileMonitor;
    }

    public ServerSocketMonitor getDefaultServerSocketMonitor() {
        return this.defaultServerSocketMonitor;
    }

    public SocketGroupMonitor getDefaultSocketGroupMonitor() {
        return this.defaultSocketGroupMonitor;
    }

    public SocketMonitor getDefaultSocketMonitor() {
        return this.defaultSocketMonitor;
    }

    public void setDefaultMonitor(DatagramGroupMonitor m) {
        this.defaultDatagramGroupMonitor = m;
    }

    public void setDefaultMonitor(DatagramMonitor m) {
        this.defaultDatagramMonitor = m;
    }

    public void setDefaultMonitor(FileMonitor m) {
        this.defaultFileMonitor = m;
    }

    public void setDefaultMonitor(ServerSocketMonitor m) {
        this.defaultServerSocketMonitor = m;
    }

    public void setDefaultMonitor(SocketGroupMonitor m) {
        this.defaultSocketGroupMonitor = m;
    }

    public void setDefaultMonitor(SocketMonitor m) {
        this.defaultSocketMonitor = m;
    }

    private static <E> Offerable<E> wrapQueue(final Queue<? super E> queue) {
        return new Offerable<E>(){

            public boolean offer(E element) {
                return queue.offer(element);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AioStatus {
        NOT_STARTED,
        RUNNING,
        DEAD;

    }
}

