/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AcceptPolicy;
import coconut.aio.AioFuture;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.defaults.AioFutureTask;
import coconut.aio.defaults.DefaultSocket;
import coconut.aio.defaults.DefaultSocketGroup;
import coconut.aio.defaults.NetHandler;
import coconut.aio.management.ServerSocketInfo;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.core.Callback;
import coconut.core.ErroneousHandler;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultServerSocket
extends AsyncServerSocket {
    private final long id;
    private final NetHandler netHandler;
    private final Lock acceptLock = new ReentrantLock();
    private final AtomicLong acceptanceCount = new AtomicLong();
    private final AtomicReference<ClosedEvent> closeFuture = new AtomicReference();
    private final ServerSocketChannel channel;
    private volatile Executor defaultExecutor;
    private volatile Offerable<? super AsyncServerSocket.Event> defaultOfferable;
    private volatile ServerSocketMonitor monitor;
    private volatile Object attachment;
    private volatile Handler<AsyncServerSocket> closeHandler;
    private volatile DefaultSocketGroup defaultAcceptedSocketGroup;
    private AtomicInteger acceptStatus = new AtomicInteger();
    private AtomicBoolean isAccepting = new AtomicBoolean();
    private Offerable<? super AsyncServerSocket.Event> acceptanceSink;
    private Callback<AsyncSocket> acceptanceCallback;
    private Executor acceptanceExecutor;
    private AcceptPolicy acceptPolicy;
    private Callable acceptCancelSubscription;

    DefaultServerSocket(NetHandler handler, long id, ServerSocketChannel channel, ServerSocketMonitor monitor, Offerable<? super AsyncServerSocket.Event> queue, Executor executor) {
        this.netHandler = handler;
        this.id = id;
        this.channel = channel;
        this.defaultOfferable = queue;
        this.defaultExecutor = executor;
        this.monitor = monitor;
    }

    public long getId() {
        return this.id;
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public ServerSocket socket() {
        return this.channel.socket();
    }

    public boolean isOpen() {
        return this.closeFuture.get() == null;
    }

    public boolean isBound() {
        return this.socket().isBound();
    }

    public String toString() {
        return this.socket().toString();
    }

    public boolean isAccepting() {
        return this.isAccepting.get();
    }

    public InetAddress getInetAddress() {
        return this.socket().getInetAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket().getLocalSocketAddress();
    }

    public int getLocalPort() {
        return this.socket().getLocalPort();
    }

    public AsyncServerSocket setDefaultSocketGroup(AsyncSocketGroup group) {
        if (group != null && !(group instanceof DefaultSocketGroup)) {
            throw new IllegalArgumentException("This group is not created with same provider as this socket");
        }
        this.defaultAcceptedSocketGroup = (DefaultSocketGroup)group;
        return this;
    }

    public AsyncSocketGroup getDefaultSocketGroup() {
        return this.defaultAcceptedSocketGroup;
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }

    public AsyncServerSocket setCloseHandler(Handler<AsyncServerSocket> handler) {
        this.closeHandler = handler;
        return this;
    }

    public Handler<AsyncServerSocket> getCloseHandler() {
        return this.closeHandler;
    }

    public Offerable<? super AsyncServerSocket.Event> getDefaultDestination() {
        return this.defaultOfferable;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncServerSocket setMonitor(ServerSocketMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public ServerSocketMonitor getMonitor() {
        return this.monitor;
    }

    public AsyncServerSocket bind(SocketAddress address) throws IOException {
        ServerSocketMonitor m = this.monitor;
        try {
            this.socket().bind(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncServerSocket)this, address);
        }
        return this;
    }

    public AsyncServerSocket bind(SocketAddress address, int backlog) throws IOException {
        ServerSocketMonitor m = this.monitor;
        try {
            this.socket().bind(address, backlog);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncServerSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncServerSocket)this, address);
        }
        return this;
    }

    public AsyncSocket accept() throws IOException {
        this.acceptLock.lock();
        try {
            this.isAccepting.set(true);
            this.channel.configureBlocking(true);
            SocketChannel sc = this.channel.accept();
            this.acceptanceCount.incrementAndGet();
            DefaultSocket newsocket = this.netHandler.serverSocketSocketAccepted(this, sc, this.defaultAcceptedSocketGroup);
            this.acceptStatus.set(0);
            ServerSocketMonitor m = this.monitor;
            if (m != null) {
                m.accepted((AsyncServerSocket)this, (AsyncSocket)newsocket);
            }
            DefaultSocket defaultSocket = newsocket;
            return defaultSocket;
        }
        catch (IOException ioe) {
            this.outerClose(ioe);
            throw ioe;
        }
        finally {
            this.isAccepting.set(false);
            this.acceptLock.unlock();
        }
    }

    public AsyncServerSocket.AcceptingStarted startAccepting(Executor executor, Callback<AsyncSocket> callback) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        return new AcceptanceStartedEvent(executor, callback, null, new AcceptPolicy(){

            public int acceptNext(AsyncServerSocket socket) {
                return Integer.MAX_VALUE;
            }
        }).register();
    }

    public AsyncServerSocket.AcceptingStarted startAccepting(Executor executor, Callback<AsyncSocket> callback, AcceptPolicy policy) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        return new AcceptanceStartedEvent(executor, callback, null, policy).register();
    }

    public AsyncServerSocket.AcceptingStarted startAccepting(Offerable<? super AsyncServerSocket.Event> offerable) {
        if (offerable == null) {
            throw new NullPointerException("offerable");
        }
        return new AcceptanceStartedEvent(null, null, offerable, new AcceptPolicy(){

            public int acceptNext(AsyncServerSocket socket) {
                return Integer.MAX_VALUE;
            }
        }).register();
    }

    public AsyncServerSocket.AcceptingStarted startAccepting(Offerable<? super AsyncServerSocket.Event> offerable, AcceptPolicy policy) {
        if (offerable == null) {
            throw new NullPointerException("offerable");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        return new AcceptanceStartedEvent(null, null, offerable, policy).register();
    }

    public AsyncServerSocket.AcceptingStopped stopAccepting() {
        return new AcceptanceStoppedEvent().register();
    }

    public AsyncServerSocket.Closed close() {
        ClosedEvent event = new ClosedEvent(null);
        if (this.closeFuture.compareAndSet(null, event)) {
            return event.register();
        }
        return this.closeFuture.get();
    }

    ServerSocketInfo getServerSocketInfo() {
        return new ServerSocketInfo(this.id, 0L, 0L, this.acceptanceCount.get(), this.isBound(), this.getInetAddress(), this.getLocalPort(), this.getLocalSocketAddress());
    }

    long getNumberOfAccepts() {
        return this.acceptanceCount.get();
    }

    private void outerClose(Exception e) {
        new ClosedEvent(e).register();
    }

    private void innerClose(Exception e) {
        ClosedEvent future = new ClosedEvent(e);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
    }

    private void closed(Throwable cause, IOException closeFailure) {
        Handler<AsyncServerSocket> handler;
        ServerSocketMonitor m = this.monitor;
        if (m != null) {
            try {
                m.closed((AsyncServerSocket)this, cause);
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        if ((handler = this.closeHandler) != null) {
            try {
                if (cause != null && handler instanceof ErroneousHandler) {
                    ((ErroneousHandler)handler).handle((Object)this, cause);
                } else {
                    handler.handle((Object)this);
                }
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        this.netHandler.serverSocketClosed(this, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptNewEvents() {
        boolean gotLock = this.acceptLock.tryLock();
        if (gotLock) {
            try {
                int acceptRemaining = 0;
                while (this.isAccepting()) {
                    SocketChannel newChannel;
                    if (acceptRemaining-- <= 0) {
                        try {
                            acceptRemaining = this.acceptPolicy.acceptNext((AsyncServerSocket)this);
                        }
                        catch (RuntimeException e) {
                            this.innerClose(e);
                            this.acceptLock.unlock();
                            return;
                        }
                        if (acceptRemaining-- <= 0) {
                            return;
                        }
                    }
                    if ((newChannel = this.channel.accept()) == null) {
                        return;
                    }
                    try {
                        newChannel.configureBlocking(false);
                    }
                    catch (IOException e) {
                        this.innerClose(e);
                        return;
                    }
                    this.acceptanceCount.incrementAndGet();
                    final DefaultSocket newsocket = this.netHandler.serverSocketSocketAccepted(this, newChannel, this.defaultAcceptedSocketGroup);
                    ServerSocketMonitor m = this.monitor;
                    if (m != null) {
                        try {
                            m.accepted((AsyncServerSocket)this, (AsyncSocket)newsocket);
                        }
                        catch (RuntimeException e) {
                            this.innerClose(e);
                            this.acceptLock.unlock();
                            return;
                        }
                    }
                    if (this.acceptanceSink != null) {
                        try {
                            SocketAcceptedEvent e = new SocketAcceptedEvent(newsocket);
                            this.acceptanceSink.offer((Object)e);
                            continue;
                        }
                        catch (RuntimeException e) {
                            this.innerClose(e);
                            this.acceptLock.unlock();
                            return;
                        }
                    }
                    try {
                        this.acceptanceExecutor.execute(new Runnable(){

                            public void run() {
                                try {
                                    DefaultServerSocket.this.acceptanceCallback.completed((Object)newsocket);
                                }
                                catch (RuntimeException e) {
                                    DefaultServerSocket.this.outerClose(e);
                                }
                            }
                        });
                    }
                    catch (RuntimeException e) {
                        this.innerClose(e);
                        this.acceptLock.unlock();
                        return;
                    }
                }
            }
            finally {
                this.acceptLock.unlock();
            }
        }
        IllegalStateException e = new IllegalStateException("tried to asynchronously accept while already blocking accepting");
        this.innerClose(e);
    }

    private class SocketAcceptedEvent
    extends BaseEvent
    implements AsyncServerSocket.SocketAccepted {
        private final AsyncSocket socket;

        private SocketAcceptedEvent(AsyncSocket socket) {
            this.socket = socket;
        }

        public AsyncSocket getAcceptedSocket() {
            return this.socket;
        }
    }

    private class AcceptanceStoppedEvent
    extends BaseEvent
    implements AsyncServerSocket.AcceptingStopped {
        private AcceptanceStoppedEvent() {
        }

        private AcceptanceStoppedEvent register() {
            DefaultServerSocket.this.netHandler.serverSocketRegisterCommand(this);
            return this;
        }

        public Object call() throws Exception {
            boolean gotLock = DefaultServerSocket.this.acceptLock.tryLock();
            if (gotLock) {
                try {
                    DefaultServerSocket.this.isAccepting.set(false);
                    DefaultServerSocket.this.acceptPolicy = null;
                    DefaultServerSocket.this.acceptanceCallback = null;
                    DefaultServerSocket.this.acceptanceExecutor = null;
                    DefaultServerSocket.this.acceptanceSink = null;
                    if (DefaultServerSocket.this.acceptCancelSubscription != null) {
                        DefaultServerSocket.this.acceptCancelSubscription.call();
                    }
                    Object var2_2 = null;
                    return var2_2;
                }
                catch (Exception e) {
                    DefaultServerSocket.this.innerClose(e);
                    throw e;
                }
                finally {
                    DefaultServerSocket.this.acceptLock.unlock();
                }
            }
            IllegalStateException e = new IllegalStateException("tried to asynchronously stop accepting while already blocking accepting");
            DefaultServerSocket.this.innerClose(e);
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceptanceStartedEvent
    extends BaseEvent
    implements AsyncServerSocket.AcceptingStarted {
        private final AcceptPolicy policy;
        private final Executor aExecutor;
        private final Offerable<? super AsyncServerSocket.Event> AOfferable;
        private final Callback<AsyncSocket> aCallback;

        private AcceptanceStartedEvent(Executor e, Callback<AsyncSocket> c, Offerable<? super AsyncServerSocket.Event> o, AcceptPolicy policy) {
            this.aCallback = c;
            this.aExecutor = e;
            this.AOfferable = o;
            this.policy = policy;
        }

        private AcceptanceStartedEvent register() {
            DefaultServerSocket.this.netHandler.serverSocketRegisterCommand(this);
            return this;
        }

        public AcceptPolicy getPolicy() {
            return this.policy;
        }

        @Override
        public Object call() throws IOException {
            boolean gotLock = DefaultServerSocket.this.acceptLock.tryLock();
            if (gotLock) {
                try {
                    DefaultServerSocket.this.isAccepting.set(true);
                    DefaultServerSocket.this.channel.configureBlocking(false);
                    DefaultServerSocket.this.acceptCancelSubscription = DefaultServerSocket.this.netHandler.serverSocketStartAccepting(DefaultServerSocket.this, DefaultServerSocket.this.channel, new Handler(){

                        public void handle(Object arg0) {
                            DefaultServerSocket.this.acceptNewEvents();
                        }
                    });
                    DefaultServerSocket.this.acceptPolicy = this.policy;
                    DefaultServerSocket.this.acceptanceCallback = this.aCallback;
                    DefaultServerSocket.this.acceptanceExecutor = this.aExecutor;
                    DefaultServerSocket.this.acceptanceSink = this.AOfferable;
                    Object var2_2 = null;
                    return var2_2;
                }
                catch (IOException ioe) {
                    DefaultServerSocket.this.isAccepting.set(false);
                    DefaultServerSocket.this.innerClose(ioe);
                    throw ioe;
                }
                finally {
                    DefaultServerSocket.this.acceptLock.unlock();
                }
            }
            IllegalStateException e = new IllegalStateException("tried to asynchronously start accepting while already blocking accepting");
            DefaultServerSocket.this.innerClose(e);
            throw e;
        }
    }

    private class ClosedEvent
    extends BaseEvent
    implements AsyncServerSocket.Closed {
        private final Throwable cause;

        private ClosedEvent(Throwable cause) {
            this.cause = cause;
        }

        private ClosedEvent register() {
            DefaultServerSocket.this.netHandler.serverSocketRegisterCommand(this);
            return this;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object call() throws Exception {
            try {
                DefaultServerSocket.this.channel.close();
                DefaultServerSocket.this.isAccepting.set(false);
                DefaultServerSocket.this.closed(this.cause, null);
            }
            catch (IOException e) {
                DefaultServerSocket.this.closed(this.cause, e);
                throw e;
            }
            finally {
                DefaultServerSocket.this.acceptStatus.set(0);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncServerSocket.Event>
    implements AsyncServerSocket.Event,
    AioFuture<V, AsyncServerSocket.Event> {
        private BaseEvent() {
            super(DefaultServerSocket.this.defaultExecutor, DefaultServerSocket.this.defaultOfferable);
        }

        public AsyncServerSocket async() {
            return DefaultServerSocket.this;
        }

        @Override
        public int getColor() {
            return DefaultServerSocket.this.getColor();
        }

        public void setDestination(Offerable<? super AsyncServerSocket.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncServerSocket.Event> dest, final Throwable t) {
            AsyncServerSocket.ErroneousEvent error = new AsyncServerSocket.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public int getColor() {
                    return DefaultServerSocket.this.getColor();
                }

                public AsyncServerSocket.Event getEvent() {
                    return BaseEvent.this;
                }

                public AsyncServerSocket async() {
                    return DefaultServerSocket.this;
                }
            };
            dest.offer((Object)error);
        }
    }
}

