/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.defaults.DefaultDatagram;
import coconut.aio.defaults.DefaultDatagramGroup;
import coconut.aio.defaults.DefaultServerSocket;
import coconut.aio.defaults.DefaultSocket;
import coconut.aio.defaults.DefaultSocketGroup;
import coconut.aio.management.DatagramGroupInfo;
import coconut.aio.management.DatagramInfo;
import coconut.aio.management.DatagramMBean;
import coconut.aio.management.ServerSocketInfo;
import coconut.aio.management.ServerSocketMBean;
import coconut.aio.management.SocketGroupInfo;
import coconut.aio.management.SocketInfo;
import coconut.aio.management.SocketMBean;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultNetManagement {
    private final ConcurrentHashMap<Long, Object> all = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, DefaultServerSocket> serverSockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, DefaultSocket> sockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, DefaultDatagram> datagrams = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, SocketInf> socketGroups = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, DatagramInf> datagramGroups = new ConcurrentHashMap();
    private final AtomicLong totalSockets = new AtomicLong();
    private final AtomicLong totalDatagrams = new AtomicLong();
    private final AtomicLong totalServerSockets = new AtomicLong();
    private final AtomicLong bytesWrittenOnSockets = new AtomicLong();
    private final AtomicLong bytesReadOnSockets = new AtomicLong();
    private final AtomicLong bytesWrittenOnDatagrams = new AtomicLong();
    private final AtomicLong bytesReadOnDatagrams = new AtomicLong();
    private final AtomicInteger peakSocketCount = new AtomicInteger();
    private final AtomicInteger peakServerSocketCount = new AtomicInteger();
    private final AtomicInteger peakDatagramCount = new AtomicInteger();
    private final AtomicLong totalAcceptedConnections = new AtomicLong();
    private final AtomicLong totalSocketConnections = new AtomicLong();
    private final Executor releaser;
    private final ServerSocketMBean mServerSocketbean = new DefaultServerSocketMXBean();
    private final SocketMBean mSocketbean = new DefaultSocketMXBean();
    private final DatagramMBean mDatagrambean = new DefaultDatagramMXBean();

    public DefaultNetManagement(Executor releaser) {
        this.releaser = releaser;
    }

    public DefaultNetManagement() {
        this(new Executor(){

            public void execute(Runnable runnable) {
                runnable.run();
            }
        });
    }

    public void run() {
        this.sockets.clear();
        this.serverSockets.clear();
        this.datagrams.clear();
    }

    public void opened(DefaultServerSocket socket) {
        Long l = new Long(socket.getId());
        this.serverSockets.put(l, socket);
        this.all.put(l, (Object)socket);
        int peak = this.serverSockets.size();
        if (peak > this.peakServerSocketCount.get()) {
            this.peakServerSocketCount.set(peak);
        }
        this.totalServerSockets.incrementAndGet();
    }

    public void opened(DefaultSocket socket) {
        Long l = new Long(socket.getId());
        this.sockets.put(l, socket);
        this.all.put(l, (Object)socket);
        this.totalSockets.incrementAndGet();
        int peak = this.sockets.size();
        if (peak > this.peakSocketCount.get()) {
            this.peakSocketCount.set(peak);
        }
    }

    public void opened(DefaultDatagram socket) {
        Long l = new Long(socket.getId());
        this.datagrams.put(l, socket);
        this.all.put(l, (Object)socket);
        this.totalDatagrams.incrementAndGet();
        int peak = this.datagrams.size();
        if (peak > this.peakDatagramCount.get()) {
            this.peakDatagramCount.set(peak);
        }
    }

    public void opened(DefaultSocketGroup group) {
        Long l = new Long(group.getId());
        this.socketGroups.put(l, new SocketInf(group));
        this.all.put(l, (Object)group);
    }

    public void opened(DefaultDatagramGroup group) {
        Long l = new Long(group.getId());
        this.datagramGroups.put(l, new DatagramInf(group));
        this.all.put(l, (Object)group);
    }

    void addBytesWritten(long bytes) {
        this.bytesWrittenOnSockets.addAndGet(bytes);
    }

    void addBytesRead(long bytes) {
        this.bytesReadOnSockets.addAndGet(bytes);
    }

    void addBytesWrittenDatagram(long bytes) {
        this.bytesWrittenOnDatagrams.addAndGet(bytes);
    }

    void addBytesReadDatagram(long bytes) {
        this.bytesReadOnDatagrams.addAndGet(bytes);
    }

    void incrementAccepts() {
        this.totalAcceptedConnections.incrementAndGet();
    }

    void incrementSocketConnections() {
        this.totalSocketConnections.incrementAndGet();
    }

    void closed(AsyncServerSocket socket) {
        Long l = new Long(socket.getId());
        this.serverSockets.remove(l);
        this.all.remove(l);
    }

    void joined(DefaultDatagramGroup group, DefaultDatagram socket) {
        DatagramInf grp = this.datagramGroups.get(new Long(group.getId()));
        grp.totalCount.incrementAndGet();
        int size = group.size();
        if (size > grp.peekCount.get()) {
            grp.peekCount.set(size);
        }
    }

    void left(DefaultDatagramGroup group, DefaultDatagram socket) {
        DatagramInf grp = this.datagramGroups.get(new Long(group.getId()));
        grp.totalCount.decrementAndGet();
    }

    void joined(DefaultSocketGroup group, DefaultSocket socket) {
        SocketInf grp = this.socketGroups.get(new Long(group.getId()));
        grp.totalCount.incrementAndGet();
        int size = group.size();
        if (size > grp.peekCount.get()) {
            grp.peekCount.set(size);
        }
    }

    void left(DefaultSocketGroup group, DefaultSocket socket) {
        SocketInf grp = this.socketGroups.get(new Long(group.getId()));
        grp.totalCount.decrementAndGet();
    }

    void closed(AsyncSocket socket) {
        Long l = new Long(socket.getId());
        this.sockets.remove(l);
        this.all.remove(l);
    }

    void closed(AsyncDatagram socket) {
        Long l = new Long(socket.getId());
        this.datagrams.remove(l);
        this.all.remove(l);
    }

    void closed(AsyncSocketGroup group) {
        Long l = new Long(group.getId());
        this.socketGroups.remove(l);
        this.all.remove(l);
    }

    void closed(AsyncDatagramGroup group) {
        Long l = new Long(group.getId());
        this.datagramGroups.remove(l);
        this.all.remove(l);
    }

    public SocketMBean getSocketMXBean() {
        return this.mSocketbean;
    }

    public DatagramMBean getDatagramMXBean() {
        return this.mDatagrambean;
    }

    public ServerSocketMBean getServerSocketMXBean() {
        return this.mServerSocketbean;
    }

    private static class SocketInf {
        private final AtomicInteger peekCount = new AtomicInteger();
        private final AtomicLong totalCount = new AtomicLong();
        private final DefaultSocketGroup group;

        SocketInf(DefaultSocketGroup group) {
            this.group = group;
        }
    }

    private static class DatagramInf {
        private final AtomicInteger peekCount = new AtomicInteger();
        private final AtomicLong totalCount = new AtomicLong();
        private final DefaultDatagramGroup group;

        DatagramInf(DefaultDatagramGroup group) {
            this.group = group;
        }
    }

    private final class DefaultDatagramMXBean
    implements DatagramMBean {
        private DefaultDatagramMXBean() {
        }

        public long[] getAllDatagramIds() {
            int i = 0;
            ArrayList values = new ArrayList(DefaultNetManagement.this.datagrams.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long[] getAllDatagramGroupIds() {
            int i = 0;
            ArrayList values = new ArrayList(DefaultNetManagement.this.datagramGroups.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long getBytesWritten() {
            return DefaultNetManagement.this.bytesWrittenOnDatagrams.get();
        }

        public long getBytesWritten(long id) {
            DefaultDatagram socket = (DefaultDatagram)((Object)DefaultNetManagement.this.datagrams.get(new Long(id)));
            if (socket == null) {
                DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
                return group == null ? 0L : group.group.getNumberOfBytesWritten();
            }
            return socket.getNumberOfBytesWritten();
        }

        public long getBytesRead() {
            return DefaultNetManagement.this.bytesWrittenOnDatagrams.get();
        }

        public long getBytesRead(long id) {
            DefaultDatagram socket = (DefaultDatagram)((Object)DefaultNetManagement.this.datagrams.get(new Long(id)));
            if (socket == null) {
                DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
                return group == null ? 0L : group.group.getNumberOfBytesRead();
            }
            return socket.getNumberOfBytesRead();
        }

        public long getTotalDatagramCount() {
            return DefaultNetManagement.this.totalDatagrams.get();
        }

        public long getTotalDatagramCount(long id) {
            DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.totalCount.get();
            }
            return 0L;
        }

        public int getPeakDatagramCount() {
            return DefaultNetManagement.this.peakDatagramCount.get();
        }

        public int getPeakDatagramCount(long id) {
            DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.peekCount.get();
            }
            return 0;
        }

        public int getDatagramCount() {
            return DefaultNetManagement.this.datagrams.size();
        }

        public int getDatagramCount(long id) {
            DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.group.size();
            }
            return 0;
        }

        public DatagramInfo getDatagramInfo(long id) {
            DefaultDatagram socket = (DefaultDatagram)((Object)DefaultNetManagement.this.datagrams.get(new Long(id)));
            if (socket != null) {
                DatagramInfo info;
                while ((info = socket.getSocketInfo()).isBound() != socket.isBound()) {
                }
                return info;
            }
            return null;
        }

        public DatagramInfo[] getDatagramInfo(long[] ids) {
            DatagramInfo info;
            DatagramInfo[] infos = new DatagramInfo[ids.length];
            for (int i = 0; i < infos.length && (info = this.getDatagramInfo(ids[i])) != null; ++i) {
                infos[i] = info;
            }
            return infos;
        }

        public DatagramGroupInfo getDatagramGroupInfo(long id) {
            DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
            if (group != null) {
                return group.group.getDatagramInfo();
            }
            return null;
        }

        public long[] getDatagramsInGroup(long id) {
            DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
            if (group != null) {
                Object[] o = group.group.toArray();
                long[] ids = new long[o.length];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((AsyncDatagram)o[i]).getId();
                }
                return ids;
            }
            return new long[0];
        }

        public void resetPeakDatagramCount() {
            DefaultNetManagement.this.peakDatagramCount.set(this.getDatagramCount());
        }

        public void resetPeakDatagramCount(long id) {
            DatagramInf group = (DatagramInf)DefaultNetManagement.this.datagramGroups.get(new Long(id));
            if (group != null) {
                group.peekCount.set(this.getDatagramCount(id));
            }
        }
    }

    private final class DefaultSocketMXBean
    implements SocketMBean {
        private DefaultSocketMXBean() {
        }

        public long[] getAllSocketIds() {
            int i = 0;
            ArrayList values = new ArrayList(DefaultNetManagement.this.sockets.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long[] getAllSocketGroupIds() {
            int i = 0;
            ArrayList values = new ArrayList(DefaultNetManagement.this.socketGroups.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long getBytesWritten() {
            return DefaultNetManagement.this.bytesWrittenOnSockets.get();
        }

        public long getBytesWritten(long id) {
            DefaultSocket socket = (DefaultSocket)((Object)DefaultNetManagement.this.sockets.get(new Long(id)));
            if (socket == null) {
                SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
                return group == null ? 0L : group.group.getNumberOfBytesWritten();
            }
            return socket.getNumberOfBytesWritten();
        }

        public long getBytesRead() {
            return DefaultNetManagement.this.bytesWrittenOnSockets.get();
        }

        public long getBytesRead(long id) {
            DefaultSocket socket = (DefaultSocket)((Object)DefaultNetManagement.this.sockets.get(new Long(id)));
            if (socket == null) {
                SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
                return group == null ? 0L : group.group.getNumberOfBytesRead();
            }
            return socket.getNumberOfBytesRead();
        }

        public long getTotalSocketCount() {
            return DefaultNetManagement.this.totalSockets.get();
        }

        public long getTotalSocketCount(long id) {
            SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.totalCount.get();
            }
            return 0L;
        }

        public int getPeakSocketCount() {
            return DefaultNetManagement.this.peakSocketCount.get();
        }

        public int getPeakSocketCount(long id) {
            SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.peekCount.get();
            }
            return 0;
        }

        public int getSocketCount() {
            return DefaultNetManagement.this.sockets.size();
        }

        public int getSocketCount(long id) {
            SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.group.size();
            }
            return 0;
        }

        public long getTotalSocketConnectCount() {
            return DefaultNetManagement.this.totalSocketConnections.get();
        }

        public SocketInfo getSocketInfo(long id) {
            DefaultSocket socket = (DefaultSocket)((Object)DefaultNetManagement.this.sockets.get(new Long(id)));
            if (socket != null) {
                SocketInfo info;
                while ((info = socket.getSocketInfo()).isBound() != socket.isBound()) {
                }
                return info;
            }
            return null;
        }

        public SocketInfo[] getSocketInfo(long[] ids) {
            SocketInfo info;
            SocketInfo[] infos = new SocketInfo[ids.length];
            for (int i = 0; i < infos.length && (info = this.getSocketInfo(ids[i])) != null; ++i) {
                infos[i] = info;
            }
            return infos;
        }

        public SocketGroupInfo getSocketGroupInfo(long id) {
            SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
            if (group != null) {
                return group.group.getSocketInfo();
            }
            return null;
        }

        public long[] getSocketsInGroup(long id) {
            SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
            if (group != null) {
                Object[] o = group.group.toArray();
                long[] ids = new long[o.length];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((AsyncSocket)o[i]).getId();
                }
                return ids;
            }
            return new long[0];
        }

        public void resetPeakSocketCount() {
            DefaultNetManagement.this.peakSocketCount.set(this.getSocketCount());
        }

        public void resetPeakSocketCount(long id) {
            SocketInf group = (SocketInf)DefaultNetManagement.this.socketGroups.get(new Long(id));
            if (group != null) {
                group.peekCount.set(this.getSocketCount(id));
            }
        }
    }

    final class DefaultServerSocketMXBean
    implements ServerSocketMBean {
        DefaultServerSocketMXBean() {
        }

        public long[] getAllServerSocketIds() {
            int i = 0;
            ArrayList values = new ArrayList(DefaultNetManagement.this.serverSockets.keySet());
            long[] result = new long[values.size()];
            for (Long val : values) {
                result[i++] = val;
            }
            return result;
        }

        public long getTotalServerSocketsCount() {
            return DefaultNetManagement.this.totalServerSockets.get();
        }

        public int getPeakServerSocketCount() {
            return DefaultNetManagement.this.peakServerSocketCount.get();
        }

        public int getServerSocketCount() {
            return DefaultNetManagement.this.serverSockets.size();
        }

        public long getTotalAcceptCount() {
            return DefaultNetManagement.this.totalAcceptedConnections.get();
        }

        public long getTotalAcceptCount(long id) {
            DefaultServerSocket dss = (DefaultServerSocket)((Object)DefaultNetManagement.this.serverSockets.get(new Long(id)));
            return dss == null ? 0L : dss.getNumberOfAccepts();
        }

        public ServerSocketInfo getServerSocketInfo(long id) {
            DefaultServerSocket serverSocket = (DefaultServerSocket)((Object)DefaultNetManagement.this.serverSockets.get(new Long(id)));
            if (serverSocket != null) {
                ServerSocketInfo info;
                while ((info = serverSocket.getServerSocketInfo()).isBound() != serverSocket.isBound()) {
                }
                return info;
            }
            return null;
        }

        public ServerSocketInfo[] getServerSocketInfo(long[] ids) {
            ServerSocketInfo info;
            ServerSocketInfo[] infos = new ServerSocketInfo[ids.length];
            for (int i = 0; i < infos.length && (info = this.getServerSocketInfo(ids[i])) != null; ++i) {
                infos[i] = info;
            }
            return infos;
        }

        public void resetPeakServerSocketCount() {
            DefaultNetManagement.this.peakServerSocketCount.set(this.getServerSocketCount());
        }
    }
}

