/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.ReadHandler;
import coconut.aio.defaults.DefaultDatagram;
import coconut.aio.defaults.NetHandler;
import coconut.aio.management.DatagramGroupInfo;
import coconut.aio.monitor.DatagramGroupMonitor;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultDatagramGroup
extends AsyncDatagramGroup {
    private final ConcurrentHashMap<AsyncDatagram, AsyncDatagram> sockets = new ConcurrentHashMap();
    private final NetHandler handler;
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private volatile DatagramGroupMonitor monitor;
    private final long id;
    private volatile Executor e;
    private volatile Offerable<? super AsyncDatagram.Event> offerable;
    private volatile ReadHandler<AsyncDatagram> reader;
    private volatile Handler<AsyncDatagram> joinHandler;
    private volatile Handler<AsyncDatagram> leaveHandler;

    DefaultDatagramGroup(NetHandler handler, long id, DatagramGroupMonitor monitor) {
        this.monitor = monitor;
        this.handler = handler;
        this.id = id;
    }

    public AsyncDatagramGroup setDefaultExecutor(Executor executor) {
        this.e = executor;
        return this;
    }

    public AsyncDatagramGroup setDefaultDestination(Offerable<? super AsyncDatagram.Event> offerable) {
        this.offerable = offerable;
        return this;
    }

    public AsyncDatagramGroup setDefaultReader(ReadHandler<AsyncDatagram> callback) {
        this.reader = callback;
        return this;
    }

    public AsyncDatagramGroup setJoinHandler(Handler<AsyncDatagram> handler) {
        this.joinHandler = handler;
        return this;
    }

    void added(DefaultDatagram s) {
        DatagramGroupMonitor m;
        this.sockets.put(s, s);
        this.handler.groupJoined(this, s);
        Handler<AsyncDatagram> handler = this.joinHandler;
        if (handler != null) {
            try {
                handler.handle((Object)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((m = this.monitor) != null) {
            try {
                m.join((AsyncDatagramGroup)this, (AsyncDatagram)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean add(AsyncDatagram socket) {
        if (!(socket instanceof DefaultDatagram)) {
            throw new IllegalArgumentException("This socket is not created with same provider as this group");
        }
        DefaultDatagram s = (DefaultDatagram)socket;
        return s.innerSetGroup(this);
    }

    public int size() {
        return this.sockets.size();
    }

    public boolean contains(Object element) {
        return this.sockets.containsKey(element);
    }

    public AsyncDatagramGroup setLeaveHandler(Handler<AsyncDatagram> handler) {
        this.leaveHandler = handler;
        return this;
    }

    boolean innerRemove(Object o) {
        boolean removed;
        boolean bl = removed = this.sockets.remove(o) != null;
        if (removed) {
            DatagramGroupMonitor m;
            DefaultDatagram socket = (DefaultDatagram)((Object)o);
            Handler<AsyncDatagram> handler = this.leaveHandler;
            if (handler != null) {
                handler.handle((Object)socket);
            }
            if ((m = this.monitor) != null) {
                try {
                    m.leave((AsyncDatagramGroup)this, (AsyncDatagram)socket, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return removed;
    }

    public boolean remove(Object o) {
        DefaultDatagram socket = (DefaultDatagram)this.sockets.get(o);
        if (socket != null) {
            socket.innerSetGroup(null);
            return true;
        }
        return false;
    }

    public Iterator<AsyncDatagram> iterator() {
        return this.sockets.values().iterator();
    }

    public long getId() {
        return this.id;
    }

    public Executor getDefaultExecutor() {
        return this.e;
    }

    public Offerable<? super AsyncDatagram.Event> getDefaultDestination() {
        return this.offerable;
    }

    public ReadHandler<AsyncDatagram> getDefaultReader() {
        return this.reader;
    }

    public Handler<AsyncDatagram> getJoinHandler() {
        return this.joinHandler;
    }

    public Handler<AsyncDatagram> getLeaveHandler() {
        return this.leaveHandler;
    }

    protected void finalize() {
        this.handler.groupClosed(this);
    }

    public DatagramGroupMonitor getMonitor() {
        return this.monitor;
    }

    public AsyncDatagramGroup setMonitor(DatagramGroupMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    DatagramGroupInfo getDatagramInfo() {
        return new DatagramGroupInfo(this.id, this.size(), this.bytesRead.get(), this.bytesWritten.get());
    }

    long getNumberOfBytesRead() {
        return this.bytesRead.get();
    }

    void addNumberOfBytesRead(long number) {
        this.bytesRead.addAndGet(number);
    }

    long getNumberOfBytesWritten() {
        return this.bytesWritten.get();
    }

    void addNumberOfBytesWritten(long number) {
        this.bytesWritten.addAndGet(number);
    }
}

