/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.AsyncDatagramSource;
import coconut.aio.ReadHandler;
import coconut.aio.defaults.AioFutureTask;
import coconut.aio.defaults.ByteBufferUtil;
import coconut.aio.defaults.DefaultDatagramGroup;
import coconut.aio.defaults.NetHandler;
import coconut.aio.management.DatagramInfo;
import coconut.aio.monitor.DatagramMonitor;
import coconut.core.ErroneousHandler;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultDatagram
extends AsyncDatagram {
    private static final DefaultDatagramGroup CLOSED_GROUP = new DefaultDatagramGroup(null, -1L, null);
    private final long id;
    private final NetHandler netHandler;
    private final DatagramChannel channel;
    private final AtomicLong commitedWriteBytes = new AtomicLong();
    private final AtomicInteger commitQueueLength = new AtomicInteger();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicReference<ClosedEvent> closeFuture = new AtomicReference();
    volatile Executor defaultExecutor;
    volatile Offerable<? super AsyncDatagram.Event> defaultDestination;
    private volatile long writeByteLimit = Long.MAX_VALUE;
    private volatile int writeQueueLimit = Integer.MAX_VALUE;
    private volatile Object attachment;
    private volatile Handler<AsyncDatagram> closeHandler;
    private volatile DatagramMonitor monitor;
    private final Lock groupLock = new ReentrantLock();
    private volatile DefaultDatagramGroup group;
    private final AtomicInteger writeState = new AtomicInteger();
    private final Lock writeLock = new ReentrantLock();
    private final Queue<WrittenEvent> writes = new ConcurrentLinkedQueue<WrittenEvent>();
    private volatile WrittenEvent currentWrite;
    private Callable cancelWrite;
    private int numberOfEmptyWriteSelects;
    private int writeAttempts;
    private final ReaderSource sourceAdapter = new ReaderSource();
    private Callable cancelRead;
    private final Lock readLock = new ReentrantLock();
    private volatile ReadHandler<AsyncDatagram> reader;

    DefaultDatagram(NetHandler handler, long id, DatagramChannel channel, DatagramMonitor monitor, Offerable<? super AsyncDatagram.Event> destination, Executor executor) {
        this.netHandler = handler;
        this.channel = channel;
        this.id = id;
        this.defaultExecutor = executor;
        this.defaultDestination = destination;
        this.monitor = monitor;
    }

    public long getId() {
        return this.id;
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public DatagramSocket socket() {
        return this.channel.socket();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public boolean isOpen() {
        return this.closeFuture.get() == null;
    }

    public String toString() {
        return this.socket().toString();
    }

    public AsyncDatagram setBufferLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeByteLimit = limit;
        return this;
    }

    public long getBufferLimit() {
        return this.writeByteLimit;
    }

    public AsyncDatagram setWriteQueueLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeQueueLimit = limit;
        return this;
    }

    public int getWriteQueueLimit() {
        return this.writeQueueLimit;
    }

    public InetAddress getInetAddress() {
        return this.socket().getInetAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket().getLocalSocketAddress();
    }

    public int getPort() {
        return this.socket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socket().getLocalAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket().getRemoteSocketAddress();
    }

    public int getLocalPort() {
        return this.socket().getLocalPort();
    }

    public boolean isBound() {
        return this.socket().isBound();
    }

    public AsyncDatagram setMonitor(DatagramMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public DatagramMonitor getMonitor() {
        return this.monitor;
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }

    public Offerable<? super AsyncDatagram.Event> getDefaultDestination() {
        return this.defaultDestination;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncDatagram setCloseHandler(Handler<AsyncDatagram> handler) {
        this.closeHandler = handler;
        return this;
    }

    public Handler<AsyncDatagram> getCloseHandler() {
        return this.closeHandler;
    }

    public AsyncDatagramGroup getGroup() {
        return this.group;
    }

    public AsyncDatagramSource getSource() {
        return this.sourceAdapter;
    }

    public ReadHandler<AsyncDatagram> getReader() {
        return this.reader;
    }

    public AsyncDatagram setGroup(AsyncDatagramGroup group) {
        if (group != null && !(group instanceof DefaultDatagramGroup)) {
            throw new IllegalArgumentException("This group is not created with same provider as this socket");
        }
        this.innerSetGroup((DefaultDatagramGroup)group);
        return this;
    }

    public AsyncDatagram bind(SocketAddress address) throws IOException {
        DatagramMonitor m = this.monitor;
        try {
            this.socket().bind(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncDatagram)this, address);
        }
        return this;
    }

    public AsyncDatagram connect(SocketAddress address) throws IOException {
        DatagramMonitor m = this.monitor;
        try {
            this.channel.connect(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.connectFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.connectFailed((AsyncDatagram)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.connected((AsyncDatagram)this, address);
        }
        return this;
    }

    public AsyncDatagram disconnect() throws IOException {
        DatagramMonitor m = this.monitor;
        try {
            this.channel.disconnect();
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.disconnected((AsyncDatagram)this);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.disconnected((AsyncDatagram)this);
            }
            throw e;
        }
        if (m != null) {
            m.disconnected((AsyncDatagram)this);
        }
        return this;
    }

    public AsyncDatagram.Written write(ByteBuffer buffer) {
        this.checkBufferLimit(ByteBufferUtil.calcSize(buffer));
        WrittenEvent future = new WrittenEvent(this.getRemoteSocketAddress(), buffer);
        this.writes.add(future);
        this.tryAndWriteSocketEvents();
        return future;
    }

    public AsyncDatagram.Written write(ByteBuffer[] buffer, int offset, int length) {
        this.checkBufferLimit(ByteBufferUtil.calcSize(buffer));
        WrittenEvent future = new WrittenEvent(this.getRemoteSocketAddress(), buffer, offset, length);
        this.writes.add(future);
        this.tryAndWriteSocketEvents();
        return future;
    }

    public AsyncDatagram.Closed close() {
        ClosedEvent future = new ClosedEvent(null);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
        return this.closeFuture.get();
    }

    private void checkBufferLimit(long bytes) throws RejectedExecutionException {
        int currentSize;
        do {
            if ((currentSize = this.commitQueueLength.get()) == Integer.MAX_VALUE || currentSize < this.writeQueueLimit) continue;
            throw new RejectedExecutionException();
        } while (!this.commitQueueLength.compareAndSet(currentSize, currentSize + 1));
        do {
            if ((currentSize = this.commitedWriteBytes.get()) == Long.MAX_VALUE || currentSize + bytes <= this.writeByteLimit) continue;
            this.commitQueueLength.decrementAndGet();
            throw new RejectedExecutionException();
        } while (!this.commitedWriteBytes.compareAndSet(currentSize, currentSize + bytes));
    }

    DatagramInfo getSocketInfo() {
        DefaultDatagramGroup soc = this.group;
        return new DatagramInfo(this.id, 0L, 0L, this.group == null ? 0L : this.group.getId(), this.socket(), this.bytesRead.get(), this.bytesWritten.get());
    }

    long getNumberOfBytesRead() {
        return this.bytesRead.get();
    }

    long getNumberOfBytesWritten() {
        return this.bytesWritten.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean innerSetGroup(DefaultDatagramGroup newGroup) {
        try {
            this.groupLock.lock();
            DefaultDatagramGroup currentGroup = this.group;
            if (currentGroup != CLOSED_GROUP && currentGroup != newGroup) {
                if (currentGroup != null) {
                    currentGroup.innerRemove((Object)this);
                }
                if (newGroup != null && newGroup != CLOSED_GROUP) {
                    this.defaultExecutor = newGroup.getDefaultExecutor();
                    this.defaultDestination = newGroup.getDefaultDestination();
                    ReadHandler<AsyncDatagram> r = newGroup.getDefaultReader();
                    if (r != null) {
                        this.setReader(this.reader);
                    }
                    newGroup.added(this);
                }
                this.group = newGroup;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.groupLock.unlock();
        }
        return false;
    }

    private void outerClose(Throwable e) {
        this.connectClose(e);
    }

    private void readClose(Throwable e) {
        this.connectClose(e);
    }

    private void writeClose(Throwable e) {
        this.connectClose(e);
    }

    private void connectClose(Throwable e) {
        ClosedEvent future = new ClosedEvent(e);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
    }

    public AsyncDatagram.ReaderSet setReader(final ReadHandler<AsyncDatagram> handler) {
        final ReaderSetEvent event = new ReaderSetEvent(handler);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Handler h = new Handler(){

                    public void handle(Object ignore) {
                        DefaultDatagram.this.readAvailable();
                    }
                };
                DefaultDatagram.this.readLock.lock();
                try {
                    DefaultDatagram.this.reader = handler;
                    DefaultDatagram.this.cancelRead = DefaultDatagram.this.netHandler.datagramStartReading(DefaultDatagram.this, DefaultDatagram.this.channel, h);
                    event.set(null);
                }
                catch (IOException e) {
                    event.setException(e);
                    DefaultDatagram.this.readClose(e);
                }
                finally {
                    DefaultDatagram.this.readLock.unlock();
                }
            }
        };
        this.netHandler.datagramRegisterReadCommand(r);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAvailable() {
        boolean gotLock = this.readLock.tryLock();
        if (gotLock) {
            try {
                if (this.reader != null) {
                    try {
                        this.reader.handle((Object)this);
                    }
                    catch (IOException e) {
                        this.readClose(e);
                    }
                    catch (RuntimeException e) {
                        this.readClose(e);
                    }
                } else {
                    System.err.println("datagram: readAvailable");
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    private void tryAndWriteSocketEvents() {
        if (this.writeState.compareAndSet(0, 1)) {
            while (true) {
                this.currentWrite = this.writes.poll();
                if (this.currentWrite == null) {
                    this.writeState.set(0);
                    if (this.writes.size() != 0 && this.writeState.compareAndSet(0, 1)) continue;
                    return;
                }
                if (this.currentWrite.tryWrite() < 1L) break;
            }
            this.netHandler.datagramRegisterWriteCommand(this.currentWrite);
            return;
        }
    }

    private void closed(Throwable cause, IOException closeFailure) {
        Handler<AsyncDatagram> handler;
        DatagramMonitor m = this.monitor;
        if (m != null) {
            try {
                m.closed((AsyncDatagram)this, cause);
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        if ((handler = this.closeHandler) != null) {
            try {
                if (cause != null && handler instanceof ErroneousHandler) {
                    ((ErroneousHandler)handler).handle((Object)this, cause);
                } else {
                    handler.handle((Object)this);
                }
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        this.netHandler.datagramClosed(this, cause);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrittenEvent
    extends BaseEvent<Long>
    implements AsyncDatagram.Written,
    Handler {
        private final ByteBuffer[] srcs;
        private final int offset;
        private final int length;
        private final SocketAddress address;
        volatile long bytesWritten;

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public SocketAddress getAddress() {
            return this.address;
        }

        public ByteBuffer[] getSrcs() {
            return this.srcs;
        }

        public void handle(Object o) {
            long bytesWritten;
            while (true) {
                if (DefaultDatagram.this.currentWrite == null) {
                    DefaultDatagram.this.currentWrite = (WrittenEvent)DefaultDatagram.this.writes.poll();
                }
                if (DefaultDatagram.this.currentWrite == null) {
                    DefaultDatagram.this.writeState.compareAndSet(2, 0);
                    if (DefaultDatagram.this.writes.size() != 0 && DefaultDatagram.this.writeState.compareAndSet(0, 2)) continue;
                    this.deregisterSelector();
                    return;
                }
                bytesWritten = DefaultDatagram.this.currentWrite.tryWrite();
                if (bytesWritten <= 0L) break;
                DefaultDatagram.this.currentWrite = null;
            }
            if (bytesWritten == 0L) {
                return;
            }
        }

        private void deregisterSelector() {
            try {
                if (DefaultDatagram.this.cancelWrite != null) {
                    DefaultDatagram.this.cancelWrite.call();
                }
            }
            catch (Exception e) {
                DefaultDatagram.this.writeClose(e);
            }
        }

        private void registerSelector() {
            try {
                DefaultDatagram.this.cancelWrite = DefaultDatagram.this.netHandler.datagramStartWriting(DefaultDatagram.this, DefaultDatagram.this.channel, this);
            }
            catch (IOException ioe) {
                DefaultDatagram.this.writeClose(ioe);
            }
        }

        @Override
        public void run() {
            if (DefaultDatagram.this.writeState.compareAndSet(1, 2)) {
                while (true) {
                    if (DefaultDatagram.this.currentWrite == null) {
                        DefaultDatagram.this.currentWrite = (WrittenEvent)DefaultDatagram.this.writes.poll();
                    }
                    if (DefaultDatagram.this.currentWrite == null) {
                        DefaultDatagram.this.writeState.compareAndSet(2, 0);
                        if (DefaultDatagram.this.writes.size() != 0 && DefaultDatagram.this.writeState.compareAndSet(0, 2)) continue;
                        return;
                    }
                    long trywrite = DefaultDatagram.this.currentWrite.tryWrite();
                    if (trywrite < 1L) {
                        this.registerSelector();
                        return;
                    }
                    DefaultDatagram.this.currentWrite = null;
                }
            }
        }

        long tryWrite() {
            long bytes;
            DatagramMonitor m = DefaultDatagram.this.monitor;
            if (m != null) {
                DefaultDatagram.this.monitor.preWrite((AsyncDatagram)DefaultDatagram.this, this.getSrcs(), this.getOffset(), this.getLength());
            }
            try {
                bytes = this.getSrcs().length == 1 ? (long)DefaultDatagram.this.channel.write(this.getSrcs()[0]) : DefaultDatagram.this.channel.write(this.getSrcs(), this.getOffset(), this.getLength());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (m != null) {
                    DefaultDatagram.this.monitor.postWrite((AsyncDatagram)DefaultDatagram.this, 0L, this.getSrcs(), this.getOffset(), this.getLength(), DefaultDatagram.this.writeAttempts, (Throwable)e);
                }
                this.setException(e);
                DefaultDatagram.this.writeAttempts = 0;
                return 1L;
            }
            if (m != null) {
                DefaultDatagram.this.monitor.postWrite((AsyncDatagram)DefaultDatagram.this, bytes, this.getSrcs(), this.getOffset(), this.getLength(), DefaultDatagram.this.writeAttempts, null);
            }
            if (bytes > 0L) {
                this.bytesWritten += bytes;
                DefaultDatagram.this.bytesWritten.addAndGet(bytes);
                DefaultDatagramGroup grp = DefaultDatagram.this.group;
                if (DefaultDatagram.this.group != null) {
                    DefaultDatagram.this.group.addNumberOfBytesWritten(bytes);
                }
                DefaultDatagram.this.netHandler.datagramWritten(DefaultDatagram.this, bytes);
            }
            if (!this.hasRemaining()) {
                DefaultDatagram.this.writeAttempts++;
                return -bytes;
            }
            DefaultDatagram.this.writeAttempts = 0;
            this.set(new Long(this.bytesWritten));
            return 1L;
        }

        boolean hasRemaining() {
            for (int i = 0; i < this.length; ++i) {
                if (!this.srcs[i + this.offset].hasRemaining()) continue;
                return false;
            }
            return true;
        }

        WrittenEvent(SocketAddress address, ByteBuffer[] srcs, int offset, int length) {
            this.srcs = srcs;
            this.offset = offset;
            this.length = length;
            this.address = address;
        }

        WrittenEvent(SocketAddress address, ByteBuffer src) {
            this(address, new ByteBuffer[]{src}, 0, 1);
        }
    }

    private class ClosedEvent
    extends BaseEvent
    implements AsyncDatagram.Closed {
        private final Throwable cause;

        private ClosedEvent(Throwable cause) {
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object call() throws Exception {
            try {
                DefaultDatagram.this.innerSetGroup(CLOSED_GROUP);
                DefaultDatagram.this.channel.close();
                DefaultDatagram.this.closed(this.cause, null);
            }
            catch (IOException e) {
                DefaultDatagram.this.closed(this.cause, e);
                throw e;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReaderSetEvent
    extends BaseEvent
    implements AsyncDatagram.ReaderSet {
        private final ReadHandler<AsyncDatagram> reader;

        private ReaderSetEvent(ReadHandler<AsyncDatagram> reader) {
            this.reader = reader;
        }

        public ReadHandler<AsyncDatagram> getReader() {
            return this.reader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncDatagram.Event>
    implements AsyncDatagram.Event {
        private BaseEvent() {
            super(DefaultDatagram.this.defaultExecutor, DefaultDatagram.this.defaultDestination);
        }

        public AsyncDatagram async() {
            return DefaultDatagram.this;
        }

        @Override
        public int getColor() {
            return DefaultDatagram.this.getColor();
        }

        public void setDestination(Offerable<? super AsyncDatagram.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncDatagram.Event> dest, final Throwable t) {
            AsyncDatagram.ErroneousEvent error = new AsyncDatagram.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public int getColor() {
                    return DefaultDatagram.this.getColor();
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public AsyncDatagram.Event getEvent() {
                    return BaseEvent.this;
                }

                public AsyncDatagram async() {
                    return DefaultDatagram.this;
                }
            };
            dest.offer((Object)error);
        }
    }

    private class ReaderSource
    implements AsyncDatagramSource {
        private ReaderSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(ByteBuffer[] srcs, int offset, int length) {
            DefaultDatagram.this.readLock.lock();
            try {
                DatagramMonitor m = DefaultDatagram.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncDatagram)DefaultDatagram.this, srcs, offset, length);
                    }
                    catch (RuntimeException e) {
                        DefaultDatagram.this.readClose(e);
                    }
                }
                long read = DefaultDatagram.this.channel.read(srcs, offset, length);
                if (m != null) {
                    try {
                        m.postRead((AsyncDatagram)DefaultDatagram.this, read, srcs, offset, length, null);
                    }
                    catch (RuntimeException e) {
                        DefaultDatagram.this.readClose(e);
                    }
                }
                if (read > 0L) {
                    DefaultDatagram.this.bytesRead.addAndGet(read);
                    DefaultDatagramGroup grp = DefaultDatagram.this.group;
                    if (DefaultDatagram.this.group != null) {
                        DefaultDatagram.this.group.addNumberOfBytesRead(read);
                    }
                    DefaultDatagram.this.netHandler.datagramRead(DefaultDatagram.this, read);
                }
                if (read == -1L) {
                    if (DefaultDatagram.this.cancelRead != null) {
                        DefaultDatagram.this.cancelRead.call();
                    }
                    DefaultDatagram.this.readClose(new IOException("read returned -1"));
                }
                long l = read;
                return l;
            }
            catch (Exception e) {
                DefaultDatagram.this.readClose(e);
                long l = -1L;
                return l;
            }
            finally {
                DefaultDatagram.this.readLock.unlock();
            }
        }

        public long read(ByteBuffer[] srcs) {
            return this.read(srcs, 0, srcs.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer src) {
            DefaultDatagram.this.readLock.lock();
            try {
                DatagramMonitor m = DefaultDatagram.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncDatagram)DefaultDatagram.this, new ByteBuffer[]{src}, 0, 1);
                    }
                    catch (RuntimeException e) {
                        DefaultDatagram.this.readClose(e);
                    }
                }
                int read = DefaultDatagram.this.channel.read(src);
                if (m != null) {
                    try {
                        m.postRead((AsyncDatagram)DefaultDatagram.this, (long)read, new ByteBuffer[]{src}, 0, 1, null);
                    }
                    catch (RuntimeException e) {
                        DefaultDatagram.this.readClose(e);
                    }
                }
                if (read > 0) {
                    DefaultDatagram.this.bytesRead.addAndGet(read);
                    DefaultDatagramGroup grp = DefaultDatagram.this.group;
                    if (DefaultDatagram.this.group != null) {
                        DefaultDatagram.this.group.addNumberOfBytesRead(read);
                    }
                    DefaultDatagram.this.netHandler.datagramRead(DefaultDatagram.this, read);
                }
                if (read == -1) {
                    if (DefaultDatagram.this.cancelRead != null) {
                        DefaultDatagram.this.cancelRead.call();
                    }
                    DefaultDatagram.this.readClose(new IOException("read returned -1"));
                }
                int n = read;
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
                DefaultDatagram.this.readClose(e);
                int n = -1;
                return n;
            }
            finally {
                DefaultDatagram.this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketAddress receive(ByteBuffer src) throws IOException {
            DefaultDatagram.this.readLock.lock();
            try {
                DatagramMonitor m = DefaultDatagram.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncDatagram)DefaultDatagram.this, new ByteBuffer[]{src}, 0, 1);
                    }
                    catch (RuntimeException e) {
                        DefaultDatagram.this.readClose(e);
                    }
                }
                int preRead = src.remaining();
                SocketAddress adr = DefaultDatagram.this.channel.receive(src);
                int read = src.remaining() - preRead;
                if (m != null) {
                    try {
                        m.postRead((AsyncDatagram)DefaultDatagram.this, 0L, new ByteBuffer[]{src}, 0, 1, null);
                    }
                    catch (RuntimeException e) {
                        DefaultDatagram.this.readClose(e);
                    }
                }
                if (read > 0) {
                    DefaultDatagram.this.bytesRead.addAndGet(read);
                    DefaultDatagram.this.netHandler.datagramRead(DefaultDatagram.this, read);
                }
                SocketAddress socketAddress = adr;
                return socketAddress;
            }
            catch (Exception e) {
                DefaultDatagram.this.readClose(e);
                SocketAddress socketAddress = null;
                return socketAddress;
            }
            finally {
                DefaultDatagram.this.readLock.unlock();
            }
        }

        public boolean isOpen() {
            return DefaultDatagram.this.isOpen();
        }

        public void close() throws IOException {
            DefaultDatagram.this.close();
        }
    }
}

