/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.AsyncFile;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.defaults.DefaultFileHandler;
import coconut.aio.defaults.DefaultNetHandler;
import coconut.aio.defaults.MBeanProvider;
import coconut.aio.management.DatagramMBean;
import coconut.aio.management.FileMBean;
import coconut.aio.management.ServerSocketMBean;
import coconut.aio.management.SocketMBean;
import coconut.aio.monitor.DatagramGroupMonitor;
import coconut.aio.monitor.DatagramMonitor;
import coconut.aio.monitor.FileMonitor;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.aio.monitor.SocketGroupMonitor;
import coconut.aio.monitor.SocketMonitor;
import coconut.aio.spi.AioProvider;
import coconut.core.Offerable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultAioProvider
extends AioProvider {
    private final Lock lock = new ReentrantLock();
    private final DefaultNetHandler netHandler;
    private final DefaultFileHandler fileHandler;
    private MBeanProvider builder;
    private int status;

    public DefaultAioProvider() {
        AtomicLong l = new AtomicLong();
        this.netHandler = new DefaultNetHandler(l);
        this.fileHandler = new DefaultFileHandler(l);
    }

    private void checkJMXStarted() throws Exception {
        String disabled;
        if (this.builder == null && !Boolean.parseBoolean(disabled = properties.getProperty("coconut.aio.jmx.disabled", "-1"))) {
            String mbeanServerName = properties.getProperty("coconut.aio.jmx.mbeanserver");
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.builder = new MBeanProvider(mbs, properties, true);
            try {
                String name = properties.getProperty("coconut.aio.jmx.serversocket", "coconut.aio:type=ServerSocket");
                this.builder.registerServerSocket(name, this.getServerSocketMXBeanServer());
                name = properties.getProperty("coconut.aio.jmx.socket", "coconut.aio:type=Socket");
                this.builder.registerSocket(name, this.getSocketMXBeanServer());
                name = properties.getProperty("coconut.aio.jmx.datagram", "coconut.aio:type=Datagram");
                this.builder.registerDatagram(name, this.getDatagramMXBeanServer());
                name = properties.getProperty("coconut.aio.jmx.file", "coconut.aio:type=File");
                this.builder.registerFile(name, this.getFileMXBeanServer());
            }
            catch (InstanceAlreadyExistsException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNetStarted() {
        block7: {
            try {
                this.lock.lock();
                if ((this.status & 1) == 0) {
                    try {
                        this.netHandler.start();
                        this.checkJMXStarted();
                    }
                    catch (Exception ioe) {
                        throw new IllegalStateException("Could not start AIO layer", ioe);
                    }
                    this.status |= 1;
                    break block7;
                }
                if (this.status == 4) {
                    throw new IllegalStateException("Coconut-AIO layer closed");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileStarted() {
        block7: {
            try {
                this.lock.lock();
                if ((this.status & 2) == 0) {
                    try {
                        this.fileHandler.start();
                        this.checkJMXStarted();
                    }
                    catch (Exception ioe) {
                        throw new IllegalStateException("Could not start AIO layer", ioe);
                    }
                    this.status |= 2;
                    break block7;
                }
                if (this.status == 4) {
                    throw new IllegalStateException("Coconut-AIO layer closed");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block10: {
            try {
                this.lock.lock();
                if ((this.status & 1) != 0) {
                    this.netHandler.shutdown();
                    try {
                        if (this.builder != null) {
                            this.builder.stop();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if ((this.status & 2) == 0) break block10;
                this.fileHandler.shutdown();
                try {
                    if (this.builder != null) {
                        this.builder.stop();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public AsyncDatagramGroup openDatagramGroup() {
        this.checkNetStarted();
        return this.netHandler.openDatagramGroup();
    }

    public AsyncSocketGroup openSocketGroup() {
        this.checkNetStarted();
        return this.netHandler.openSocketGroup();
    }

    public ServerSocketMBean getServerSocketMXBeanServer() {
        return this.netHandler.getServerSocketMXBean();
    }

    public SocketMBean getSocketMXBeanServer() {
        return this.netHandler.getSocketMXBean();
    }

    public DatagramMBean getDatagramMXBeanServer() {
        return this.netHandler.getDatagramMXBean();
    }

    public FileMBean getFileMXBeanServer() {
        return this.fileHandler.getFileMXBean();
    }

    public void setDefaultMonitor(FileMonitor monitor) {
        this.fileHandler.defaultFileMonitor = monitor;
    }

    public FileMonitor getDefaultFileMonitor() {
        return this.fileHandler.defaultFileMonitor;
    }

    public void setDefaultMonitor(ServerSocketMonitor monitor) {
        this.netHandler.defaultServerSocketMonitor = monitor;
    }

    public ServerSocketMonitor getDefaultServerSocketMonitor() {
        return this.netHandler.defaultServerSocketMonitor;
    }

    public void setDefaultMonitor(SocketMonitor monitor) {
        this.netHandler.defaultSocketMonitor = monitor;
    }

    public SocketMonitor getDefaultSocketMonitor() {
        return this.netHandler.defaultSocketMonitor;
    }

    public void setDefaultMonitor(SocketGroupMonitor monitor) {
        this.netHandler.defaultSocketGroupMonitor = monitor;
    }

    public SocketGroupMonitor getDefaultSocketGroupMonitor() {
        return this.netHandler.defaultSocketGroupMonitor;
    }

    public void setDefaultMonitor(DatagramMonitor monitor) {
        this.netHandler.defaultDatagramMonitor = monitor;
    }

    public DatagramMonitor getDefaultDatagramMonitor() {
        return this.netHandler.defaultDatagramMonitor;
    }

    public void setDefaultMonitor(DatagramGroupMonitor monitor) {
        this.netHandler.defaultDatagramGroupMonitor = monitor;
    }

    public DatagramGroupMonitor getDefaultDatagramGroupMonitor() {
        return this.netHandler.defaultDatagramGroupMonitor;
    }

    public AsyncServerSocket openServerSocket() throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncServerSocket(null, null);
    }

    public AsyncDatagram openDatagram() throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncDatagram(null, null);
    }

    public AsyncFile openFile() {
        this.checkFileStarted();
        return this.fileHandler.openFile(null, null);
    }

    public AsyncSocket openSocket() throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncSocket(null, null);
    }

    public AsyncServerSocket openServerSocket(Offerable<? super AsyncServerSocket.Event> destination) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncServerSocket(destination, null);
    }

    public AsyncDatagram openDatagram(Offerable<? super AsyncDatagram.Event> destination) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncDatagram(destination, null);
    }

    public AsyncFile openFile(Offerable<? super AsyncFile.Event> destination) {
        this.checkFileStarted();
        return this.fileHandler.openFile(destination, null);
    }

    public AsyncSocket openSocket(Offerable<? super AsyncSocket.Event> destination) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncSocket(destination, null);
    }

    public AsyncServerSocket openServerSocket(Executor executor) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncServerSocket(null, executor);
    }

    public AsyncDatagram openDatagram(Executor executor) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncDatagram(null, executor);
    }

    public AsyncFile openFile(Executor executor) {
        this.checkFileStarted();
        return this.fileHandler.openFile(null, executor);
    }

    public AsyncSocket openSocket(Executor executor) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncSocket(null, executor);
    }

    public AsyncServerSocket openServerSocket(final Queue<? super AsyncServerSocket.Event> queue) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncServerSocket((Offerable<? super AsyncServerSocket.Event>)new Offerable<AsyncServerSocket.Event>(){

            public boolean offer(AsyncServerSocket.Event o) {
                return queue.offer(o);
            }
        }, null);
    }

    public AsyncFile openFile(final Queue<? super AsyncFile.Event> queue) throws IOException {
        this.checkFileStarted();
        return this.fileHandler.openFile((Offerable<? super AsyncFile.Event>)new Offerable<AsyncFile.Event>(){

            public boolean offer(AsyncFile.Event o) {
                return queue.offer(o);
            }
        }, null);
    }

    public AsyncDatagram openDatagram(final Queue<? super AsyncDatagram.Event> queue) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncDatagram((Offerable<? super AsyncDatagram.Event>)new Offerable<AsyncDatagram.Event>(){

            public boolean offer(AsyncDatagram.Event o) {
                return queue.offer(o);
            }
        }, null);
    }

    public AsyncSocket openSocket(final Queue<? super AsyncSocket.Event> queue) throws IOException {
        this.checkNetStarted();
        return this.netHandler.openAsyncSocket((Offerable<? super AsyncSocket.Event>)new Offerable<AsyncSocket.Event>(){

            public boolean offer(AsyncSocket.Event o) {
                return queue.offer(o);
            }
        }, null);
    }
}

