/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.management.DatagramMBean;
import coconut.aio.management.FileMBean;
import coconut.aio.management.ServerSocketMBean;
import coconut.aio.management.SocketMBean;
import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

class MBeanInfoBuilder {
    private final MBeanServer mbs;
    private final boolean printInfo;
    private JMXConnectorServer cs;
    private final Properties props;

    MBeanInfoBuilder(MBeanServer server, Properties props, boolean printInfo) {
        this.mbs = server;
        this.printInfo = printInfo;
        this.props = props;
    }

    public void registerSocket(String objectName, SocketMBean mbean) throws Exception {
        ObjectName oName = ObjectName.getInstance(objectName);
        this.mbs.registerMBean(new SocketMBeanImpl(mbean), oName);
        this.printInfo(this.mbs.getMBeanInfo(oName));
    }

    public void registerDatagram(String objectName, DatagramMBean mbean) throws Exception {
        ObjectName oName = ObjectName.getInstance(objectName);
        this.mbs.registerMBean(new DatagramMBeanImpl(mbean), oName);
        this.printInfo(this.mbs.getMBeanInfo(oName));
    }

    public void registerFile(String objectName, FileMBean mbean) throws Exception {
        ObjectName oName = ObjectName.getInstance(objectName);
        this.mbs.registerMBean(new FileMBeanImpl(mbean), oName);
        this.printInfo(this.mbs.getMBeanInfo(oName));
    }

    public void registerServerSocket(String objectName, ServerSocketMBean mbean) throws Exception {
        ObjectName oName = ObjectName.getInstance(objectName);
        this.mbs.registerMBean(new ServerSocketMBeanImpl(mbean), oName);
        this.printInfo(this.mbs.getMBeanInfo(oName));
    }

    private void printInfo(MBeanInfo info) {
    }

    public void start(String serverURL) throws IOException {
        JMXServiceURL url = new JMXServiceURL(serverURL);
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbs);
        this.cs.start();
    }

    public void stop() throws IOException {
        if (this.cs != null) {
            this.cs.stop();
        }
    }

    private class FileMBeanImpl
    extends StandardMBean {
        private FileMBeanImpl(FileMBean bean) throws NotCompliantMBeanException {
            super(bean, FileMBean.class);
        }

        protected String getDescription(MBeanAttributeInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.filedesc." + info.getName(), "No Description");
            return desc;
        }

        protected String getDescription(MBeanOperationInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.filedesc." + info.getName(), "No Description");
            return desc;
        }
    }

    private class DatagramMBeanImpl
    extends StandardMBean {
        private DatagramMBeanImpl(DatagramMBean bean) throws NotCompliantMBeanException {
            super(bean, DatagramMBean.class);
        }

        protected String getDescription(MBeanAttributeInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.datagramsocketdesc." + info.getName(), "No Description");
            return desc;
        }

        protected String getDescription(MBeanOperationInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.datagramsocketdesc." + info.getName(), "No Description");
            return desc;
        }
    }

    private class ServerSocketMBeanImpl
    extends StandardMBean {
        private ServerSocketMBeanImpl(ServerSocketMBean bean) throws NotCompliantMBeanException {
            super(bean, ServerSocketMBean.class);
        }

        protected String getDescription(MBeanAttributeInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.serversocketdesc." + info.getName(), "No Description");
            return desc;
        }

        protected String getDescription(MBeanOperationInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.serversocketdesc." + info.getName(), "No Description");
            return desc;
        }
    }

    private class SocketMBeanImpl
    extends StandardMBean {
        private SocketMBeanImpl(SocketMBean bean) throws NotCompliantMBeanException {
            super(bean, SocketMBean.class);
        }

        protected String getDescription(MBeanAttributeInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.socketdesc." + info.getName(), "No Description");
            return desc;
        }

        protected String getDescription(MBeanOperationInfo info) {
            String desc = MBeanInfoBuilder.this.props.getProperty("coconut.aio.jmx.socketdesc." + info.getName(), "No Description");
            return desc;
        }
    }
}

