/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.ReadHandler;
import coconut.aio.defaults.DefaultSocket;
import coconut.aio.defaults.NetHandler;
import coconut.aio.management.SocketGroupInfo;
import coconut.aio.monitor.SocketGroupMonitor;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultSocketGroup
extends AsyncSocketGroup {
    private final ConcurrentHashMap<AsyncSocket, AsyncSocket> sockets = new ConcurrentHashMap();
    private final NetHandler handler;
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private volatile SocketGroupMonitor monitor;
    private final long id;
    private volatile Executor e;
    private volatile Offerable<? super AsyncSocket.Event> offerable;
    private volatile ReadHandler<AsyncSocket> reader;
    private volatile Handler<AsyncSocket> joinHandler;
    private volatile Handler<AsyncSocket> leaveHandler;

    DefaultSocketGroup(NetHandler handler, long id, SocketGroupMonitor monitor) {
        this.monitor = monitor;
        this.handler = handler;
        this.id = id;
    }

    public AsyncSocketGroup setDefaultExecutor(Executor executor) {
        this.e = executor;
        return this;
    }

    public AsyncSocketGroup setDefaultDestination(Offerable<? super AsyncSocket.Event> offerable) {
        this.offerable = offerable;
        return this;
    }

    public AsyncSocketGroup setDefaultReader(ReadHandler<AsyncSocket> callback) {
        this.reader = callback;
        return this;
    }

    public AsyncSocketGroup setJoinHandler(Handler<AsyncSocket> handler) {
        this.joinHandler = handler;
        return this;
    }

    void added(DefaultSocket s) {
        SocketGroupMonitor m;
        this.sockets.put(s, s);
        this.handler.groupJoined(this, s);
        Handler<AsyncSocket> handler = this.joinHandler;
        if (handler != null) {
            try {
                handler.handle((Object)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((m = this.monitor) != null) {
            try {
                m.join((AsyncSocketGroup)this, (AsyncSocket)s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean add(AsyncSocket socket) {
        if (!(socket instanceof DefaultSocket)) {
            throw new IllegalArgumentException("This socket is not created with same provider as this group");
        }
        DefaultSocket s = (DefaultSocket)socket;
        return s.innerSetGroup(this);
    }

    public int size() {
        return this.sockets.size();
    }

    public boolean contains(Object element) {
        return this.sockets.containsKey(element);
    }

    public AsyncSocketGroup setLeaveHandler(Handler<AsyncSocket> handler) {
        this.leaveHandler = handler;
        return this;
    }

    boolean innerRemove(DefaultSocket socket) {
        boolean removed;
        boolean bl = removed = this.sockets.remove((Object)socket) != null;
        if (removed) {
            SocketGroupMonitor m;
            Handler<AsyncSocket> handler = this.leaveHandler;
            if (handler != null) {
                handler.handle((Object)socket);
            }
            if ((m = this.monitor) != null) {
                try {
                    m.leave((AsyncSocketGroup)this, (AsyncSocket)socket, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return removed;
    }

    public boolean remove(Object o) {
        DefaultSocket socket = (DefaultSocket)this.sockets.get(o);
        if (socket != null) {
            socket.innerSetGroup(null);
            return true;
        }
        return false;
    }

    public Iterator<AsyncSocket> iterator() {
        return this.sockets.values().iterator();
    }

    public long getId() {
        return this.id;
    }

    public Executor getDefaultExecutor() {
        return this.e;
    }

    public Offerable<? super AsyncSocket.Event> getDefaultDestination() {
        return this.offerable;
    }

    public ReadHandler<AsyncSocket> getDefaultReader() {
        return this.reader;
    }

    public Handler<AsyncSocket> getJoinHandler() {
        return this.joinHandler;
    }

    public Handler<AsyncSocket> getLeaveHandler() {
        return this.leaveHandler;
    }

    protected void finalize() {
        this.handler.groupClosed(this);
    }

    public SocketGroupMonitor getMonitor() {
        return this.monitor;
    }

    public AsyncSocketGroup setMonitor(SocketGroupMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    SocketGroupInfo getSocketInfo() {
        return new SocketGroupInfo(this.id, this.size(), this.bytesRead.get(), this.bytesWritten.get());
    }

    long getNumberOfBytesRead() {
        return this.bytesRead.get();
    }

    long getNumberOfBytesWritten() {
        return this.bytesWritten.get();
    }

    void addNumberOfBytesRead(long number) {
        this.bytesRead.addAndGet(number);
    }

    void addNumberOfBytesWritten(long number) {
        this.bytesWritten.addAndGet(number);
    }
}

