/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AioFuture;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.ReadHandler;
import coconut.aio.defaults.AioFutureTask;
import coconut.aio.defaults.ByteBufferUtil;
import coconut.aio.defaults.DefaultSocketGroup;
import coconut.aio.defaults.NetHandler;
import coconut.aio.management.SocketInfo;
import coconut.aio.monitor.SocketMonitor;
import coconut.core.ErroneousHandler;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultSocket
extends AsyncSocket {
    private static final DefaultSocketGroup CLOSED_GROUP = new DefaultSocketGroup(null, -1L, null);
    private final long id;
    private final NetHandler netHandler;
    private final SocketChannel channel;
    private final AtomicLong commitedWriteBytes = new AtomicLong();
    private final AtomicInteger commitQueueLength = new AtomicInteger();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicReference<AsyncSocket.Closed> closeFuture = new AtomicReference();
    volatile Executor defaultExecutor;
    volatile Offerable<? super AsyncSocket.Event> defaultDestination;
    private volatile long writeByteLimit = Long.MAX_VALUE;
    private volatile int writeQueueLimit = Integer.MAX_VALUE;
    private volatile Object attachment;
    private volatile Handler<AsyncSocket> closeHandler;
    private volatile SocketMonitor monitor;
    private final Lock groupLock = new ReentrantLock();
    private volatile DefaultSocketGroup group;
    private final AtomicInteger writeState = new AtomicInteger();
    private final Lock writeLock = new ReentrantLock();
    private final Queue<WrittenEvent> writes = new ConcurrentLinkedQueue<WrittenEvent>();
    private volatile WrittenEvent currentWrite;
    private Callable cancelWrite;
    private int numberOfEmptyWriteSelects;
    private int writeAttempts;
    private ConnectedEvent connectionCallback;
    private volatile int connectState;
    private final ReaderSource sourceAdapter = new ReaderSource();
    private Callable cancelRead;
    private final Lock readLock = new ReentrantLock();
    private volatile ReadHandler<AsyncSocket> reader;

    DefaultSocket(NetHandler handler, long id, SocketChannel channel, SocketMonitor monitor, Offerable<? super AsyncSocket.Event> destination, Executor executor) {
        this.netHandler = handler;
        this.channel = channel;
        this.id = id;
        this.defaultExecutor = executor;
        this.defaultDestination = destination;
        this.monitor = monitor;
    }

    public long getId() {
        return this.id;
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public Socket socket() {
        return this.channel.socket();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public boolean isOpen() {
        return this.closeFuture.get() == null;
    }

    public String toString() {
        return this.socket().toString();
    }

    public AsyncSocket setBufferLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeByteLimit = limit;
        return this;
    }

    public long getBufferLimit() {
        return this.writeByteLimit;
    }

    public AsyncSocket setWriteQueueLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be 0 or greater");
        }
        this.writeQueueLimit = limit;
        return this;
    }

    public int getWriteQueueLimit() {
        return this.writeQueueLimit;
    }

    public InetAddress getInetAddress() {
        return this.socket().getInetAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket().getLocalSocketAddress();
    }

    public int getPort() {
        return this.socket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socket().getLocalAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket().getRemoteSocketAddress();
    }

    public int getLocalPort() {
        return this.socket().getLocalPort();
    }

    public boolean isBound() {
        return this.socket().isBound();
    }

    public AsyncSocket setMonitor(SocketMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SocketMonitor getMonitor() {
        return this.monitor;
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }

    public Offerable<? super AsyncSocket.Event> getDefaultDestination() {
        return this.defaultDestination;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncSocket setCloseHandler(Handler<AsyncSocket> handler) {
        this.closeHandler = handler;
        return this;
    }

    public Handler<AsyncSocket> getCloseHandler() {
        return this.closeHandler;
    }

    public AsyncSocketGroup getGroup() {
        return this.group;
    }

    public ScatteringByteChannel getSource() {
        return this.sourceAdapter;
    }

    public ReadHandler<AsyncSocket> getReader() {
        return this.reader;
    }

    public AsyncSocket setGroup(AsyncSocketGroup group) {
        if (group != null && !(group instanceof DefaultSocketGroup)) {
            throw new IllegalArgumentException("This group is not created with same provider as this socket");
        }
        this.innerSetGroup((DefaultSocketGroup)group);
        return this;
    }

    public AsyncSocket bind(SocketAddress address) throws IOException {
        SocketMonitor m = this.monitor;
        try {
            this.socket().bind(address);
        }
        catch (RuntimeException e) {
            if (m != null) {
                m.bindFailed((AsyncSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (m != null) {
                m.bindFailed((AsyncSocket)this, address, (Throwable)e);
            }
            throw e;
        }
        if (m != null) {
            m.bound((AsyncSocket)this, address);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncSocket.Connected connect(SocketAddress address) {
        final ConnectedEvent c = new ConnectedEvent(address);
        this.writeLock.lock();
        try {
            if (this.connectState == 1) {
                throw new ConnectionPendingException();
            }
            if (this.connectState == 2) {
                throw new AlreadyConnectedException();
            }
            boolean isConnected = this.channel.connect(address);
            if (isConnected) {
                this.connectState = 2;
                c.set((Object)this);
                this.tryAndWriteSocketEvents();
            } else {
                this.connectState = 1;
                this.netHandler.socketRegisterConnectCommand(new Runnable(){

                    public void run() {
                        try {
                            DefaultSocket.this.netHandler.socketStartConnecting(DefaultSocket.this, DefaultSocket.this.channel, new Handler(){

                                public void handle(Object key) {
                                    try {
                                        if (!DefaultSocket.this.channel.finishConnect()) {
                                            throw new IllegalStateException("Bug in the NIO implementation");
                                        }
                                        ((SelectionKey)key).cancel();
                                        DefaultSocket.this.connectState = 2;
                                        c.set((Object)DefaultSocket.this);
                                    }
                                    catch (RuntimeException e) {
                                        c.setException(e);
                                        DefaultSocket.this.connectClose(e);
                                    }
                                    catch (IOException e) {
                                        c.setException(e);
                                        DefaultSocket.this.connectClose(e);
                                    }
                                    if (DefaultSocket.this.connectState == 2) {
                                        DefaultSocket.this.tryAndWriteSocketEvents();
                                    }
                                }
                            });
                        }
                        catch (RuntimeException e) {
                            c.setException(e);
                            DefaultSocket.this.connectClose(e);
                        }
                        catch (IOException e) {
                            c.setException(e);
                            DefaultSocket.this.connectClose(e);
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            c.setException(e);
            this.outerClose(e);
        }
        finally {
            this.writeLock.unlock();
        }
        return c;
    }

    public AsyncSocket.Written write(ByteBuffer buffer) {
        this.checkBufferLimit(ByteBufferUtil.calcSize(buffer));
        WrittenEvent future = new WrittenEvent(buffer);
        this.writes.add(future);
        this.tryAndWriteSocketEvents();
        return future;
    }

    public AsyncSocket.Written write(ByteBuffer[] buffer, int offset, int length) {
        this.checkBufferLimit(ByteBufferUtil.calcSize(buffer));
        WrittenEvent future = new WrittenEvent(buffer, offset, length);
        this.writes.add(future);
        this.tryAndWriteSocketEvents();
        return future;
    }

    public AsyncSocket.Closed close() {
        ClosedEvent future = new ClosedEvent(null);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
        return this.closeFuture.get();
    }

    private void checkBufferLimit(long bytes) throws RejectedExecutionException {
        int currentSize;
        do {
            if ((currentSize = this.commitQueueLength.get()) == Integer.MAX_VALUE || currentSize < this.writeQueueLimit) continue;
            throw new RejectedExecutionException();
        } while (!this.commitQueueLength.compareAndSet(currentSize, currentSize + 1));
        do {
            if ((currentSize = this.commitedWriteBytes.get()) == Long.MAX_VALUE || currentSize + bytes <= this.writeByteLimit) continue;
            this.commitQueueLength.decrementAndGet();
            throw new RejectedExecutionException();
        } while (!this.commitedWriteBytes.compareAndSet(currentSize, currentSize + bytes));
    }

    SocketInfo getSocketInfo() {
        DefaultSocketGroup soc = this.group;
        return new SocketInfo(this.id, 0L, 0L, this.group == null ? 0L : this.group.getId(), this.socket(), this.bytesRead.get(), this.bytesWritten.get());
    }

    long getNumberOfBytesRead() {
        return this.bytesRead.get();
    }

    long getNumberOfBytesWritten() {
        return this.bytesWritten.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean innerSetGroup(DefaultSocketGroup newGroup) {
        try {
            this.groupLock.lock();
            DefaultSocketGroup currentGroup = this.group;
            if (currentGroup != CLOSED_GROUP && currentGroup != newGroup) {
                if (currentGroup != null) {
                    currentGroup.innerRemove(this);
                }
                if (newGroup != null && newGroup != CLOSED_GROUP) {
                    this.defaultExecutor = newGroup.getDefaultExecutor();
                    this.defaultDestination = newGroup.getDefaultDestination();
                    ReadHandler<AsyncSocket> r = newGroup.getDefaultReader();
                    if (r != null) {
                        this.setReader(this.reader);
                    }
                    newGroup.added(this);
                }
                this.group = newGroup;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.groupLock.unlock();
        }
        return false;
    }

    private void outerClose(Throwable e) {
        this.connectClose(e);
    }

    private void readClose(Throwable e) {
        this.connectClose(e);
    }

    private void writeClose(Throwable e) {
        this.connectClose(e);
    }

    private void connectClose(Throwable e) {
        ClosedEvent future = new ClosedEvent(e);
        if (this.closeFuture.compareAndSet(null, future)) {
            future.run();
        }
    }

    public AsyncSocket.ReaderSet setReader(final ReadHandler<AsyncSocket> handler) {
        final ReaderSetEvent event = new ReaderSetEvent(handler);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Handler h = new Handler(){

                    public void handle(Object ignore) {
                        DefaultSocket.this.readAvailable();
                    }
                };
                DefaultSocket.this.readLock.lock();
                try {
                    DefaultSocket.this.reader = handler;
                    DefaultSocket.this.cancelRead = DefaultSocket.this.netHandler.socketStartReading(DefaultSocket.this, DefaultSocket.this.channel, h);
                    event.set(null);
                }
                catch (IOException e) {
                    event.setException(e);
                    DefaultSocket.this.readClose(e);
                }
                finally {
                    DefaultSocket.this.readLock.unlock();
                }
            }
        };
        this.netHandler.socketRegisterReadCommand(r);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAvailable() {
        boolean gotLock = this.readLock.tryLock();
        if (gotLock) {
            try {
                if (this.reader != null) {
                    try {
                        this.reader.handle((Object)this);
                    }
                    catch (IOException e) {
                        this.readClose(e);
                    }
                    catch (RuntimeException e) {
                        this.readClose(e);
                    }
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    private void tryAndWriteSocketEvents() {
        if (this.isConnected() && this.writeState.compareAndSet(0, 1)) {
            while (true) {
                this.currentWrite = this.writes.poll();
                if (this.currentWrite == null) {
                    this.writeState.set(0);
                    if (this.writes.size() != 0 && this.writeState.compareAndSet(0, 1)) continue;
                    return;
                }
                if (this.currentWrite.tryWrite() < 1L) break;
            }
            this.netHandler.socketRegisterWriteCommand(this.currentWrite);
            return;
        }
    }

    private void closed(Throwable cause, IOException closeFailure) {
        Handler<AsyncSocket> handler;
        SocketMonitor m = this.monitor;
        if (m != null) {
            try {
                m.closed((AsyncSocket)this, cause);
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        if ((handler = this.closeHandler) != null) {
            try {
                if (cause != null && handler instanceof ErroneousHandler) {
                    ((ErroneousHandler)handler).handle((Object)this, cause);
                } else {
                    handler.handle((Object)this);
                }
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        this.netHandler.socketClosed(this, cause);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrittenEvent
    extends BaseEvent<Long>
    implements AsyncSocket.Written,
    Handler {
        private final ByteBuffer[] srcs;
        private final int offset;
        private final int length;
        volatile long bytesWritten;

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public ByteBuffer[] getSrcs() {
            return this.srcs;
        }

        public void handle(Object o) {
            long bytesWritten;
            while (true) {
                if (DefaultSocket.this.currentWrite == null) {
                    DefaultSocket.this.currentWrite = (WrittenEvent)DefaultSocket.this.writes.poll();
                }
                if (DefaultSocket.this.currentWrite == null) {
                    DefaultSocket.this.writeState.compareAndSet(2, 0);
                    if (DefaultSocket.this.writes.size() != 0 && DefaultSocket.this.writeState.compareAndSet(0, 2)) continue;
                    this.deregisterSelector();
                    return;
                }
                bytesWritten = DefaultSocket.this.currentWrite.tryWrite();
                if (bytesWritten <= 0L) break;
                DefaultSocket.this.currentWrite = null;
            }
            if (bytesWritten == 0L) {
                return;
            }
        }

        private void deregisterSelector() {
            try {
                if (DefaultSocket.this.cancelWrite != null) {
                    DefaultSocket.this.cancelWrite.call();
                }
            }
            catch (Exception e) {
                DefaultSocket.this.writeClose(e);
            }
        }

        private void registerSelector() {
            try {
                DefaultSocket.this.cancelWrite = DefaultSocket.this.netHandler.socketStartWriting(DefaultSocket.this, DefaultSocket.this.channel, this);
            }
            catch (IOException ioe) {
                DefaultSocket.this.writeClose(ioe);
            }
        }

        @Override
        public void run() {
            if (DefaultSocket.this.writeState.compareAndSet(1, 2)) {
                while (true) {
                    if (DefaultSocket.this.currentWrite == null) {
                        DefaultSocket.this.currentWrite = (WrittenEvent)DefaultSocket.this.writes.poll();
                    }
                    if (DefaultSocket.this.currentWrite == null) {
                        DefaultSocket.this.writeState.compareAndSet(2, 0);
                        if (DefaultSocket.this.writes.size() != 0 && DefaultSocket.this.writeState.compareAndSet(0, 2)) continue;
                        return;
                    }
                    long trywrite = DefaultSocket.this.currentWrite.tryWrite();
                    if (trywrite < 1L) {
                        this.registerSelector();
                        return;
                    }
                    DefaultSocket.this.currentWrite = null;
                }
            }
        }

        long tryWrite() {
            long bytes;
            SocketMonitor m = DefaultSocket.this.monitor;
            if (m != null) {
                DefaultSocket.this.monitor.preWrite((AsyncSocket)DefaultSocket.this, this.getSrcs(), this.getOffset(), this.getLength());
            }
            try {
                bytes = this.getSrcs().length == 1 ? (long)DefaultSocket.this.channel.write(this.getSrcs()[0]) : DefaultSocket.this.channel.write(this.getSrcs(), this.getOffset(), this.getLength());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (m != null) {
                    DefaultSocket.this.monitor.postWrite((AsyncSocket)DefaultSocket.this, 0L, this.getSrcs(), this.getOffset(), this.getLength(), DefaultSocket.this.writeAttempts, (Throwable)e);
                }
                this.setException(e);
                DefaultSocket.this.writeAttempts = 0;
                return 1L;
            }
            if (m != null) {
                DefaultSocket.this.monitor.postWrite((AsyncSocket)DefaultSocket.this, bytes, this.getSrcs(), this.getOffset(), this.getLength(), DefaultSocket.this.writeAttempts, null);
            }
            if (bytes > 0L) {
                this.bytesWritten += bytes;
                DefaultSocket.this.bytesWritten.addAndGet(bytes);
                DefaultSocketGroup grp = DefaultSocket.this.group;
                if (DefaultSocket.this.group != null) {
                    DefaultSocket.this.group.addNumberOfBytesWritten(bytes);
                }
                DefaultSocket.this.netHandler.socketWritten(DefaultSocket.this, bytes);
            }
            if (!this.hasRemaining()) {
                DefaultSocket.this.writeAttempts++;
                return -bytes;
            }
            DefaultSocket.this.writeAttempts = 0;
            this.set(new Long(this.bytesWritten));
            return 1L;
        }

        boolean hasRemaining() {
            for (int i = 0; i < this.length; ++i) {
                if (!this.srcs[i + this.offset].hasRemaining()) continue;
                return false;
            }
            return true;
        }

        WrittenEvent(ByteBuffer[] srcs, int offset, int length) {
            this.srcs = srcs;
            this.offset = offset;
            this.length = length;
        }

        WrittenEvent(ByteBuffer src) {
            this(new ByteBuffer[]{src}, 0, 1);
        }
    }

    private class ConnectedEvent
    extends BaseEvent
    implements AsyncSocket.Connected {
        private final SocketAddress address;

        private ConnectedEvent(SocketAddress address) {
            this.address = address;
        }

        public SocketAddress getSocketAddress() {
            return this.address;
        }

        protected void setException(Throwable t) {
            super.setException(t);
            SocketMonitor m = DefaultSocket.this.monitor;
            if (m != null) {
                try {
                    m.connectFailed((AsyncSocket)DefaultSocket.this, this.address, t);
                }
                catch (RuntimeException e) {
                    DefaultSocket.this.connectClose(e);
                }
            }
        }

        protected void set(Object result) {
            DefaultSocket.this.netHandler.socketConnected(DefaultSocket.this);
            super.set(result);
            SocketMonitor m = DefaultSocket.this.monitor;
            if (m != null) {
                try {
                    m.connected((AsyncSocket)DefaultSocket.this, this.address);
                }
                catch (RuntimeException e) {
                    DefaultSocket.this.connectClose(e);
                }
            }
        }
    }

    private class ClosedEvent
    extends BaseEvent
    implements AsyncSocket.Closed {
        private final Throwable cause;

        private ClosedEvent(Throwable cause) {
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object call() throws Exception {
            try {
                DefaultSocket.this.innerSetGroup(CLOSED_GROUP);
                DefaultSocket.this.channel.close();
                DefaultSocket.this.closed(this.cause, null);
            }
            catch (IOException e) {
                DefaultSocket.this.closed(this.cause, e);
                throw e;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReaderSetEvent
    extends BaseEvent
    implements AsyncSocket.ReaderSet {
        private final ReadHandler<AsyncSocket> reader;

        private ReaderSetEvent(ReadHandler<AsyncSocket> reader) {
            this.reader = reader;
        }

        public ReadHandler<AsyncSocket> getReader() {
            return this.reader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncSocket.Event>
    implements AsyncSocket.Event,
    AioFuture<V, AsyncSocket.Event> {
        private BaseEvent() {
            super(DefaultSocket.this.defaultExecutor, DefaultSocket.this.defaultDestination);
        }

        public AsyncSocket async() {
            return DefaultSocket.this;
        }

        @Override
        public int getColor() {
            return DefaultSocket.this.getColor();
        }

        public void setDestination(Offerable<? super AsyncSocket.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncSocket.Event> dest, final Throwable t) {
            AsyncSocket.ErroneousEvent error = new AsyncSocket.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public int getColor() {
                    return DefaultSocket.this.getColor();
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public AsyncSocket.Event getEvent() {
                    return BaseEvent.this;
                }

                public AsyncSocket async() {
                    return DefaultSocket.this;
                }
            };
            dest.offer((Object)error);
        }
    }

    private class ReaderSource
    implements ScatteringByteChannel {
        private ReaderSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(ByteBuffer[] srcs, int offset, int length) {
            DefaultSocket.this.readLock.lock();
            try {
                SocketMonitor m = DefaultSocket.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncSocket)DefaultSocket.this, srcs, offset, length);
                    }
                    catch (RuntimeException e) {
                        DefaultSocket.this.readClose(e);
                    }
                }
                long read = DefaultSocket.this.channel.read(srcs, offset, length);
                if (m != null) {
                    try {
                        m.postRead((AsyncSocket)DefaultSocket.this, read, srcs, offset, length, null);
                    }
                    catch (RuntimeException e) {
                        DefaultSocket.this.readClose(e);
                    }
                }
                if (read > 0L) {
                    DefaultSocket.this.bytesRead.addAndGet(read);
                    DefaultSocketGroup grp = DefaultSocket.this.group;
                    if (DefaultSocket.this.group != null) {
                        DefaultSocket.this.group.addNumberOfBytesRead(read);
                    }
                    DefaultSocket.this.netHandler.socketRead(DefaultSocket.this, read);
                }
                if (read == -1L) {
                    if (DefaultSocket.this.cancelRead != null) {
                        DefaultSocket.this.cancelRead.call();
                    }
                    DefaultSocket.this.readClose(new IOException("read returned -1"));
                }
                long l = read;
                return l;
            }
            catch (Exception e) {
                DefaultSocket.this.readClose(e);
                long l = -1L;
                return l;
            }
            finally {
                DefaultSocket.this.readLock.unlock();
            }
        }

        public long read(ByteBuffer[] srcs) {
            return this.read(srcs, 0, srcs.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer src) {
            DefaultSocket.this.readLock.lock();
            try {
                SocketMonitor m = DefaultSocket.this.monitor;
                if (m != null) {
                    try {
                        m.preRead((AsyncSocket)DefaultSocket.this, new ByteBuffer[]{src}, 0, 1);
                    }
                    catch (RuntimeException e) {
                        DefaultSocket.this.readClose(e);
                    }
                }
                int read = DefaultSocket.this.channel.read(src);
                if (m != null) {
                    try {
                        m.postRead((AsyncSocket)DefaultSocket.this, (long)read, new ByteBuffer[]{src}, 0, 1, null);
                    }
                    catch (RuntimeException e) {
                        DefaultSocket.this.readClose(e);
                    }
                }
                if (read > 0) {
                    DefaultSocket.this.bytesRead.addAndGet(read);
                    DefaultSocket.this.netHandler.socketRead(DefaultSocket.this, read);
                    DefaultSocketGroup grp = DefaultSocket.this.group;
                    if (DefaultSocket.this.group != null) {
                        DefaultSocket.this.group.addNumberOfBytesRead(read);
                    }
                }
                if (read == -1) {
                    if (DefaultSocket.this.cancelRead != null) {
                        DefaultSocket.this.cancelRead.call();
                    }
                    DefaultSocket.this.readClose(new IOException("read returned -1"));
                }
                int n = read;
                return n;
            }
            catch (Exception e) {
                DefaultSocket.this.readClose(e);
                int n = -1;
                return n;
            }
            finally {
                DefaultSocket.this.readLock.unlock();
            }
        }

        public boolean isOpen() {
            return DefaultSocket.this.isOpen();
        }

        public void close() throws IOException {
            DefaultSocket.this.close();
        }
    }
}

