/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AsyncDatagram;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.AsyncServerSocket;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.defaults.AsyncSelector;
import coconut.aio.defaults.DefaultDatagram;
import coconut.aio.defaults.DefaultDatagramGroup;
import coconut.aio.defaults.DefaultNetManagement;
import coconut.aio.defaults.DefaultServerSocket;
import coconut.aio.defaults.DefaultSocket;
import coconut.aio.defaults.DefaultSocketGroup;
import coconut.aio.defaults.NetHandler;
import coconut.aio.management.DatagramMBean;
import coconut.aio.management.ServerSocketMBean;
import coconut.aio.management.SocketMBean;
import coconut.aio.monitor.DatagramGroupMonitor;
import coconut.aio.monitor.DatagramMonitor;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.aio.monitor.SocketGroupMonitor;
import coconut.aio.monitor.SocketMonitor;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultNetHandler
extends NetHandler {
    private AsyncSelector acceptHandler;
    private AsyncSelector writeConnectHandler;
    private AsyncSelector readHandler;
    private final AtomicLong ids;
    private final DefaultNetManagement management = new DefaultNetManagement();
    volatile ServerSocketMonitor defaultServerSocketMonitor;
    volatile SocketGroupMonitor defaultSocketGroupMonitor;
    volatile SocketMonitor defaultSocketMonitor;
    volatile DatagramGroupMonitor defaultDatagramGroupMonitor;
    volatile DatagramMonitor defaultDatagramMonitor;

    DefaultNetHandler(AtomicLong l) {
        this.ids = l;
    }

    ServerSocketMBean getServerSocketMXBean() {
        return this.management.getServerSocketMXBean();
    }

    SocketMBean getSocketMXBean() {
        return this.management.getSocketMXBean();
    }

    DatagramMBean getDatagramMXBean() {
        return this.management.getDatagramMXBean();
    }

    @Override
    DefaultSocket serverSocketSocketAccepted(DefaultServerSocket impl, SocketChannel newChannel, DefaultSocketGroup group) {
        this.management.incrementAccepts();
        SocketMonitor m = this.defaultSocketMonitor;
        DefaultSocket s = new DefaultSocket(this, this.getNextId(), newChannel, m, null, null);
        this.management.opened(s);
        s.setGroup(group);
        if (m != null) {
            try {
                m.opened((AsyncSocket)s);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return s;
    }

    DefaultSocket openAsyncSocket(Offerable<? super AsyncSocket.Event> queue, Executor executor) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        SocketMonitor m = this.defaultSocketMonitor;
        DefaultSocket s = new DefaultSocket(this, this.getNextId(), channel, m, queue, executor);
        this.management.opened(s);
        if (m != null) {
            m.opened((AsyncSocket)s);
        }
        return s;
    }

    DefaultDatagram openAsyncDatagram(Offerable<? super AsyncDatagram.Event> queue, Executor executor) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        DatagramMonitor m = this.defaultDatagramMonitor;
        DefaultDatagram s = new DefaultDatagram(this, this.getNextId(), channel, m, queue, executor);
        this.management.opened(s);
        if (m != null) {
            m.opened((AsyncDatagram)s);
        }
        return s;
    }

    @Override
    void socketConnected(DefaultSocket socket) {
        this.management.incrementSocketConnections();
    }

    AsyncDatagramGroup openDatagramGroup() {
        DatagramGroupMonitor m = this.defaultDatagramGroupMonitor;
        DefaultDatagramGroup group = new DefaultDatagramGroup(this, this.getNextId(), m);
        this.management.opened(group);
        if (m != null) {
            m.opened((AsyncDatagramGroup)group);
        }
        return group;
    }

    AsyncSocketGroup openSocketGroup() {
        SocketGroupMonitor m = this.defaultSocketGroupMonitor;
        DefaultSocketGroup group = new DefaultSocketGroup(this, this.getNextId(), m);
        this.management.opened(group);
        if (m != null) {
            m.opened((AsyncSocketGroup)group);
        }
        return group;
    }

    @Override
    void groupClosed(DefaultSocketGroup group) {
        this.management.closed(group);
    }

    @Override
    void groupClosed(DefaultDatagramGroup group) {
        this.management.closed(group);
    }

    AsyncServerSocket openAsyncServerSocket(Offerable<? super AsyncServerSocket.Event> queue, Executor executor) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        DefaultServerSocket s = new DefaultServerSocket(this, this.getNextId(), channel, this.defaultServerSocketMonitor, queue, executor);
        ServerSocketMonitor m = this.defaultServerSocketMonitor;
        if (m != null) {
            m.opened((AsyncServerSocket)s);
        }
        this.management.opened(s);
        return s;
    }

    @Override
    void serverSocketClosed(DefaultServerSocket socket, Throwable cause) {
        this.management.closed(socket);
    }

    void shutdown() {
        this.acceptHandler.shutdown();
        this.writeConnectHandler.shutdown();
        this.readHandler.shutdown();
    }

    void start() throws IOException {
        int selecttimeout = 1000;
        this.acceptHandler = new AsyncSelector(new ThreadSupplier("AIO-Accept"), this, selecttimeout);
        this.acceptHandler.start();
        this.writeConnectHandler = new AsyncSelector(new ThreadSupplier("AIO-WriteConnect"), this, selecttimeout);
        this.writeConnectHandler.start();
        this.readHandler = new AsyncSelector(new ThreadSupplier("AIO-Read"), this, selecttimeout);
        this.readHandler.start();
    }

    private long getNextId() {
        return this.ids.incrementAndGet();
    }

    @Override
    void serverSocketRegisterCommand(Runnable runnable) {
        this.acceptHandler.addFuture(runnable);
    }

    @Override
    void socketRegisterConnectCommand(Runnable runnable) {
        this.writeConnectHandler.addFuture(runnable);
    }

    @Override
    void socketRegisterWriteCommand(Runnable runnable) {
        this.writeConnectHandler.addFuture(runnable);
    }

    @Override
    void socketRead(DefaultSocket s, long bytes) {
        this.management.addBytesRead(bytes);
    }

    @Override
    void socketWritten(DefaultSocket s, long bytes) {
        this.management.addBytesWritten(bytes);
    }

    @Override
    void datagramRead(DefaultDatagram s, long bytes) {
        this.management.addBytesReadDatagram(bytes);
    }

    @Override
    void datagramWritten(DefaultDatagram s, long bytes) {
        this.management.addBytesWrittenDatagram(bytes);
    }

    @Override
    void socketClosed(DefaultSocket socket, Throwable cause) {
        this.management.closed(socket);
    }

    @Override
    void datagramClosed(DefaultDatagram socket, Throwable cause) {
        this.management.closed(socket);
    }

    @Override
    void socketRegisterReadCommand(Runnable runnable) {
        this.readHandler.addFuture(runnable);
    }

    @Override
    void datagramRegisterWriteCommand(Runnable runnable) {
        this.writeConnectHandler.addFuture(runnable);
    }

    @Override
    void datagramRegisterReadCommand(Runnable runnable) {
        this.readHandler.addFuture(runnable);
    }

    @Override
    Callable serverSocketStartAccepting(DefaultServerSocket socket, ServerSocketChannel channel, Handler handler) throws IOException {
        return this.acceptHandler.registerChannel(channel, 16, handler);
    }

    @Override
    Callable socketStartReading(DefaultSocket socket, SocketChannel channel, Handler handler) throws IOException {
        return this.readHandler.registerChannel(channel, 1, handler);
    }

    @Override
    Callable datagramStartReading(DefaultDatagram socket, DatagramChannel channel, Handler handler) throws IOException {
        return this.readHandler.registerChannel(channel, 1, handler);
    }

    @Override
    void socketStartConnecting(DefaultSocket socket, SocketChannel channel, Handler handler) throws IOException {
        this.writeConnectHandler.registerChannel(channel, 8, handler);
    }

    @Override
    Callable socketStartWriting(DefaultSocket socket, SocketChannel channel, Handler handler) throws IOException {
        return this.writeConnectHandler.registerChannel(channel, 4, handler);
    }

    @Override
    Callable datagramStartWriting(DefaultDatagram socket, DatagramChannel channel, Handler handler) throws IOException {
        return this.writeConnectHandler.registerChannel(channel, 4, handler);
    }

    @Override
    void groupJoined(DefaultSocketGroup group, DefaultSocket socket) {
        this.management.joined(group, socket);
    }

    @Override
    void groupJoined(DefaultDatagramGroup group, DefaultDatagram socket) {
        this.management.joined(group, socket);
    }

    static class ThreadSupplier
    implements ThreadFactory {
        final ThreadGroup group;
        final String threadName;

        ThreadSupplier(String threadName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.threadName = threadName;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.threadName, 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

