/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AsyncFile;
import coconut.aio.defaults.DefaultFile;
import coconut.aio.management.FileInfo;
import coconut.aio.management.FileMBean;
import coconut.aio.monitor.FileMonitor;
import coconut.core.Offerable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileHandler {
    private Executor e = Executors.newFixedThreadPool(1);
    private final Offerable requests;
    private final AtomicLong ids;
    volatile FileMonitor defaultFileMonitor;
    private final ConcurrentHashMap<Long, DefaultFile> files = new ConcurrentHashMap();
    private final AtomicLong totalFiles = new AtomicLong();
    private final AtomicLong bytesWrittenToFiles = new AtomicLong();
    private final AtomicLong bytesReadFromFiles = new AtomicLong();
    private final AtomicInteger peakFileCount = new AtomicInteger();
    private final FileMBean fileBean = new DefaultMXFileBean();

    DefaultFileHandler(AtomicLong l) {
        this.ids = l;
        this.requests = new Offerable(){

            public boolean offer(Object r) {
                DefaultFileHandler.this.e.execute((Runnable)r);
                return true;
            }
        };
    }

    public void start() {
    }

    FileMBean getFileMXBean() {
        return this.fileBean;
    }

    public AsyncFile openFile(Offerable<? super AsyncFile.Event> queue, Executor executor) {
        FileMonitor m = this.defaultFileMonitor;
        DefaultFile f = new DefaultFile(this, (Offerable<? super AsyncFile.Event>)this.requests, this.getNextId(), this.defaultFileMonitor, queue, executor);
        if (m != null) {
            m.opened((AsyncFile)f);
        }
        return f;
    }

    private long getNextId() {
        return this.ids.incrementAndGet();
    }

    public void shutdown() {
    }

    private static class DefaultMXFileBean
    implements FileMBean {
        private DefaultMXFileBean() {
        }

        public long[] getAllIds() {
            throw new UnsupportedOperationException();
        }

        public long getTotalBytesWritten() {
            throw new UnsupportedOperationException();
        }

        public long getTotalBytesRead() {
            throw new UnsupportedOperationException();
        }

        public FileInfo getFileInfo(long id) {
            throw new UnsupportedOperationException();
        }

        public FileInfo[] getFileInfo(long[] ids) {
            throw new UnsupportedOperationException();
        }

        public long getBytesWritten(long id) {
            throw new UnsupportedOperationException();
        }

        public long getBytesRead(long id) {
            throw new UnsupportedOperationException();
        }

        public long getTotalFileCount() {
            throw new UnsupportedOperationException();
        }

        public int getPeakFileCount() {
            throw new UnsupportedOperationException();
        }

        public int getFileCount() {
            throw new UnsupportedOperationException();
        }

        public void resetPeakFileCount() {
            throw new UnsupportedOperationException();
        }
    }
}

