/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.AioFuture;
import coconut.aio.AsyncFile;
import coconut.aio.defaults.AioFutureTask;
import coconut.aio.defaults.DefaultFileHandler;
import coconut.aio.monitor.FileMonitor;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFile
extends AsyncFile {
    private final long id;
    private final Offerable requests;
    private final DefaultFileHandler netHandler;
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicReference<AsyncFile.Closed> closeFuture = new AtomicReference();
    volatile Executor defaultExecutor;
    volatile Offerable<? super AsyncFile.Event> defaultDestination;
    private volatile Object attachment;
    private volatile Handler<AsyncFile> closeHandler;
    private volatile FileMonitor monitor;
    private volatile RandomAccessFile raf;
    private volatile File f;
    private static final int MODE_READONLY = 1;
    private static final int MODE_READWRITE = 2;
    private static final int MODE_SYNC = 4;
    private static final int MODE_SYNCMETADATA = 8;
    private volatile int mode;
    private volatile boolean isOpen;

    DefaultFile(DefaultFileHandler handler, Offerable<? super AsyncFile.Event> requests, long id, FileMonitor monitor, Offerable<? super AsyncFile.Event> destination, Executor executor) {
        this.requests = requests;
        this.netHandler = handler;
        this.id = id;
        this.defaultExecutor = executor;
        this.defaultDestination = destination;
        this.monitor = monitor;
    }

    public long getId() {
        return this.id;
    }

    public int getColor() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Offerable<? super AsyncFile.Event> getDefaultDestination() {
        return this.defaultDestination;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public AsyncFile.Opened openFile(String file, String mode) {
        return this.openFile(file, mode, false);
    }

    public AsyncFile.Opened openFile(File file, String mode) {
        return this.openFile(file, mode, false);
    }

    public AsyncFile.Opened openFile(File file, String mode, boolean create) {
        OpenedEvent o = new OpenedEvent(file, create, this.getMode(mode));
        this.requests.offer((Object)o);
        return o;
    }

    public AsyncFile.Opened openFile(String file, String mode, boolean create) {
        OpenedEvent o = new OpenedEvent(file, create, this.getMode(mode));
        this.requests.offer((Object)o);
        return o;
    }

    private int getMode(String mode) {
        if (mode.equals("r")) {
            return 1;
        }
        if (mode.equals("rw")) {
            return 2;
        }
        if (mode.equals("rws")) {
            return 4;
        }
        if (mode.equals("rwd")) {
            return 8;
        }
        throw new IllegalArgumentException("Unknown mode " + mode);
    }

    public AsyncFile setMonitor(FileMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public FileMonitor getMonitor() {
        return this.monitor;
    }

    public Object attach(Object attachment) {
        Object o = this.attachment;
        this.attachment = attachment;
        return o;
    }

    public Object attachment() {
        return this.attachment;
    }

    public boolean isWritable() {
        return this.mode > 1;
    }

    private void closed(IOException e) {
        if (e != null) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.f;
    }

    public AsyncFile.Closed close() {
        ClosedEvent e = new ClosedEvent(null);
        this.requests.offer((Object)e);
        return e;
    }

    private void closed(Throwable cause2, IOException e) {
        throw new UnsupportedOperationException();
    }

    private class ClosedEvent
    extends BaseEvent
    implements AsyncFile.Closed {
        private final Throwable cause;

        private ClosedEvent(Throwable cause) {
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object call() throws Exception {
            DefaultFile.this.isOpen = false;
            try {
                if (DefaultFile.this.raf != null) {
                    DefaultFile.this.raf.close();
                }
            }
            catch (IOException e) {
                DefaultFile.this.closed(this.cause, e);
                throw e;
            }
            return null;
        }
    }

    private class OpenedEvent
    extends BaseEvent
    implements AsyncFile.Opened {
        private String name;
        private final int mode;
        private volatile int created;

        private OpenedEvent(String file, boolean create, int mode) {
            this.name = file;
            this.mode = mode;
            if (create) {
                this.created = 1;
            }
        }

        private OpenedEvent(File file, boolean create, int mode) {
            this.mode = mode;
            DefaultFile.this.f = file;
            if (create) {
                this.created = 1;
            }
        }

        public File getFile() {
            return DefaultFile.this.f;
        }

        public boolean isNew() {
            return this.created == 2;
        }

        public String getMode() {
            if (this.mode == 1) {
                return "r";
            }
            if (this.mode == 2) {
                return "rw";
            }
            if (this.mode == 4) {
                return "rws";
            }
            return "rwd";
        }

        public Object call() throws IOException {
            try {
                if (this.name != null) {
                    DefaultFile.this.f = new File(this.name);
                }
                if (this.created > 0 && DefaultFile.this.f.createNewFile()) {
                    this.created = 2;
                }
                DefaultFile.this.raf = new RandomAccessFile(DefaultFile.this.f, this.getMode());
                DefaultFile.this.mode = this.mode;
                DefaultFile.this.isOpen = true;
            }
            catch (IOException e) {
                DefaultFile.this.closed(e);
                throw e;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseEvent<V>
    extends AioFutureTask<V, AsyncFile.Event>
    implements AsyncFile.Event,
    AioFuture<V, AsyncFile.Event> {
        private BaseEvent() {
            super(DefaultFile.this.defaultExecutor, DefaultFile.this.defaultDestination);
        }

        public AsyncFile async() {
            return DefaultFile.this;
        }

        @Override
        public int getColor() {
            return DefaultFile.this.getColor();
        }

        public void setDestination(Offerable<? super AsyncFile.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncFile.Event> dest, final Throwable t) {
            AsyncFile.ErroneousEvent error = new AsyncFile.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public int getColor() {
                    return DefaultFile.this.getColor();
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public AsyncFile.Event getEvent() {
                    return BaseEvent.this;
                }

                public AsyncFile async() {
                    return DefaultFile.this;
                }
            };
            dest.offer((Object)error);
        }
    }
}

