/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.defaults;

import coconut.aio.defaults.DefaultNetHandler;
import coconut.aio.defaults.SelectorMonitor;
import coconut.core.Handler;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class AsyncSelector
implements Runnable {
    private final AtomicInteger state;
    private Thread thread;
    private final Queue<Runnable> eventQueue = new ConcurrentLinkedQueue<Runnable>();
    private final SelectorMonitor monitor;
    private int selectTimeOut;
    private final Selector selector = Selector.open();
    private final ThreadFactory factory;

    AsyncSelector(ThreadFactory fac, DefaultNetHandler netHandler, int selectTimeOut) throws IOException {
        this.thread = fac.newThread(this);
        this.thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                System.err.print("Unhandled exception " + t.getName());
                e.printStackTrace();
                AsyncSelector.this.thread = AsyncSelector.this.factory.newThread(AsyncSelector.this);
                AsyncSelector.this.state.set(-1);
                AsyncSelector.this.start();
            }
        });
        this.selectTimeOut = selectTimeOut;
        this.factory = fac;
        this.state = new AtomicInteger(-1);
        this.monitor = new SelectorMonitor();
        this.monitor.opened(null);
    }

    long getThreadId() {
        return this.thread.getId();
    }

    void start() {
        if (!this.state.compareAndSet(-1, 0)) {
            throw new IllegalStateException("state was " + this.state.get() + "expected -1");
        }
        this.thread.start();
    }

    public void run() {
        if (!this.state.compareAndSet(0, 1)) {
            throw new IllegalStateException("state was " + this.state.get());
        }
        while (this.state.get() == 1) {
            Runnable event = this.eventQueue.poll();
            while (event != null) {
                event.run();
                event = this.eventQueue.poll();
            }
            int selectSize = 0;
            try {
                this.monitor.preSelect(this.selectTimeOut);
                selectSize = this.selectTimeOut == 0 ? this.selector.selectNow() : (this.selectTimeOut == -1 ? this.selector.select() : this.selector.select(this.selectTimeOut));
                this.monitor.postSelect(selectSize, null);
            }
            catch (IOException e) {
                this.monitor.postSelect(0, e);
            }
            if (selectSize == 0) continue;
            Set<SelectionKey> keys = this.selector.selectedKeys();
            Iterator<SelectionKey> iter = keys.iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                iter.remove();
                try {
                    ((Handler)key.attachment()).handle((Object)key);
                }
                catch (Exception e1) {}
            }
        }
        try {
            this.selector.close();
            this.monitor.closed(null);
        }
        catch (IOException e) {
            this.monitor.closed(e);
        }
        if (!this.state.compareAndSet(2, 3)) {
            throw new IllegalStateException("state was " + this.state.get());
        }
    }

    void shutdown() {
        if (!this.state.compareAndSet(1, 2)) {
            throw new IllegalStateException("Not running, or allready finished");
        }
        this.selector.wakeup();
        this.monitor.wakeup();
    }

    Callable registerChannel(SelectableChannel channel, int ops, Handler handler) throws IOException {
        SelectionKey k = null;
        try {
            k = channel.register(this.selector, ops, handler);
        }
        catch (CancelledKeyException cke) {
            this.selector.selectNow();
            k = channel.register(this.selector, ops, handler);
        }
        final SelectionKey key = k;
        return new Callable(){

            public Object call() throws IOException {
                key.cancel();
                return null;
            }
        };
    }

    void addFuture(Runnable runnable) {
        this.eventQueue.add(runnable);
        this.selector.wakeup();
        this.monitor.wakeup();
    }
}

