/*
 * Decompiled with CFR 0.152.
 */
package cloud.unionj.generator.frontend.vue;

import cloud.unionj.generator.GeneratorUtils;
import cloud.unionj.generator.frontend.vue.PackageJsonGenerator;
import cloud.unionj.generator.frontend.vue.ReadmeMdGenerator;
import cloud.unionj.generator.frontend.vue.VueGenerator;
import cloud.unionj.generator.mock.MockFolderGenerator;
import cloud.unionj.generator.mock.docparser.MockDocParser;
import cloud.unionj.generator.mock.docparser.entity.Api;
import cloud.unionj.generator.openapi3.model.Openapi3;
import cloud.unionj.generator.service.ServiceFolderGenerator;
import cloud.unionj.generator.service.docparser.ServiceDocParser;
import cloud.unionj.generator.service.docparser.entity.BizServer;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class VueProjectGenerator
extends VueGenerator {
    private String doc;
    private Openapi3 openAPI;
    private String projectName;
    private String outputDir;
    private boolean scaffold;
    private boolean includeMock;

    public Map<String, Object> getInput() {
        return null;
    }

    public String getTemplate() {
        return null;
    }

    public String getOutputFile() {
        return GeneratorUtils.getOutputDir((String)this.outputDir);
    }

    public String generate() {
        if (StringUtils.isBlank((CharSequence)this.doc) && this.openAPI == null) {
            return null;
        }
        if (this.scaffold) {
            File folderZip = new File(this.getOutputFile() + ".zip");
            FileUtils.copyInputStreamToFile((InputStream)ClassLoader.getSystemResourceAsStream("vue.zip"), (File)folderZip);
            GeneratorUtils.unzip((String)folderZip.getAbsolutePath(), (File)new File(GeneratorUtils.getOutputDir((String)"")));
            folderZip.delete();
        }
        ReadmeMdGenerator readmeMdGenerator = new ReadmeMdGenerator(this.projectName);
        readmeMdGenerator.generate();
        PackageJsonGenerator packageJsonGenerator = new PackageJsonGenerator(this.projectName);
        packageJsonGenerator.generate();
        if (this.includeMock) {
            Api api = StringUtils.isNotBlank((CharSequence)this.doc) ? (this.doc.startsWith("http") ? MockDocParser.parse((URL)new URL(this.doc)) : MockDocParser.parse((File)new File(this.doc))) : MockDocParser.parse((Openapi3)this.openAPI);
            if (api != null) {
                MockFolderGenerator mockFolderGenerator = new MockFolderGenerator.Builder(api).outputDir(this.getOutputFile() + "/src/mocks").zip(false).build();
                mockFolderGenerator.generate();
            }
        }
        BizServer bizServer = StringUtils.isNotBlank((CharSequence)this.doc) ? (this.doc.startsWith("http") ? ServiceDocParser.parse((URL)new URL(this.doc)) : ServiceDocParser.parse((File)new File(this.doc))) : ServiceDocParser.parse((Openapi3)this.openAPI);
        if (bizServer != null) {
            ServiceFolderGenerator serviceFolderGenerator = new ServiceFolderGenerator.Builder(bizServer).outputDir(this.getOutputFile() + "/src/services").zip(false).build();
            serviceFolderGenerator.generate();
        }
        String outputFile = GeneratorUtils.getOutputDir((String)"output") + File.separator + this.projectName + "_vue.zip";
        String sourceFile = this.getOutputFile();
        return GeneratorUtils.generateFolder((String)sourceFile, (String)outputFile);
    }

    public static final class Builder {
        private String doc;
        private Openapi3 openAPI;
        private String projectName;
        private String outputDir = "vue";
        private boolean scaffold;
        private boolean includeMock;

        public Builder(String projectName) {
            this.projectName = projectName;
        }

        public Builder outputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public Builder doc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder openAPI(Openapi3 openAPI) {
            this.openAPI = openAPI;
            return this;
        }

        public Builder scaffold(boolean scaffold) {
            this.scaffold = scaffold;
            return this;
        }

        public Builder includeMock(boolean includeMock) {
            this.includeMock = includeMock;
            return this;
        }

        public VueProjectGenerator build() {
            VueProjectGenerator vueProjectGenerator = new VueProjectGenerator();
            vueProjectGenerator.projectName = this.projectName;
            vueProjectGenerator.outputDir = this.outputDir;
            vueProjectGenerator.doc = this.doc;
            vueProjectGenerator.openAPI = this.openAPI;
            vueProjectGenerator.scaffold = this.scaffold;
            vueProjectGenerator.includeMock = this.includeMock;
            return vueProjectGenerator;
        }
    }
}

