/*
 * Decompiled with CFR 0.152.
 */
package cloud.unionj.generator.apidoc;

import cloud.unionj.generator.GeneratorUtils;
import cloud.unionj.generator.apidoc.ApiDocGenerator;
import cloud.unionj.generator.apidoc.IndexHtmlMdGenerator;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ApiDocFolderGenerator
extends ApiDocGenerator {
    private String doc;
    private String outputDir;
    private boolean zip;

    public Map<String, Object> getInput() {
        return null;
    }

    public String getTemplate() {
        return null;
    }

    public String getOutputFile() {
        return GeneratorUtils.getOutputDir((String)this.outputDir);
    }

    public String generate() {
        File folderZip = new File(this.getOutputFile() + ".zip");
        FileUtils.copyInputStreamToFile((InputStream)ClassLoader.getSystemResourceAsStream("apidoc.zip"), (File)folderZip);
        GeneratorUtils.unzip((String)folderZip.getAbsolutePath(), (File)new File(GeneratorUtils.getOutputDir((String)"")));
        folderZip.delete();
        IndexHtmlMdGenerator indexHtmlMdGenerator = new IndexHtmlMdGenerator(this.doc, this.outputDir);
        indexHtmlMdGenerator.generate();
        if (this.zip) {
            String outputFile = GeneratorUtils.getOutputDir((String)"output") + File.separator + "apidoc" + ".zip";
            String sourceFile = this.getOutputFile();
            return GeneratorUtils.generateFolder((String)sourceFile, (String)outputFile);
        }
        return this.getOutputFile();
    }

    public static final class Builder {
        private String doc;
        private String outputDir = "apidoc";
        private boolean zip = false;

        public Builder(String doc) {
            this.doc = doc;
        }

        public Builder outputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public Builder zip(boolean zip) {
            this.zip = zip;
            return this;
        }

        public ApiDocFolderGenerator build() {
            ApiDocFolderGenerator apiDocFolderGenerator = new ApiDocFolderGenerator();
            apiDocFolderGenerator.doc = this.doc;
            apiDocFolderGenerator.outputDir = this.outputDir;
            apiDocFolderGenerator.zip = this.zip;
            return apiDocFolderGenerator;
        }
    }
}

