/*
 * Decompiled with CFR 0.152.
 */
package cloud.quasarch.akash.impl.parsing;

import cloud.quasarch.akash.impl.model.OperationFailure;
import cloud.quasarch.akash.impl.model.remote.AkashErrorType;
import cloud.quasarch.akash.impl.model.remote.ErrorResponse;
import cloud.quasarch.akash.impl.parsing.ResponseParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.control.Either;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseParserWithTransformation<I, R>
implements ResponseParser<R> {
    private static final Logger log = LoggerFactory.getLogger(ResponseParserWithTransformation.class);
    private final Class<I> jsonModelClass;
    private final Function<I, R> transformation;
    private static final List<Integer> AUTH_ERROR_CODES = List.of(Integer.valueOf(4), Integer.valueOf(23));
    private static final List<Integer> BAD_REQUEST_CODES = List.of(3, 6, 7, 8, 9, 10, 12, 15, 16, 17, 18, 19, 21, 22, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38);
    private static final List<Integer> STATE_ERROR_CODES = List.of(Integer.valueOf(5), Integer.valueOf(11), Integer.valueOf(13), Integer.valueOf(25));

    public ResponseParserWithTransformation(Class<I> jsonModelClass, Function<I, R> transformation) {
        this.jsonModelClass = jsonModelClass;
        this.transformation = transformation;
    }

    @Override
    public Either<OperationFailure, R> parseToEither(HttpResponse<String> response) {
        String body = response.body();
        if (response.statusCode() / 100 != 2) {
            return this.parseErrorMessage(response.statusCode(), body);
        }
        try {
            log.trace("received response string: {}", (Object)body);
            Object deploymentResponse = ObjectMapperFactory.getInstance().readValue(body, this.jsonModelClass);
            return Either.right(this.transformation.apply(deploymentResponse));
        }
        catch (JsonProcessingException jsonEx) {
            return Either.left((Object)new OperationFailure(AkashErrorType.ClientError, jsonEx.getMessage()));
        }
    }

    @Override
    public Either<OperationFailure, R> parseErrorMessage(int statusCode, String body) {
        try {
            log.trace("received response error: {}", (Object)body);
            ErrorResponse error = (ErrorResponse)ObjectMapperFactory.getInstance().readValue(body, ErrorResponse.class);
            AkashErrorType errorType = AkashErrorType.AkashNetworkError;
            if (BAD_REQUEST_CODES.contains(error.code())) {
                errorType = AkashErrorType.BadRequest;
            } else if (AUTH_ERROR_CODES.contains(error.code())) {
                errorType = AkashErrorType.AuthError;
            } else if (STATE_ERROR_CODES.contains(error.code())) {
                errorType = AkashErrorType.StateError;
            }
            return Either.left((Object)new OperationFailure(errorType, error.message()));
        }
        catch (JsonProcessingException jsonEx) {
            return Either.left((Object)new OperationFailure(AkashErrorType.ClientError, jsonEx.getMessage()));
        }
    }

    private static class ObjectMapperFactory {
        private static ObjectMapper obj = new ObjectMapper();

        private ObjectMapperFactory() {
        }

        public static ObjectMapper getInstance() {
            return obj;
        }
    }
}

