/*
 * Decompiled with CFR 0.152.
 */
package cloud.quasarch.akash.impl.parsing;

import cloud.quasarch.akash.impl.parsing.ResponseParser;
import cloud.quasarch.akash.impl.parsing.ResponseParserWithTransformation;
import java.util.Objects;
import java.util.function.Function;

public class ResponseParserBuilder<R, I> {
    private Class<I> resultClass;
    private Function<I, R> transformation;

    private ResponseParserBuilder() {
    }

    public ResponseParserBuilder<R, I> withResultClass(Class<I> resultClass) {
        this.resultClass = resultClass;
        return this;
    }

    public ResponseParserBuilder<R, I> withIntermediateOperation(Function<I, R> transformation) {
        this.transformation = transformation;
        return this;
    }

    public ResponseParser<R> build() {
        if (this.resultClass == null) {
            throw new IllegalStateException("withResultClass must be called before build()");
        }
        return new ResponseParserWithTransformation(this.resultClass, Objects.requireNonNullElseGet(this.transformation, () -> inter -> inter));
    }

    public static <R, I> ResponseParserBuilder<R, I> newBuilder() {
        return new ResponseParserBuilder<R, I>();
    }
}

