/*
 * Decompiled with CFR 0.152.
 */
package cloud.quasarch.akash.impl.pagination;

import cloud.quasarch.akash.impl.model.PagedResponse;
import cloud.quasarch.akash.impl.model.remote.PageInfo;
import java.util.Iterator;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkashPagedIterator<T>
implements Iterator<T> {
    private static final Logger log = LoggerFactory.getLogger(AkashPagedIterator.class);
    private final Function<String, PagedResponse<T>> dataFetcher;
    private PageInfo currentPage;
    private Iterator<T> buffer;
    private int globalOffset = 0;

    public AkashPagedIterator(Function<String, PagedResponse<T>> dataFetcher, PagedResponse<T> firstPage) {
        this.dataFetcher = dataFetcher;
        this.currentPage = firstPage.paginationInfo();
        this.buffer = firstPage.results().iterator();
    }

    @Override
    public boolean hasNext() {
        log.debug("hasNext called");
        log.trace("globalOffset is {}", (Object)this.globalOffset);
        log.trace("currentPage.total is {}", (Object)this.currentPage.total());
        return this.globalOffset != this.currentPage.total();
    }

    @Override
    public T next() {
        log.debug("next called");
        log.trace("globalOffset is {}", (Object)this.globalOffset);
        ++this.globalOffset;
        if (!this.buffer.hasNext()) {
            this.fetchNextPage();
        }
        return this.buffer.next();
    }

    private void fetchNextPage() {
        log.debug("fetchNextPage");
        PagedResponse<T> result = this.dataFetcher.apply(this.currentPage.nextKey());
        this.currentPage = result.paginationInfo();
        this.buffer = result.results().iterator();
    }
}

