/*
 * Decompiled with CFR 0.152.
 */
package cloud.quasarch.akash.impl;

import cloud.quasarch.akash.impl.Akash;
import cloud.quasarch.akash.impl.model.AkashPagedResponse;
import cloud.quasarch.akash.impl.model.OperationFailure;
import cloud.quasarch.akash.impl.model.PagedResponse;
import cloud.quasarch.akash.impl.model.remote.AkashErrorType;
import cloud.quasarch.akash.impl.model.remote.Bid;
import cloud.quasarch.akash.impl.model.remote.Deployment;
import cloud.quasarch.akash.impl.model.remote.DeploymentLease;
import cloud.quasarch.akash.impl.model.remote.ListBidResponse;
import cloud.quasarch.akash.impl.model.remote.ListDeploymentLeaseResponse;
import cloud.quasarch.akash.impl.model.remote.ListDeploymentsResponse;
import cloud.quasarch.akash.impl.pagination.AkashPagedIterable;
import cloud.quasarch.akash.impl.parsing.ResponseParser;
import cloud.quasarch.akash.impl.parsing.ResponseParserBuilder;
import cloud.quasarch.akash.impl.uri.QueryParam;
import cloud.quasarch.akash.impl.uri.UriUtils;
import io.vavr.control.Either;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded_package.org.apache.commons.lang3.NotImplementedException;

public final class AkashClient
implements Akash {
    private final String accountAddress;
    private final URI baseUri;
    private final Supplier<HttpClient> httpClientSupplier;
    private static final Logger log = LoggerFactory.getLogger(AkashClient.class);
    private static final String BASE_URI_ENV_VARIABLE_KEY = "QUASARCH_AKASH_BASE_URI";
    private static final String DEPLOYMENT_URI = "/api/akash/deployment/v1beta2/deployments/";
    private static final String DEPLOYMENT_LIST_URI = "/api/akash/deployment/v1beta2/deployments/list";
    private static final String DEPLOYMENT_GET_URI = "/api/akash/deployment/v1beta2/deployments/info";
    private static final String BID_URI = "/api/akash/market/v1beta2/bids/";
    private static final String BID_GET_URI = "/api/akash/market/v1beta2/bids/info";
    private static final String BID_LIST_URI = "/api/akash/market/v1beta2/bids/list";
    private static final String LEASE_URI = "/api/akash/market/v1beta2/leases/";
    private static final String LEASE_GET_URI = "/api/akash/market/v1beta2/leases/info";
    private static final String LEASE_LIST_URI = "/api/akash/market/v1beta2/leases/list";
    private static final String FILTERS_OWNER = "filters.owner";
    private static final String FILTERS_DSEQ = "filters.dseq";
    private static final String FILTERS_STATE = "filters.state";
    private static final String PAGINATION_KEY = "pagination.key";
    private static final String ID_OWNER = "id.owner";
    private static final String ID_DSEQ = "id.dseq";

    public AkashClient(String accountAddress) {
        String envBaseUri = System.getenv(BASE_URI_ENV_VARIABLE_KEY);
        Objects.requireNonNull(envBaseUri);
        this.baseUri = URI.create(envBaseUri);
        this.accountAddress = accountAddress;
        HttpClient httpClient = HttpClient.newHttpClient();
        this.httpClientSupplier = () -> httpClient;
    }

    public AkashClient(String accountAddress, URI baseUri, Supplier<HttpClient> httpClientSupplier) {
        this.accountAddress = accountAddress;
        this.baseUri = baseUri;
        this.httpClientSupplier = httpClientSupplier;
    }

    @Override
    public Either<OperationFailure, Deployment> createDeployment(Path sdlFile) {
        Objects.requireNonNull(sdlFile, "sdlFile cannot be empty on createDeployment");
        return null;
    }

    @Override
    public Either<OperationFailure, Deployment> closedDeployment(String leaseId) {
        throw new NotImplementedException("");
    }

    @Override
    public Either<OperationFailure, DeploymentLease> createLease() {
        throw new NotImplementedException("");
    }

    @Override
    public Either<OperationFailure, ?> sendManifest(Path sdlFile) {
        throw new NotImplementedException("");
    }

    @Override
    public Either<OperationFailure, ?> updateManifest(Path sdlFile) {
        throw new NotImplementedException("");
    }

    @Override
    public Either<OperationFailure, Iterable<Deployment>> listDeployments(String owner, String state, String deploymentSequence) {
        log.debug("listDeployments called for owner {}, state {} and deploymentSequence {}", new Object[]{owner, state, deploymentSequence});
        URI requestUri = UriUtils.addQueryParameters(URI.create(this.baseUri + DEPLOYMENT_LIST_URI), new QueryParam(FILTERS_OWNER, owner), new QueryParam(FILTERS_DSEQ, deploymentSequence), new QueryParam(FILTERS_STATE, state));
        log.debug("using {} path to list deployments", (Object)requestUri);
        ResponseParser responseParser = ResponseParserBuilder.newBuilder().withResultClass(ListDeploymentsResponse.class).withIntermediateOperation(intermediate -> new AkashPagedResponse<Deployment>(intermediate.deployments(), intermediate.pagination())).build();
        return this.listRequest(requestUri, responseParser).map(fPage -> new AkashPagedIterable(nextPage -> (PagedResponse)this.listRequest(UriUtils.addQueryParameters(requestUri, new QueryParam(PAGINATION_KEY, (String)nextPage)), responseParser).get(), fPage));
    }

    @Override
    public Either<OperationFailure, Deployment> getDeployment(String owner, String deploymentSequence) {
        log.debug("getDeployment called for owner {} and deploymentSequence {}", (Object)owner, (Object)deploymentSequence);
        Objects.requireNonNull(owner);
        Objects.requireNonNull(deploymentSequence);
        URI requestUri = UriUtils.addQueryParameters(URI.create(this.baseUri + DEPLOYMENT_GET_URI), new QueryParam(ID_OWNER, owner), new QueryParam(ID_DSEQ, deploymentSequence));
        log.debug("using {} path to get deployment", (Object)requestUri);
        ResponseParser responseParser = ResponseParserBuilder.newBuilder().withResultClass(Deployment.class).build();
        return this.getRequest(requestUri, responseParser);
    }

    @Override
    public Either<OperationFailure, Iterable<Bid>> listBids(@Nullable String owner, @Nullable String deploymentSequence, @Nullable String groupSequence, @Nullable String oSeq, @Nullable String providerId, @Nullable String state) {
        log.debug("listBids called with filters:  owner {}, deploymentSequence {}, groupSequence {} and oSeq {}providerId {}, state {}", new Object[]{owner, deploymentSequence, groupSequence, oSeq, providerId, state});
        URI requestUri = UriUtils.addQueryParameters(URI.create(this.baseUri + BID_LIST_URI), new QueryParam(FILTERS_OWNER, owner), new QueryParam(FILTERS_DSEQ, deploymentSequence), new QueryParam("filters.gseq", state), new QueryParam("filters.oseq", state), new QueryParam("filters.provider", state), new QueryParam(FILTERS_STATE, state));
        log.debug("using {} path to list bids", (Object)requestUri);
        ResponseParser responseParser = ResponseParserBuilder.newBuilder().withResultClass(ListBidResponse.class).withIntermediateOperation(intermediate -> new AkashPagedResponse<Bid>(intermediate.bids(), intermediate.pagination())).build();
        return this.listRequest(requestUri, responseParser).map(fPage -> new AkashPagedIterable(nextPage -> (PagedResponse)this.listRequest(UriUtils.addQueryParameters(requestUri, new QueryParam(PAGINATION_KEY, (String)nextPage)), responseParser).get(), fPage));
    }

    @Override
    public Either<OperationFailure, Bid> getBid(String owner, String deploymentSequence, @Nullable String groupSequence, @Nullable String orderSequence, String providerId) {
        log.debug("getBid called for owner {} deploymentSequence {} groupSequence {} orderSequence {}and providerId {}", new Object[]{owner, deploymentSequence, groupSequence, orderSequence, providerId});
        Objects.requireNonNull(owner);
        Objects.requireNonNull(deploymentSequence);
        Objects.requireNonNull(providerId);
        groupSequence = AkashClient.defaultsTo(groupSequence, () -> "1");
        orderSequence = AkashClient.defaultsTo(orderSequence, () -> "1");
        URI requestUri = UriUtils.addQueryParameters(URI.create(this.baseUri + BID_GET_URI), new QueryParam(ID_OWNER, owner), new QueryParam(ID_DSEQ, deploymentSequence), new QueryParam("id.gseq", groupSequence), new QueryParam("id.oseq", orderSequence), new QueryParam("id.provider", providerId));
        ResponseParser responseParser = ResponseParserBuilder.newBuilder().withResultClass(Bid.class).build();
        return this.getRequest(requestUri, responseParser);
    }

    @Override
    public Either<OperationFailure, DeploymentLease> getLease(String owner, String deploymentSequence, String groupSequence, String orderSequence, String provider) {
        log.debug("getLease called for owner {} deploymentSequence {} groupSequence {} orderSequence {}and provider {}", new Object[]{owner, deploymentSequence, groupSequence, orderSequence, provider});
        groupSequence = AkashClient.defaultsTo(groupSequence, () -> "1");
        orderSequence = AkashClient.defaultsTo(orderSequence, () -> "1");
        Objects.requireNonNull(owner);
        Objects.requireNonNull(deploymentSequence);
        Objects.requireNonNull(groupSequence);
        Objects.requireNonNull(orderSequence);
        Objects.requireNonNull(provider);
        URI requestUri = UriUtils.addQueryParameters(URI.create(this.baseUri + LEASE_GET_URI), new QueryParam(ID_OWNER, owner), new QueryParam(ID_DSEQ, deploymentSequence), new QueryParam("id.gseq", groupSequence), new QueryParam("id.oseq", orderSequence), new QueryParam("id.provider", provider));
        log.debug("using {} path to get lease", (Object)requestUri);
        HttpRequest request = HttpRequest.newBuilder(requestUri).GET().build();
        ResponseParser responseParser = ResponseParserBuilder.newBuilder().withResultClass(DeploymentLease.class).build();
        CompletionStage bodyFuture = this.httpClientSupplier.get().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(responseParser::parseToEither);
        return AkashClient.extractEither(bodyFuture);
    }

    @Override
    public Either<OperationFailure, Iterable<DeploymentLease>> listLeases(@Nullable String owner, @Nullable String deploymentSequence, @Nullable String groupSequence, @Nullable String orderSequence, @Nullable String provider, @Nullable String state) {
        log.debug("listBids called with filters:  owner {}, deploymentSequence {}, groupSequence {} and orderSequence {}providerId {}, state {}", new Object[]{owner, deploymentSequence, groupSequence, orderSequence, provider, state});
        URI requestUri = UriUtils.addQueryParameters(URI.create(this.baseUri + LEASE_LIST_URI), new QueryParam(FILTERS_OWNER, owner), new QueryParam(FILTERS_DSEQ, deploymentSequence), new QueryParam("filters.gseq", state), new QueryParam("filters.oseq", state), new QueryParam("filters.provider", state), new QueryParam(FILTERS_STATE, state));
        log.debug("using {} path to list leases", (Object)requestUri);
        ResponseParser responseParser = ResponseParserBuilder.newBuilder().withResultClass(ListDeploymentLeaseResponse.class).withIntermediateOperation(intermediate -> new AkashPagedResponse<DeploymentLease>(intermediate.leases(), intermediate.pagination())).build();
        return this.listRequest(requestUri, responseParser).map(fPage -> new AkashPagedIterable(nextPage -> (PagedResponse)this.listRequest(UriUtils.addQueryParameters(requestUri, new QueryParam(PAGINATION_KEY, (String)nextPage)), responseParser).get(), fPage));
    }

    private <T> Either<OperationFailure, AkashPagedResponse<T>> listRequest(URI requestUri, ResponseParser<AkashPagedResponse<T>> responseParser) {
        log.error("listRequest called for requestUri {}", (Object)requestUri);
        HttpRequest request = HttpRequest.newBuilder(requestUri).GET().build();
        CompletionStage bodyFuture = this.httpClientSupplier.get().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(responseParser::parseToEither);
        return AkashClient.extractEither(bodyFuture);
    }

    private <T> Either<OperationFailure, T> getRequest(URI requestUri, ResponseParser<T> responseParser) {
        HttpRequest request = HttpRequest.newBuilder(requestUri).GET().build();
        CompletionStage bodyFuture = this.httpClientSupplier.get().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(responseParser::parseToEither);
        return AkashClient.extractEither(bodyFuture);
    }

    private static <T> T defaultsTo(T instance, Supplier<T> defaultOnNull) {
        if (instance == null) {
            instance = defaultOnNull.get();
        }
        return instance;
    }

    private static <T> Either<OperationFailure, T> extractEither(CompletableFuture<Either<OperationFailure, T>> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Thread.currentThread().interrupt();
            return Either.left((Object)new OperationFailure(AkashErrorType.ClientError, ex.getMessage()));
        }
    }
}

