package cloud.oneentry.sdk.auth.ktor

import cloud.oneentry.sdk.auth.access.AccessService
import cloud.oneentry.sdk.auth.dto.UserTokenDto
import io.ktor.client.HttpClient
import io.ktor.client.call.body
import io.ktor.client.plugins.auth.Auth
import io.ktor.client.plugins.auth.providers.BearerTokens
import io.ktor.client.plugins.auth.providers.bearer
import io.ktor.client.request.post
import io.ktor.client.request.setBody
import kotlinx.serialization.json.buildJsonObject
import kotlinx.serialization.json.put
import org.kodein.di.DI
import org.kodein.di.bind
import org.kodein.di.instance
import org.kodein.di.singleton

val protectedHttpClientModule = DI.Module("ProtectedHttpClientModule") {
    bind<HttpClient>(tag = "protected") with singleton {
        val client: HttpClient = instance()
        val access: AccessService = instance()

        client.config {
            install(Auth) {
                bearer {
                    loadTokens {
                        val accessToken = access.accessToken ?: return@loadTokens null
                        val refreshToken = access.refreshToken ?: return@loadTokens null

                        println(accessToken)
                        println(refreshToken)

                        BearerTokens(accessToken, refreshToken)
                    }

                    refreshTokens {
                        val refreshToken = oldTokens?.refreshToken ?: return@refreshTokens null
                        val body = buildJsonObject { put("refreshToken", refreshToken) }
                        val marker = access.marker ?: return@refreshTokens null
                        val response = client.post("users-auth-providers/marker/$marker/users/refresh") {
                            markAsRefreshTokenRequest()
                            setBody(body)
                        }

                        val tokens: UserTokenDto = response.body()
                        access.accessToken = tokens.accessToken
                        access.refreshToken = tokens.refreshToken
                        access.marker = tokens.authProviderIdentifier

                        BearerTokens(tokens.accessToken, tokens.refreshToken)
                    }
                }
            }
        }
    }
}