package cloud.oneentry.sdk.auth.dto

import cloud.oneentry.sdk.localization.dto.LocalizedInfo
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class UsersAuthProvider(
    val id: Int,
    val localizeInfos: Map<String, LocalizedInfo>? = null,
    val version: Int? = null,
    val position: Int? = null,
    val identifier: String,
    val type: Type,
    val formIdentifier: String? = null,
    val isActive: Boolean,
    val isCheckCode: Boolean,
    val config: ConfigType? = null
) {
    @Serializable
    data class ConfigType(
        val deleteNoneActiveUsersAfterDays: Int,
        val systemCodeTlsSec: Int,
        val systemCodeLength: Int,
        val systemCodeOnlyNumbers: Boolean
    )

    @Suppress("unused")
    @Serializable
    enum class Type {
        @SerialName("email") EMAIL,
        @SerialName("phone") PHONE,
    }
}