package cloud.oneentry.sdk.auth.dto

import cloud.oneentry.sdk.form.dto.Form
import kotlinx.serialization.Serializable
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.decodeFromJsonElement
import kotlin.experimental.ExperimentalObjCName
import kotlin.native.HiddenFromObjC
import kotlin.native.ObjCName

@Serializable
data class User(
    val id: Int,
    val identifier: String,
    val formData: Map<String, List<Form.Data>> = emptyMap(),
    val formIdentifier: String,
    val authProviderIdentifier: String,
    val groups: List<String> = emptyList(),
    val state: JsonElement
) {
    @Suppress("unused")
    @OptIn(ExperimentalObjCName::class)
    @ObjCName("__encodeState")
    @Throws(Throwable::class)
    fun encodeState(): String =
        Json.encodeToString(state)

    @Suppress("unused")
    @HiddenFromObjC
    inline fun <reified T> state(json: Json = Json): T =
        json.decodeFromJsonElement(state)
}
