package cloud.oneentry.sdk.auth.dsl

import cloud.oneentry.sdk.auth.dto.AuthData
import cloud.oneentry.sdk.auth.dto.UpdateFromUserDto
import cloud.oneentry.sdk.auth.dto.UserNotificationData
import cloud.oneentry.sdk.form.dsl.FormDataLocalizationBuilder
import cloud.oneentry.sdk.form.dto.Form
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.buildJsonObject
import kotlinx.serialization.json.encodeToJsonElement
import kotlin.native.HiddenFromObjC

@Suppress("MemberVisibilityCanBePrivate", "unused")
class UpdateUserBuilder(
    private val formIdentifier: String,
    private val langCode: String,
    val serializer: Json = Json,
) {
    val authData = AuthDataBuilder()
    val formData = FormDataLocalizationBuilder()
    var notificationData: UserNotificationData? = null
    var state: JsonElement = buildJsonObject {}

    fun authData(data: List<AuthData>) {
        authData.putAll(data)
    }

    fun authData(perform: AuthDataBuilder.() -> Unit) =
        authData.perform()

    fun formData(data: Map<String, List<Form.Data>>) {
        formData.localizations.putAll(data)
    }

    fun formData(perform: FormDataLocalizationBuilder.() -> Unit) {
        formData.perform()
    }

    fun notificationData(notificationData: UserNotificationData) {
        this.notificationData = notificationData
    }

    fun notificationData(email: String, phonePush: List<String> = listOf(), phoneSMS: String) {
        notificationData(
            UserNotificationData(
                email,
                phonePush,
                phoneSMS
            )
        )
    }

    fun state(state: JsonElement) {
        this.state = state
    }

    fun state(json: String) {
        this.state = serializer.parseToJsonElement(json)
    }

    @HiddenFromObjC
    inline fun <reified T> state(state: T) {
        val element = serializer.encodeToJsonElement(state)
        this.state = element
    }

    fun build() = UpdateFromUserDto(
        formIdentifier,
        langCode,
        formData.localizations,
        authData.authData,
        notificationData,
        state
    )
}