package cloud.oneentry.sdk.auth.dsl

import cloud.oneentry.sdk.auth.dto.AuthData
import cloud.oneentry.sdk.auth.dto.CreateUserDto
import cloud.oneentry.sdk.auth.dto.UserNotificationData
import cloud.oneentry.sdk.form.dsl.FormDataLocalizationBuilder
import cloud.oneentry.sdk.form.type.FormDataBuildable

@Suppress("MemberVisibilityCanBePrivate", "unused")
class SignUpBuilder(
    private val formIdentifier: String,
    private val langCode: String,
): FormDataBuildable {
    val authData = AuthDataBuilder()
    override val formData = FormDataLocalizationBuilder()
    var notificationData: UserNotificationData? = null

    fun authData(perform: AuthDataBuilder.() -> Unit) =
        authData.perform()

    fun authData(data: List<AuthData>) {
        authData.putAll(data)
    }

    fun notificationData(notificationData: UserNotificationData) {
        this.notificationData = notificationData
    }

    fun notificationData(email: String, phonePush: List<String> = listOf(), phoneSMS: String) {
        notificationData(
            UserNotificationData(
                email,
                phonePush,
                phoneSMS
            )
        )
    }

    fun build(): CreateUserDto =
        CreateUserDto(
            formIdentifier = formIdentifier,
            langCode = langCode,
            formData = formData.localizations,
            authData = authData.authData,
            notificationData = notificationData
        )
}