package cloud.oneentry.sdk.auth.access

import cloud.oneentry.sdk.auth.keychain.service.KeychainService

class AccessService(
    private val keychain: KeychainService
) {
    var refreshToken: String?
        get() = keychain["refresh_token"]
        set(value) {
            this["refresh_token"] = value
        }

    var accessToken: String?
        get() = keychain["access_token"]
        set(value) {
            this["access_token"] = value
        }

    var marker: String?
        get() = keychain["marker"]
        set(value) {
            this["marker"] = value
        }

    val isAuthenticated: Boolean
        get() = refreshToken != null && accessToken != null && marker != null

    operator fun set(key: String, value: String?) {
        if (value != null) {
            keychain[key] = value
        } else {
            keychain.remove(key)
        }
    }
}