package cloud.oneentry.sdk.auth

import cloud.oneentry.sdk.auth.access.AccessService
import cloud.oneentry.sdk.auth.dsl.UpdateUserBuilder
import cloud.oneentry.sdk.auth.dto.User
import cloud.oneentry.sdk.core.inject
import cloud.oneentry.sdk.core.query.query
import io.ktor.client.HttpClient
import io.ktor.client.call.body
import io.ktor.client.request.delete
import io.ktor.client.request.get
import io.ktor.client.request.post
import io.ktor.client.request.put
import io.ktor.client.request.setBody

@Suppress("unused")
object UserService {
    private val protectedService: HttpClient by inject("protected")
    private val access: AccessService by inject()

    val isAuthenticated: Boolean
        get() = access.isAuthenticated

    /**
     * Update of a single user object
     *
     * @param langCode language code
     */
    @Throws(Throwable::class)
    suspend fun me(langCode: String = "en_US"): User {
        val response = protectedService.get("users/me") {
            query("langCode" to langCode)
        }

        return response.body()
    }

    @Throws(Throwable::class)
    suspend fun update(
        formIdentifier: String,
        langCode: String = "en_US",
        perform: UpdateUserBuilder.() -> Unit
    ) {
        val builder = UpdateUserBuilder(formIdentifier, langCode)
        builder.perform()

        protectedService.put("users/me") {
            setBody(builder.build())
        }
    }

    @Throws(Throwable::class)
    suspend fun updateFCM(token: String) {
        protectedService.post("/api/content/users/me/fcm-token/$token")
    }

    @Throws(Throwable::class)
    suspend fun deleteFCM(token: String) {
        protectedService.delete("/api/content/users/me/fcm-token/$token")
    }
}