/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.register;

import cloud.longfa.encrypt.enums.CipherMode;
import cloud.longfa.encrypt.generator.GeneratorSecretKey;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.RSA;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.UUID;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.lang.NonNull;

public class RegisterBeanDefinition
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        GenericBeanDefinition genericBeanDefinition = new GenericBeanDefinition();
        genericBeanDefinition.setBeanClass(GeneratorSecretKeyFactory.class);
        genericBeanDefinition.setAutowireCandidate(true);
        genericBeanDefinition.setScope("singleton");
        beanDefinitionRegistry.registerBeanDefinition("generatorSecretKeyProxy", (BeanDefinition)genericBeanDefinition);
    }

    public static class GeneratorSecretKeyFactory
    implements FactoryBean<GeneratorSecretKey>,
    InvocationHandler {
        public GeneratorSecretKey getObject() {
            return (GeneratorSecretKey)Proxy.newProxyInstance(GeneratorSecretKeyFactory.class.getClassLoader(), new Class[]{GeneratorSecretKey.class}, (InvocationHandler)this);
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<?> getObjectType() {
            return GeneratorSecretKey.class;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            switch ((CipherMode)((Object)args[0])) {
                case AES: {
                    HashMap<String, String> aesKey = new HashMap<String, String>();
                    aesKey.put("AES_KEY", UUID.randomUUID().toString().replace("-", ""));
                    StringBuilder stringBuffer = new StringBuilder(UUID.randomUUID().toString().replace("-", ""));
                    String substring = stringBuffer.substring(0, 16);
                    aesKey.put("AES_IV", substring);
                    return aesKey;
                }
                case RSA: {
                    RSA rsa = new RSA(AsymmetricAlgorithm.RSA.toString());
                    HashMap<String, String> rsaKeyMap = new HashMap<String, String>();
                    rsaKeyMap.put("RSA_PrivateKey", rsa.getPrivateKeyBase64());
                    rsaKeyMap.put("RSA_PublicKey", rsa.getPrivateKeyBase64());
                    return rsaKeyMap;
                }
                case SM4: {
                    String SM4KEY = UUID.randomUUID().toString().replace("-", "");
                    String SM4IV = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
                    HashMap<String, String> sm4Map = new HashMap<String, String>();
                    sm4Map.put("sm4\u5bc6\u94a5", SM4KEY);
                    sm4Map.put("sm4\u504f\u79fb\u91cf", SM4IV);
                    return sm4Map;
                }
            }
            throw new RuntimeException("cloud/longfa/encrypt/register");
        }
    }
}

