/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.handler;

import cloud.longfa.encrypt.anotation.Decrypt;
import cloud.longfa.encrypt.anotation.Encrypt;
import cloud.longfa.encrypt.handler.ScenarioHandler;
import cloud.longfa.encrypt.handler.ScenarioHolder;
import cloud.longfa.encrypt.handler.StorageScenario;
import cloud.longfa.encrypt.handler.TransmitScenario;
import cloud.longfa.encrypt.spel.SpELExpressionHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.StringUtils;

public abstract class ScenarioSchedule {
    public static SpELExpressionHandler spELExpressionHandler;

    public Object scenarioSchedule(ProceedingJoinPoint joinPoint) throws Throwable {
        Annotation[] annotations;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        block8: for (Annotation annotation : annotations = signature.getMethod().getAnnotations()) {
            TransmitScenario transmit;
            StorageScenario scenario;
            ScenarioHandler scenarioHandler;
            String[] fields;
            String SPEL_EXPRESSION;
            String expression;
            if (annotation instanceof Encrypt) {
                Encrypt encrypt = (Encrypt)annotation;
                expression = encrypt.value();
                SPEL_EXPRESSION = "::" + expression + "::";
                if (StringUtils.hasText((String)expression)) {
                    fields = spELExpressionHandler.parseSpELExpression(SPEL_EXPRESSION);
                    this.processorAnnotation(encrypt, fields);
                }
                scenarioHandler = ScenarioHolder.getScenarios(encrypt.scenario());
                switch (encrypt.scenario()) {
                    case storage: {
                        Object[] args = joinPoint.getArgs();
                        scenario = (StorageScenario)scenarioHandler;
                        scenario.storageEncryptProcessor(args, signature, encrypt);
                        break;
                    }
                    case transmit: {
                        Object proceed = joinPoint.proceed();
                        transmit = (TransmitScenario)scenarioHandler;
                        transmit.transmitEncryptProcessor(proceed, signature, encrypt);
                        return proceed;
                    }
                    default: {
                        return "No such algorithm Contact about:email---> longfa0130@gmail.com";
                    }
                }
            }
            if (!(annotation instanceof Decrypt)) continue;
            Decrypt decrypt = (Decrypt)annotation;
            expression = decrypt.value();
            SPEL_EXPRESSION = "::" + expression + "::";
            if (StringUtils.hasText((String)expression)) {
                fields = spELExpressionHandler.parseSpELExpression(SPEL_EXPRESSION);
                this.processorAnnotation(decrypt, fields);
            }
            scenarioHandler = ScenarioHolder.getScenarios(decrypt.scenario());
            switch (decrypt.scenario()) {
                case storage: {
                    Object proceed = joinPoint.proceed();
                    scenario = (StorageScenario)scenarioHandler;
                    scenario.storageDecryptProcessor(proceed, signature, decrypt);
                    return proceed;
                }
                case transmit: {
                    Object[] args = joinPoint.getArgs();
                    transmit = (TransmitScenario)scenarioHandler;
                    transmit.transmitDecryptProcessor(args, signature, decrypt);
                    continue block8;
                }
                default: {
                    return "No such algorithm Contact about:email---> longfa0130@gmail.com";
                }
            }
        }
        return joinPoint.proceed();
    }

    private void processorAnnotation(Annotation annotation, String[] fields) throws NoSuchFieldException, IllegalAccessException {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        Field hField = invocationHandler.getClass().getDeclaredField("memberValues");
        hField.setAccessible(true);
        Map memberValues = (Map)hField.get(invocationHandler);
        memberValues.put("fields", fields);
    }
}

