/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.handler;

import cloud.longfa.encrypt.anotation.Decrypt;
import cloud.longfa.encrypt.anotation.Encrypt;
import cloud.longfa.encrypt.enums.CipherMode;
import cloud.longfa.encrypt.enums.Scenario;
import cloud.longfa.encrypt.handler.ScenarioHandler;
import cloud.longfa.encrypt.handler.ScenarioSchedule;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.Assert;

public interface ScenarioHolder {
    public static final ConcurrentHashMap<Scenario, ScenarioHandler> abstractScenarios = new ConcurrentHashMap();
    public static final ArrayList<ScenarioSchedule> scenarioSchedules = new ArrayList();
    public static final ConcurrentHashMap<String, CipherMode> fieldNames = new ConcurrentHashMap();

    public static void addField(String fieldName, CipherMode cipherMode) {
        fieldNames.put(fieldName, cipherMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFieldCipherModes() {
        Set keySetView = fieldNames.keySet();
        StringBuilder stringBuilder = new StringBuilder();
        for (String filedName : keySetView) {
            stringBuilder.append(filedName).append(":").append((Object)fieldNames.get(filedName)).append("-");
        }
        String newStr = "";
        if (stringBuilder.length() > 0) {
            int lastIndexOf = stringBuilder.lastIndexOf("-");
            newStr = stringBuilder.substring(0, lastIndexOf);
        }
        try {
            String string = newStr;
            return string;
        }
        finally {
            fieldNames.clear();
        }
    }

    public static ScenarioHandler getScenarios(Scenario scenario) {
        return abstractScenarios.get((Object)scenario);
    }

    public static Object scenarioSchedule(ProceedingJoinPoint joinPoint) throws Throwable {
        ScenarioSchedule scenarioSchedule = scenarioSchedules.get(0);
        Assert.notNull((Object)scenarioSchedule, (String)"\u8c03\u5ea6\u5668\u672a\u52a0\u8f7d\u81f3\u5bb9\u5668");
        return scenarioSchedule.scenarioSchedule(joinPoint);
    }

    public static Executor getExecutor() {
        return ScenarioHandler.executor;
    }

    public void storageEncryptProcessor(Object[] var1, MethodSignature var2, Encrypt var3) throws Throwable;

    public void storageDecryptProcessor(Object var1, MethodSignature var2, Decrypt var3) throws Throwable;

    public void transmitEncryptProcessor(Object var1, MethodSignature var2, Encrypt var3) throws Throwable;

    public void transmitDecryptProcessor(Object[] var1, MethodSignature var2, Decrypt var3) throws Throwable;
}

