/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.handler;

import cloud.longfa.encrypt.anotation.Badger;
import cloud.longfa.encrypt.anotation.Decrypt;
import cloud.longfa.encrypt.anotation.Encrypt;
import cloud.longfa.encrypt.badger.HoneyBadgerEncrypt;
import cloud.longfa.encrypt.enums.CipherMode;
import cloud.longfa.encrypt.handler.ScenarioHolder;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public abstract class ScenarioHandler
implements ScenarioHolder {
    private static final Log echo = LogFactory.getLog(ScenarioHandler.class);
    public static HoneyBadgerEncrypt honeyBadgerEncrypt;
    public static Executor executor;
    protected static final String[] exclude;

    protected String encryptionProcessor(Object target, @NonNull CipherMode cipherMode) {
        switch (cipherMode) {
            case AES: {
                return honeyBadgerEncrypt.aesEncrypt(target.toString());
            }
            case RSA: {
                return honeyBadgerEncrypt.rsaEncrypt(target.toString());
            }
            case SM4: {
                return honeyBadgerEncrypt.sm4Encrypt(target.toString());
            }
            case SM4_RSA: {
                return honeyBadgerEncrypt.sm4RsaEncrypt(target.toString());
            }
            case AES_RSA: {
                return honeyBadgerEncrypt.aesRsaEncrypt(target.toString());
            }
        }
        return "No such algorithm Contact about:email---> longfa0130@gmail.com";
    }

    protected String decryptionProcessor(Object target, @NonNull CipherMode cipherMode) {
        switch (cipherMode) {
            case AES: {
                return honeyBadgerEncrypt.aesDecrypt(target.toString());
            }
            case RSA: {
                return honeyBadgerEncrypt.rsaDecrypt(target.toString());
            }
            case SM4: {
                return honeyBadgerEncrypt.sm4Decrypt(target.toString());
            }
            case SM4_RSA: {
                return honeyBadgerEncrypt.sm4RsaDecrypt(target.toString());
            }
            case AES_RSA: {
                return honeyBadgerEncrypt.aesRsaDecrypt(target.toString());
            }
        }
        return "No such algorithm Contact about:email---> longfa0130@gmail.com";
    }

    @Override
    public void storageEncryptProcessor(Object[] args, MethodSignature signature, Encrypt encrypt) throws Throwable {
        CipherMode cipherMode = encrypt.cipher();
        String[] fields = encrypt.fields();
        List<String> fieldNames = Arrays.stream(fields).map(String::toLowerCase).collect(Collectors.toList());
        String[] parameterNames = signature.getParameterNames();
        Object[] clone = (Object[])args.clone();
        for (String fieldName : fieldNames) {
            for (int i = 0; i < parameterNames.length; ++i) {
                if (!parameterNames[i].equalsIgnoreCase(fieldName) || !Objects.nonNull(args[i]) || !StringUtils.hasText((String)args[i].toString())) continue;
                ScenarioHolder.fieldNames.put(parameterNames[i], cipherMode);
                args[i] = this.encryptionProcessor(args[i], cipherMode);
            }
        }
        if (!Arrays.equals(clone, args)) {
            return;
        }
        for (Object arg : args) {
            for (String ex : exclude) {
                if (arg.getClass().getSimpleName().toLowerCase().contains(ex)) break;
            }
            Field[] declaredFields = arg.getClass().getDeclaredFields();
            this.handlerNestedEncrypt(arg, declaredFields, fieldNames, cipherMode);
        }
    }

    protected void handlerNestedEncrypt(Object arg, Field[] declaredFields, List<String> fieldNames, CipherMode cipherMode) throws Throwable {
        block9: {
            block10: {
                block8: {
                    if (!StringUtils.hasText((String)arg.toString())) {
                        return;
                    }
                    for (Field declaredField : declaredFields) {
                        declaredField.setAccessible(true);
                        for (String fieldName : fieldNames) {
                            Object encryptDate;
                            Badger badgerAnnotation = declaredField.getAnnotation(Badger.class);
                            if (Objects.nonNull(badgerAnnotation)) {
                                encryptDate = declaredField.get(arg);
                                if (!badgerAnnotation.cipher().equals((Object)CipherMode.DEFAULT)) {
                                    cipherMode = badgerAnnotation.cipher();
                                }
                                ScenarioHolder.fieldNames.put(declaredField.getName(), cipherMode);
                                declaredField.set(arg, this.encryptionProcessor(encryptDate, cipherMode));
                                continue;
                            }
                            if (!declaredField.getName().equalsIgnoreCase(fieldName) || Objects.isNull(encryptDate = declaredField.get(arg))) continue;
                            ScenarioHolder.fieldNames.put(declaredField.getName(), cipherMode);
                            declaredField.set(arg, this.encryptionProcessor(encryptDate, cipherMode));
                        }
                    }
                    if (!(arg instanceof List)) break block8;
                    List objects = (List)arg;
                    for (Object object : objects) {
                        Field[] declaredFields1 = object.getClass().getDeclaredFields();
                        this.handlerNestedEncrypt(object, declaredFields1, fieldNames, cipherMode);
                    }
                    break block9;
                }
                if (!(arg instanceof Map)) break block10;
                Map map = (Map)arg;
                Set set = map.keySet();
                for (Object o : set) {
                    Object obj = map.get(o);
                    Field[] mapFields = obj.getClass().getDeclaredFields();
                    this.handlerNestedEncrypt(obj, mapFields, fieldNames, cipherMode);
                }
                break block9;
            }
            if (!(arg instanceof Set)) break block9;
            Set set = (Set)arg;
            for (Object obj : set) {
                Field[] setFields = obj.getClass().getDeclaredFields();
                this.handlerNestedEncrypt(obj, setFields, fieldNames, cipherMode);
            }
        }
    }

    @Override
    public void storageDecryptProcessor(Object process, MethodSignature signature, Decrypt decrypt) throws Throwable {
        Class<?> clazz = process.getClass();
        Field[] declaredFields = clazz.getDeclaredFields();
        CipherMode cipherMode = decrypt.cipher();
        List<String> fieldNames = Arrays.stream(decrypt.fields()).map(String::toLowerCase).collect(Collectors.toList());
        this.handlerNestedDecrypt(process, declaredFields, fieldNames, cipherMode);
    }

    protected void handlerNestedDecrypt(Object process, Field[] declaredFields, List<String> fieldNames, CipherMode cipherMode) throws IllegalAccessException {
        block9: {
            block10: {
                block8: {
                    if (Objects.isNull(process) || !StringUtils.hasText((String)process.toString())) {
                        return;
                    }
                    for (Field declaredField : declaredFields) {
                        declaredField.setAccessible(true);
                        for (String fieldName : fieldNames) {
                            Object encryptDate;
                            Badger badgerAnnotation = declaredField.getAnnotation(Badger.class);
                            if (Objects.nonNull(badgerAnnotation)) {
                                encryptDate = declaredField.get(process);
                                if (!badgerAnnotation.cipher().equals((Object)CipherMode.DEFAULT)) {
                                    cipherMode = badgerAnnotation.cipher();
                                }
                                declaredField.set(process, this.decryptionProcessor(encryptDate, cipherMode));
                                continue;
                            }
                            if (!declaredField.getName().equalsIgnoreCase(fieldName) || Objects.isNull(encryptDate = declaredField.get(process))) continue;
                            declaredField.set(process, this.decryptionProcessor(encryptDate.toString(), cipherMode));
                        }
                    }
                    if (!(process instanceof List)) break block8;
                    List objects = (List)process;
                    for (Object object : objects) {
                        Field[] declaredFields1 = object.getClass().getDeclaredFields();
                        this.handlerNestedDecrypt(object, declaredFields1, fieldNames, cipherMode);
                    }
                    break block9;
                }
                if (!(process instanceof Map)) break block10;
                Map map = (Map)process;
                Set set = map.keySet();
                for (Object o : set) {
                    Object obj = map.get(o);
                    Field[] mapFields = obj.getClass().getDeclaredFields();
                    this.handlerNestedDecrypt(obj, mapFields, fieldNames, cipherMode);
                }
                break block9;
            }
            if (!(process instanceof Set)) break block9;
            Set set = (Set)process;
            for (Object obj : set) {
                Field[] setFields = obj.getClass().getDeclaredFields();
                this.handlerNestedDecrypt(obj, setFields, fieldNames, cipherMode);
            }
        }
    }

    @Override
    public void transmitEncryptProcessor(Object process, MethodSignature signature, Encrypt encrypt) throws Throwable {
        if (Objects.isNull(process)) {
            return;
        }
        CipherMode cipherMode = encrypt.cipher();
        List<String> fieldNames = Arrays.stream(encrypt.fields()).map(String::toLowerCase).collect(Collectors.toList());
        Field[] declaredFields = process.getClass().getDeclaredFields();
        this.tHandlerNestedEncrypt(process, declaredFields, fieldNames, cipherMode);
    }

    private void tHandlerNestedEncrypt(Object process, Field[] declaredFields, List<String> fieldNames, CipherMode cipherMode) throws Throwable {
        block10: {
            block11: {
                block9: {
                    if (Objects.isNull(process) || !StringUtils.hasText((String)process.toString())) {
                        return;
                    }
                    for (Field declaredField : declaredFields) {
                        declaredField.setAccessible(true);
                        for (String fieldName : fieldNames) {
                            Object encryptDate;
                            Badger badgerAnnotation = declaredField.getAnnotation(Badger.class);
                            if (Objects.nonNull(badgerAnnotation)) {
                                encryptDate = declaredField.get(process);
                                if (!badgerAnnotation.cipher().equals((Object)CipherMode.DEFAULT)) {
                                    cipherMode = badgerAnnotation.cipher();
                                }
                                ScenarioHolder.fieldNames.put(declaredField.getName(), cipherMode);
                                declaredField.set(process, this.encryptionProcessor(encryptDate, cipherMode));
                                continue;
                            }
                            if (!declaredField.getName().equalsIgnoreCase(fieldName) || Objects.isNull(encryptDate = declaredField.get(process))) continue;
                            ScenarioHolder.fieldNames.put(declaredField.getName(), cipherMode);
                            declaredField.set(process, this.encryptionProcessor(encryptDate.toString(), cipherMode));
                        }
                    }
                    if (!(process instanceof List)) break block9;
                    List objects = (List)process;
                    for (Object object : objects) {
                        Field[] listFields = object.getClass().getDeclaredFields();
                        this.tHandlerNestedEncrypt(object, listFields, fieldNames, cipherMode);
                    }
                    break block10;
                }
                if (!(process instanceof Map)) break block11;
                Map map = (Map)process;
                Set keys = map.keySet();
                for (Object key : keys) {
                    Object obj = map.get(key);
                    if (fieldNames.contains(key.toString())) {
                        String enc = this.encryptionProcessor(obj, cipherMode);
                        map.put(key, enc);
                        continue;
                    }
                    Field[] mapFields = obj.getClass().getDeclaredFields();
                    this.tHandlerNestedEncrypt(obj, mapFields, fieldNames, cipherMode);
                }
                break block10;
            }
            if (!(process instanceof Set)) break block10;
            Set set = (Set)process;
            for (Object obj : set) {
                Field[] setFields = obj.getClass().getDeclaredFields();
                this.tHandlerNestedEncrypt(obj, setFields, fieldNames, cipherMode);
            }
        }
    }

    @Override
    public void transmitDecryptProcessor(Object[] args, MethodSignature signature, Decrypt decrypt) throws Throwable {
        String[] parameterNames = signature.getParameterNames();
        for (String fieldName : decrypt.fields()) {
            for (int i = 0; i < args.length; ++i) {
                if (!parameterNames[i].equalsIgnoreCase(fieldName) || !Objects.nonNull(args[i]) || !StringUtils.hasText((String)args[i].toString())) continue;
                args[i] = this.decryptionProcessor(args[i], decrypt.cipher());
            }
        }
        String[] fields = decrypt.fields();
        CipherMode cipher = decrypt.cipher();
        List<String> fieldList = Arrays.stream(fields).map(String::toLowerCase).collect(Collectors.toList());
        for (Object arg : args) {
            for (String ex : exclude) {
                if (arg.getClass().getName().toLowerCase().contains(ex)) break;
            }
            Field[] declaredFields = arg.getClass().getDeclaredFields();
            this.tHandlerNestedDecrypt(arg, declaredFields, fieldList, cipher);
        }
    }

    private void tHandlerNestedDecrypt(Object arg, Field[] declaredFields, List<String> fieldList, CipherMode cipherMode) throws IllegalAccessException, UnsupportedEncodingException {
        block9: {
            block10: {
                block8: {
                    if (Objects.isNull(arg) || !StringUtils.hasText((String)arg.toString())) {
                        return;
                    }
                    for (Field declaredField : declaredFields) {
                        declaredField.setAccessible(true);
                        for (String fieldName : fieldList) {
                            Object decryptDate;
                            Badger badgerAnnotation = declaredField.getAnnotation(Badger.class);
                            if (Objects.nonNull(badgerAnnotation)) {
                                Object encryptDate = declaredField.get(arg);
                                if (!badgerAnnotation.cipher().equals((Object)CipherMode.DEFAULT)) {
                                    cipherMode = badgerAnnotation.cipher();
                                }
                                declaredField.set(arg, this.decryptionProcessor(encryptDate, cipherMode));
                                continue;
                            }
                            if (!declaredField.getName().equalsIgnoreCase(fieldName) || Objects.isNull(decryptDate = declaredField.get(arg))) continue;
                            declaredField.set(arg, this.decryptionProcessor(decryptDate, cipherMode));
                        }
                    }
                    if (!(arg instanceof List)) break block8;
                    List objects = (List)arg;
                    for (Object object : objects) {
                        Field[] listFields = object.getClass().getDeclaredFields();
                        this.tHandlerNestedDecrypt(object, listFields, fieldList, cipherMode);
                    }
                    break block9;
                }
                if (!(arg instanceof Map)) break block10;
                Map map = (Map)arg;
                Set keySet = map.keySet();
                for (Object key : keySet) {
                    Object obj = map.get(key);
                    Field[] mapFields = obj.getClass().getDeclaredFields();
                    this.tHandlerNestedDecrypt(obj, mapFields, fieldList, cipherMode);
                }
                break block9;
            }
            if (!(arg instanceof Set)) break block9;
            Set set = (Set)arg;
            for (Object obj : set) {
                Field[] setFields = obj.getClass().getDeclaredFields();
                this.tHandlerNestedDecrypt(obj, setFields, fieldList, cipherMode);
            }
        }
    }

    static {
        executor = null;
        exclude = new String[]{"http", "request", "response", "session", "cookie", "servlet"};
    }
}

