/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.config;

import cloud.longfa.encrypt.config.EncryptProvider;
import cloud.longfa.encrypt.enums.CipherMode;
import java.util.UUID;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="badger.encrypt")
public class AESConfiguration
extends EncryptProvider
implements InitializingBean {
    private static final String AES_KEY = UUID.randomUUID().toString().replace("-", "");
    private static final String AES_IV = UUID.randomUUID().toString().replace("-", "");
    private String aesKey;
    private String aesIv;

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public void setAesIv(String aesIv) {
        this.aesIv = aesIv;
    }

    public String getAesKey() {
        if (StringUtils.hasText((String)this.aesKey)) {
            return this.aesKey;
        }
        return AES_KEY;
    }

    public String getAesIv() {
        if (StringUtils.hasText((String)this.aesIv)) {
            return this.aesIv;
        }
        return AES_IV;
    }

    public void afterPropertiesSet() {
        EncryptProvider.encryptFactory.put(CipherMode.AES, this);
    }
}

