/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.badger;

import cloud.longfa.encrypt.config.EncryptProvider;
import cloud.longfa.encrypt.enums.CipherMode;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HoneyBadgerEncrypt
implements InitializingBean {
    private static final Log echo = LogFactory.getLog(HoneyBadgerEncrypt.class);
    public static byte[] AES_KEY;
    public static byte[] AES_IV;
    public static SM4 sm4;
    public static RSA rsa;
    public static AES aes;
    public static String PRIVATE_KEY;
    public static String PUBLIC_KEY;
    public static final Digester digester;
    public static byte[] SM4_KEY;
    public static byte[] SM4_IV;
    public static final ConcurrentHashMap<CipherMode, String> rsaCiphertexts;
    public static final ConcurrentHashMap<CipherMode, SymmetricCrypto> symmetricCryptos;

    public void afterPropertiesSet() {
        PRIVATE_KEY = EncryptProvider.privateKeyBase64();
        PUBLIC_KEY = EncryptProvider.publicKeyBase64();
        byte[] bytes = EncryptProvider.aesKey().getBytes(StandardCharsets.UTF_8);
        AES_KEY = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue(), (byte[])bytes).getEncoded();
        String aesIv = EncryptProvider.aesIv();
        AES_IV = aesIv.getBytes(StandardCharsets.UTF_8);
        aes = new AES(Mode.CTS, Padding.PKCS5Padding, AES_KEY, AES_IV);
        rsa = new RSA(AsymmetricAlgorithm.RSA_ECB_PKCS1.getValue(), PRIVATE_KEY, PUBLIC_KEY);
        byte[] sm4KeyBytes = EncryptProvider.sm4Key().getBytes(StandardCharsets.UTF_8);
        SM4_IV = EncryptProvider.sm4Iv().getBytes(StandardCharsets.UTF_8);
        SM4_KEY = SecureUtil.generateKey((String)"SM4", (byte[])sm4KeyBytes).getEncoded();
        sm4 = new SM4(Mode.CTS, Padding.PKCS5Padding, SM4_KEY, SM4_IV);
        echo.info((Object)("RSA\u79c1\u94a5:\n" + PRIVATE_KEY));
        echo.info((Object)("RSA\u516c\u94a5:\n" + PUBLIC_KEY));
        echo.info((Object)("aesKey:\n" + new String(AES_KEY, StandardCharsets.UTF_8)));
        echo.info((Object)("aesIv:\n" + new String(AES_IV, StandardCharsets.UTF_8)));
        echo.info((Object)("SM4\u5bc6\u94a5\n" + new String(SM4_KEY, StandardCharsets.UTF_8)));
        echo.info((Object)("SM4\u5bc6\u94a5\n" + new String(SM4_IV, StandardCharsets.UTF_8)));
    }

    public String aesEncrypt(String content) {
        return aes.encryptHex(content, StandardCharsets.UTF_8);
    }

    public String aesDecrypt(String encrypt) {
        return aes.decryptStr(encrypt, StandardCharsets.UTF_8);
    }

    public String sm4Encrypt(String context) {
        return sm4.encryptHex(context, StandardCharsets.UTF_8);
    }

    public String sm4Decrypt(String encrypt) {
        return sm4.decryptStr(encrypt, StandardCharsets.UTF_8);
    }

    public String rsaEncrypt(String content) {
        return rsa.encryptHex(content, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public String rsaDecrypt(String encrypt) {
        return rsa.decryptStr(encrypt, KeyType.PrivateKey, CharsetUtil.CHARSET_UTF_8);
    }

    public String sm3DigesterObject(String content) {
        return digester.digestHex(content);
    }

    public String sm3DigesterFile(File file) {
        return digester.digestHex(file);
    }

    public void initHybridEncryption(CipherMode cipherMode, boolean dynamic) {
        switch (cipherMode) {
            case SM4_RSA: {
                if (!dynamic) {
                    symmetricCryptos.put(CipherMode.SM4_RSA, (SymmetricCrypto)sm4);
                    rsaCiphertexts.put(CipherMode.SM4_RSA, rsa.encryptHex(SM4_KEY, KeyType.PublicKey));
                    break;
                }
                String sm4Key = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
                echo.info((Object)("\u504f\u79fb\u91cf\u4e0d\u53d8 \u4e34\u65f6sm4\u5bc6\u94a5---->" + sm4Key));
                rsaCiphertexts.put(CipherMode.SM4_RSA, rsa.encryptHex(sm4Key, StandardCharsets.UTF_8, KeyType.PublicKey));
                byte[] sm4KeyBytes = sm4Key.getBytes(StandardCharsets.UTF_8);
                byte[] sm4_Key = SecureUtil.generateKey((String)"SM4", (byte[])sm4KeyBytes).getEncoded();
                SM4 sm4Temp = new SM4(Mode.CTS, Padding.PKCS5Padding, sm4_Key, EncryptProvider.sm4Iv().getBytes(StandardCharsets.UTF_8));
                symmetricCryptos.put(CipherMode.SM4_RSA, (SymmetricCrypto)sm4Temp);
                break;
            }
            case AES_RSA: {
                if (!dynamic) {
                    symmetricCryptos.put(CipherMode.AES_RSA, (SymmetricCrypto)aes);
                    rsaCiphertexts.put(CipherMode.AES_RSA, rsa.encryptHex(AES_KEY, KeyType.PublicKey));
                    break;
                }
                String aesKey = UUID.randomUUID().toString().replace("-", "");
                echo.info((Object)("\u504f\u79fb\u91cf\u4e0d\u53d8 \u4e34\u65f6aes\u5bc6\u94a5---->" + aesKey));
                rsaCiphertexts.put(CipherMode.AES_RSA, rsa.encryptHex(aesKey, StandardCharsets.UTF_8, KeyType.PublicKey));
                byte[] bytes = aesKey.getBytes(StandardCharsets.UTF_8);
                byte[] aes_key = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue(), (byte[])bytes).getEncoded();
                AES aesTemp = new AES(Mode.CTS, Padding.PKCS5Padding, aes_key, EncryptProvider.aesIv().getBytes(StandardCharsets.UTF_8));
                symmetricCryptos.put(CipherMode.AES_RSA, (SymmetricCrypto)aesTemp);
                break;
            }
            default: {
                throw new RuntimeException(cipherMode + "\u4e0d\u5b58\u5728\u8be5\u6df7\u5408\u6a21\u5f0f\uff01\uff01\uff01");
            }
        }
    }

    public void initHybridDecryption(CipherMode cipherMode, boolean dynamic) {
        switch (cipherMode) {
            case SM4_RSA: {
                if (!dynamic) {
                    symmetricCryptos.put(CipherMode.SM4_RSA, (SymmetricCrypto)sm4);
                    break;
                }
                String sm4Key = rsaCiphertexts.get((Object)CipherMode.SM4_RSA);
                if (!Objects.nonNull(sm4Key)) break;
                byte[] sm4KeyBytes = sm4Key.getBytes(StandardCharsets.UTF_8);
                byte[] sm4_Key = SecureUtil.generateKey((String)"SM4", (byte[])sm4KeyBytes).getEncoded();
                SM4 sm4Temp = new SM4(Mode.CTS, Padding.PKCS5Padding, sm4_Key, EncryptProvider.sm4Iv().getBytes(StandardCharsets.UTF_8));
                symmetricCryptos.put(CipherMode.SM4_RSA, (SymmetricCrypto)sm4Temp);
                break;
            }
            case AES_RSA: {
                if (!dynamic) {
                    symmetricCryptos.put(CipherMode.AES_RSA, (SymmetricCrypto)aes);
                    break;
                }
                String aesKey = rsaCiphertexts.get((Object)CipherMode.AES_RSA);
                if (!Objects.nonNull(aesKey)) break;
                byte[] bytes = aesKey.getBytes(StandardCharsets.UTF_8);
                byte[] aes_key = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue(), (byte[])bytes).getEncoded();
                AES aesTemp = new AES(Mode.CTS, Padding.PKCS5Padding, aes_key, EncryptProvider.aesIv().getBytes(StandardCharsets.UTF_8));
                symmetricCryptos.put(CipherMode.AES_RSA, (SymmetricCrypto)aesTemp);
                break;
            }
            default: {
                throw new RuntimeException(cipherMode + "\u4e0d\u5b58\u5728\u8be5\u6df7\u5408\u6a21\u5f0f\uff01\uff01\uff01");
            }
        }
    }

    public static String getSm4KeyRSACiphertext() {
        return rsaCiphertexts.get((Object)CipherMode.SM4_RSA);
    }

    public static String getAesKeyRSACiphertext() {
        return rsaCiphertexts.get((Object)CipherMode.AES_RSA);
    }

    public static void setRSACiphertextForSM4Key(String sm4RSACiphertext) {
        if (!StringUtils.hasText((String)sm4RSACiphertext)) {
            throw new RuntimeException("\u6ca1\u6709\u83b7\u53d6\u5230\u5bc6\u94a5" + HoneyBadgerEncrypt.class.getSimpleName());
        }
        String sm4Key = rsa.decryptStr(sm4RSACiphertext, KeyType.PrivateKey, StandardCharsets.UTF_8);
        rsaCiphertexts.put(CipherMode.SM4_RSA, sm4Key);
    }

    public static void setRSACiphertextForAESKey(String aesKeyRSACiphertext) {
        if (!StringUtils.hasText((String)aesKeyRSACiphertext)) {
            throw new RuntimeException("\u6ca1\u6709\u83b7\u53d6\u5230\u5bc6\u94a5" + HoneyBadgerEncrypt.class.getSimpleName());
        }
        String aesKey = rsa.decryptStr(aesKeyRSACiphertext, KeyType.PrivateKey, StandardCharsets.UTF_8);
        rsaCiphertexts.put(CipherMode.AES_RSA, aesKey);
    }

    public String sm4RsaDecrypt(String encrypt) {
        SM4 sm4HybridEncryption = (SM4)symmetricCryptos.get((Object)CipherMode.SM4_RSA);
        Assert.notNull((Object)sm4HybridEncryption, (String)"\u4f60\u8fd8\u6ca1\u6709\u914d\u7f6e\u5bc6\u94a5 \u6216\u8bb8\u4f60\u7684\u62e6\u622a\u5668|\u8fc7\u6ee4\u5668\u6ca1\u6709\u751f\u6548setRSACiphertextForSM4Key(String sm4RSACiphertext)");
        return sm4HybridEncryption.decryptStr(encrypt, StandardCharsets.UTF_8);
    }

    public String sm4RsaEncrypt(String content) {
        SM4 sm4HybridEncryption = (SM4)symmetricCryptos.get((Object)CipherMode.SM4_RSA);
        return sm4HybridEncryption.encryptHex(content);
    }

    public String aesRsaEncrypt(String content) {
        AES aesHybridEncryption = (AES)symmetricCryptos.get((Object)CipherMode.AES_RSA);
        return aesHybridEncryption.encryptHex(content);
    }

    public String aesRsaDecrypt(String encrypt) {
        AES aesHybridEncryption = (AES)symmetricCryptos.get((Object)CipherMode.AES_RSA);
        Assert.notNull((Object)aesHybridEncryption, (String)"\u4f60\u8fd8\u6ca1\u6709\u914d\u7f6e\u5bc6\u94a5 \u6216\u8bb8\u4f60\u7684\u62e6\u622a\u5668|\u8fc7\u6ee4\u5668\u6ca1\u6709\u751f\u6548setRSACiphertextForAESKey(String aesKeyRSACiphertext)");
        return aesHybridEncryption.decryptStr(encrypt, StandardCharsets.UTF_8);
    }

    static {
        digester = DigestUtil.digester((String)"sm3");
        rsaCiphertexts = new ConcurrentHashMap();
        symmetricCryptos = new ConcurrentHashMap();
    }
}

