/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.aspectj;

import cloud.longfa.encrypt.anotation.Decrypt;
import cloud.longfa.encrypt.anotation.Encrypt;
import cloud.longfa.encrypt.badger.HoneyBadgerEncrypt;
import cloud.longfa.encrypt.enums.CipherMode;
import cloud.longfa.encrypt.handler.ScenarioHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;

@Order(value=1)
@Aspect
public class EncryptHandler {
    public static final Log echo = LogFactory.getLog(EncryptHandler.class);
    private final HoneyBadgerEncrypt honeyBadgerEncrypt;

    public EncryptHandler(@NonNull HoneyBadgerEncrypt honeyBadgerEncrypt) {
        this.honeyBadgerEncrypt = honeyBadgerEncrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(encrypt)")
    public Object encrypt(ProceedingJoinPoint joinPoint, Encrypt encrypt) throws Throwable {
        if (encrypt.cipher().equals((Object)CipherMode.SM4_RSA) || encrypt.cipher().equals((Object)CipherMode.AES_RSA)) {
            this.honeyBadgerEncrypt.initHybridEncryption(encrypt.cipher(), encrypt.dynamic());
        }
        try {
            Object object = ScenarioHolder.scenarioSchedule(joinPoint);
            return object;
        }
        finally {
            HoneyBadgerEncrypt.rsaCiphertexts.clear();
            HoneyBadgerEncrypt.symmetricCryptos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(decrypt)")
    public Object decrypt(ProceedingJoinPoint joinPoint, Decrypt decrypt) throws Throwable {
        if (decrypt.cipher().equals((Object)CipherMode.SM4_RSA) || decrypt.cipher().equals((Object)CipherMode.AES_RSA)) {
            this.honeyBadgerEncrypt.initHybridDecryption(decrypt.cipher(), decrypt.dynamic());
        }
        try {
            Object object = ScenarioHolder.scenarioSchedule(joinPoint);
            return object;
        }
        finally {
            HoneyBadgerEncrypt.rsaCiphertexts.clear();
            HoneyBadgerEncrypt.symmetricCryptos.clear();
        }
    }
}

