/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.config;

import cloud.longfa.encrypt.config.EncryptProvider;
import cloud.longfa.encrypt.enums.CipherMode;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.RSA;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="badger.encrypt")
public class RSAConfiguration
extends EncryptProvider
implements InitializingBean {
    private static final RSA rsa = new RSA(AsymmetricAlgorithm.RSA.toString());
    private static final String PRIVATE_KEY64 = rsa.getPrivateKeyBase64();
    private static final String PUBLIC_KEY64 = rsa.getPublicKeyBase64();
    private String privateKeyBase64;
    private String publicKeyBase64;

    public void setPrivateKeyBase64(String privateKeyBase64) {
        this.privateKeyBase64 = privateKeyBase64;
    }

    public void setPublicKeyBase64(String publicKeyBase64) {
        this.publicKeyBase64 = publicKeyBase64;
    }

    public String getPrivateKeyBase64() {
        if (StringUtils.hasText((String)this.privateKeyBase64)) {
            return this.privateKeyBase64;
        }
        return PRIVATE_KEY64;
    }

    public String getPublicKeyBase64() {
        if (StringUtils.hasText((String)this.publicKeyBase64)) {
            return this.publicKeyBase64;
        }
        return PUBLIC_KEY64;
    }

    public void afterPropertiesSet() {
        EncryptProvider.encryptFactory.put(CipherMode.RSA, this);
    }
}

