/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.config;

import cloud.longfa.encrypt.config.AESConfiguration;
import cloud.longfa.encrypt.config.RSAConfiguration;
import cloud.longfa.encrypt.config.SM4Configuration;
import cloud.longfa.encrypt.enums.CipherMode;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EncryptProvider {
    protected static final String BADGER = "badger.encrypt";
    public static final ConcurrentHashMap<CipherMode, EncryptProvider> encryptFactory = new ConcurrentHashMap();

    public static String aesKey() {
        AESConfiguration aesConfiguration = (AESConfiguration)encryptFactory.get((Object)CipherMode.AES);
        return aesConfiguration.getAesKey();
    }

    public static String aesIv() {
        AESConfiguration aesConfiguration = (AESConfiguration)encryptFactory.get((Object)CipherMode.AES);
        return aesConfiguration.getAesIv();
    }

    public static String privateKeyBase64() {
        RSAConfiguration rsaConfiguration = (RSAConfiguration)encryptFactory.get((Object)CipherMode.RSA);
        return rsaConfiguration.getPrivateKeyBase64();
    }

    public static String publicKeyBase64() {
        RSAConfiguration rsaConfiguration = (RSAConfiguration)encryptFactory.get((Object)CipherMode.RSA);
        return rsaConfiguration.getPublicKeyBase64();
    }

    public static String sm4Key() {
        SM4Configuration sm4Configuration = (SM4Configuration)encryptFactory.get((Object)CipherMode.SM4);
        return sm4Configuration.getSm4Key();
    }

    public static String sm4Iv() {
        SM4Configuration sm4Configuration = (SM4Configuration)encryptFactory.get((Object)CipherMode.SM4);
        return sm4Configuration.getSm4Iv();
    }
}

