/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.config;

import cloud.longfa.encrypt.aspectj.EncryptHandler;
import cloud.longfa.encrypt.badger.HoneyBadgerEncrypt;
import cloud.longfa.encrypt.config.EncryptProvider;
import cloud.longfa.encrypt.handler.ExecutorPostProcessor;
import cloud.longfa.encrypt.handler.ScenarioEncryptSchedule;
import cloud.longfa.encrypt.handler.ScenarioHandler;
import cloud.longfa.encrypt.handler.ScenarioHolder;
import cloud.longfa.encrypt.handler.ScenarioPostProcessor;
import cloud.longfa.encrypt.handler.ScenarioSchedule;
import cloud.longfa.encrypt.handler.StorageScenario;
import cloud.longfa.encrypt.handler.TransmitScenario;
import cloud.longfa.encrypt.register.RegisterBeanDefinition;
import cloud.longfa.encrypt.spel.SpELExpressionHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class EncryptAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={EncryptProvider.class})
    public EncryptHandler encryptHandler(HoneyBadgerEncrypt honeyBadgerEncrypt) {
        return new EncryptHandler(honeyBadgerEncrypt);
    }

    @Bean
    @ConditionalOnBean(value={EncryptHandler.class})
    public ScenarioSchedule scenarioEncryptSchedule() {
        ScenarioEncryptSchedule scenarioEncryptSchedule = new ScenarioEncryptSchedule();
        ScenarioHolder.scenarioSchedules.add(scenarioEncryptSchedule);
        return scenarioEncryptSchedule;
    }

    @Bean
    @ConditionalOnMissingBean(value={StorageScenario.class})
    public StorageScenario storageScenario() {
        return new StorageScenario();
    }

    @Bean
    @ConditionalOnMissingBean(value={TransmitScenario.class})
    public TransmitScenario transmitScenario() {
        return new TransmitScenario();
    }

    @Bean
    @ConditionalOnBean(value={ScenarioHandler.class})
    public ScenarioPostProcessor scenarioPostProcessor() {
        return new ScenarioPostProcessor();
    }

    @Bean
    public RegisterBeanDefinition beanFactoryPostProcessor() {
        return new RegisterBeanDefinition();
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnBean(value={EncryptHandler.class})
    public HoneyBadgerEncrypt getHoneyBadgerEncrypt() {
        HoneyBadgerEncrypt honeyBadgerEncrypt;
        ScenarioHandler.honeyBadgerEncrypt = honeyBadgerEncrypt = new HoneyBadgerEncrypt();
        return honeyBadgerEncrypt;
    }

    public Executor executor() {
        return new ThreadPoolExecutor(2, 50, 30L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Bean(value={"executorPostProcessor"})
    @ConditionalOnBean(name={"encryptThreadPoolExecutor"})
    public ExecutorPostProcessor executorPostProcessor() {
        return new ExecutorPostProcessor();
    }

    @Bean(value={"encrypt-SpELExpressionHandler"})
    @ConditionalOnBean(value={EncryptHandler.class})
    public SpELExpressionHandler spELExpressionHandler(SpelExpressionParser spelExpressionParser) {
        SpELExpressionHandler spELExpressionHandler = new SpELExpressionHandler();
        spELExpressionHandler.setSpelExpressionParser(spelExpressionParser);
        return spELExpressionHandler;
    }

    @Bean(value={"encrypt-SpelExpressionParser"})
    @ConditionalOnBean(name={"encrypt-SpELExpressionHandler"})
    public SpelExpressionParser spelExpressionParser() {
        return new SpelExpressionParser();
    }

    public static void main(String[] args) {
    }
}

