/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.util;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;

public class EncryptUtils {
    public static final byte[] SERVER_KEY = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue()).getEncoded();
    public static final byte[] SERVER_IV = Arrays.copyOfRange(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8), 0, 16);
    public static final SymmetricCrypto sm4 = new SymmetricCrypto("SM4");
    public static RSA rsa = new RSA(AsymmetricAlgorithm.RSA.toString());
    public static String PRIVATE_KEY;
    public static String PUBLIC_KEY;
    public static final Digester digester;

    public static String aesEncrypt(String content) {
        AES aes = new AES(Mode.CTS, Padding.PKCS5Padding, SERVER_KEY, SERVER_IV);
        if (content.isEmpty()) {
            throw new RuntimeException("\u52a0\u5bc6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] encrypt = aes.encrypt(content);
        return aes.encryptHex(encrypt);
    }

    public static String aesDecrypt(String encrypt, byte[] key, byte[] iv) {
        if (key.length == 0) {
            throw new RuntimeException("\u6ca1\u6709\u5bc6\u94a5");
        }
        if (iv.length == 0) {
            throw new RuntimeException("\u6ca1\u6709\u504f\u79fb\u91cf");
        }
        AES aes = new AES(Mode.CTS, Padding.PKCS5Padding, key, iv);
        byte[] decrypt = aes.decrypt(encrypt);
        return aes.decryptStr(decrypt);
    }

    public static String sm4Encrypt(String context) {
        if (context.isEmpty()) {
            throw new RuntimeException("\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return sm4.encryptHex(context);
    }

    public static String sm4Decrypt(String encrypt) {
        if (encrypt.isEmpty()) {
            throw new RuntimeException("\u5bc6\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return sm4.decryptStr(encrypt, CharsetUtil.CHARSET_UTF_8);
    }

    public static String rsaEncrypt(String content) {
        return rsa.encryptHex(content, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
    }

    public static String rsaDecrypt(String encrypt) {
        return rsa.decryptStr(encrypt, KeyType.PrivateKey, CharsetUtil.CHARSET_UTF_8);
    }

    public static String sm3DigesterObject(String content) {
        return digester.digestHex(content);
    }

    public static String sm3DigesterFile(File file) {
        return digester.digestHex(file);
    }

    static {
        digester = DigestUtil.digester((String)"SM3");
        PRIVATE_KEY = rsa.getPrivateKeyBase64();
        PUBLIC_KEY = rsa.getPublicKeyBase64();
        rsa = new RSA(AsymmetricAlgorithm.RSA.toString(), PRIVATE_KEY, PUBLIC_KEY);
        System.out.println("\u79c1\u94a5:" + PRIVATE_KEY + "\n\u516c\u94a5:" + PUBLIC_KEY);
    }
}

