/*
 * Decompiled with CFR 0.152.
 */
package cloud.longfa.encrypt.config;

import cloud.longfa.encrypt.config.EncryptProvider;
import cloud.longfa.encrypt.enums.CipherMode;
import java.util.UUID;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="badger.encrypt")
public class SM4Configuration
extends EncryptProvider
implements InitializingBean {
    private static final String SM4_KEY = UUID.randomUUID().toString().replace("-", "");
    private static final String SM4_IV = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    private String sm4Key;
    private String sm4Iv;

    public String getSm4Key() {
        if (StringUtils.hasText((String)this.sm4Key)) {
            return this.sm4Key;
        }
        return SM4_KEY;
    }

    public void setSm4Key(String sm4Key) {
        this.sm4Key = sm4Key;
    }

    public String getSm4Iv() {
        if (StringUtils.hasText((String)this.sm4Iv)) {
            return this.sm4Iv;
        }
        return SM4_IV;
    }

    public void setSm4Iv(String sm4Iv) {
        this.sm4Iv = sm4Iv;
    }

    public void afterPropertiesSet() {
        EncryptProvider.encryptFactory.put(CipherMode.SM4, this);
    }
}

